/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.api.open.service;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.delivery.enumerate.CheckStatusEnum;
import com.els.modules.quality.entity.PurchaseQualityCheckHead;
import com.els.modules.quality.entity.PurchaseQualityCheckItem;
import com.els.modules.quality.entity.SaleQualityCheckHead;
import com.els.modules.quality.entity.SaleQualityCheckItem;
import com.els.modules.quality.enumerate.CheckSourceTypeEnum;
import com.els.modules.quality.mapper.PurchaseQualityCheckHeadMapper;
import com.els.modules.quality.mapper.PurchaseQualityCheckItemMapper;
import com.els.modules.quality.mapper.SaleQualityCheckHeadMapper;
import com.els.modules.quality.mapper.SaleQualityCheckItemMapper;
import com.els.modules.quality.rpc.service.QualityInvokeSupplierRpcService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="sapPushQualityCheckOpenServiceImpl")
public class SapPushQualityCheckOpenServiceImpl
implements SimpleOpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(SapPushQualityCheckOpenServiceImpl.class);
    @Resource
    private PurchaseQualityCheckHeadMapper purchaseQualityCheckHeadMapper;
    @Resource
    private PurchaseQualityCheckItemMapper purchaseQualityCheckItemMapper;
    @Resource
    private SaleQualityCheckHeadMapper saleQualityCheckHeadMapper;
    @Resource
    private SaleQualityCheckItemMapper saleQualityCheckItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private QualityInvokeSupplierRpcService qualityInvokeSupplierRpcService;

    public JSONObject invoke(JSONObject jsonObject) {
        log.info("SAP\u6279\u91cf\u63a8\u9001\u7684\u8d28\u91cf\u68c0\u6d4b\u53c2\u6570\uff1a{}", (Object)jsonObject.toJSONString());
        JSONObject result = new JSONObject();
        result.put("success", (Object)false);
        Map<String, Object> resultMap = this.getParamCheckResultAndDataList(jsonObject);
        if (!Objects.isNull(resultMap.get("checkResult"))) {
            String checkResult = (String)resultMap.get("checkResult");
            log.error("\u4fdd\u5b58SAP\u63a8\u9001\u8d28\u91cf\u68c0\u6d4b\u6570\u636e\u5f02\u5e38:{}", (Object)checkResult);
            result.put("code", (Object)-1);
            result.put("msg", (Object)checkResult);
            return result;
        }
        List dataList = (List)resultMap.get("dataList");
        dataList.forEach(dataMap -> {
            PurchaseQualityCheckHead head = (PurchaseQualityCheckHead)((Object)((Object)dataMap.get("head")));
            this.purchaseQualityCheckHeadMapper.insert((Object)head);
            List itemList = (List)dataMap.get("itemList");
            itemList.forEach(item -> item.setHeadId(head.getId()));
            this.purchaseQualityCheckItemMapper.insertBatchSomeColumn(itemList);
            String saleId = this.syncToSupplier(head, itemList);
            PurchaseQualityCheckHead updateHead = new PurchaseQualityCheckHead();
            updateHead.setId(head.getId());
            updateHead.setSendStatus("1");
            updateHead.setRelationId(saleId);
            this.purchaseQualityCheckHeadMapper.updateById((Object)updateHead);
        });
        result.put("success", (Object)true);
        result.put("code", (Object)CommonConstant.SC_OK_200);
        return result;
    }

    private Map<String, Object> getParamCheckResultAndDataList(JSONObject jsonObject) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder checkResultStr = new StringBuilder("");
        String headStr = jsonObject.getString("headList");
        if (StringUtils.isBlank((CharSequence)headStr) || !headStr.trim().startsWith("[")) {
            checkResultStr.append("\u53c2\u6570\u5bf9\u8c61headList\u5fc5\u987b\u4ee5'['\u5b57\u7b26\u5f00\u59cb;");
            resultMap.put("checkResult", checkResultStr.toString());
            return resultMap;
        }
        ArrayList dataList = new ArrayList();
        List headList = jsonObject.getJSONArray("headList").toJavaList(JSONObject.class);
        for (JSONObject headJson : headList) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            String itemStr = headJson.getString("purchaseQualityCheckItemList");
            if (StringUtils.isBlank((CharSequence)itemStr) || !itemStr.trim().startsWith("[")) {
                checkResultStr.append("\u53c2\u6570\u5bf9\u8c61purchaseQualityCheckItemList\u5fc5\u987b\u4ee5'['\u5b57\u7b26\u5f00\u59cb;");
                resultMap.put("checkResult", checkResultStr.toString());
                return resultMap;
            }
            PurchaseQualityCheckHead head = this.convertHeadInfo(headJson);
            dataMap.put("head", (Object)head);
            List<PurchaseQualityCheckItem> itemList = this.convertItemList(itemStr, head);
            if (itemList.isEmpty()) {
                checkResultStr.append("\u53c2\u6570\u5bf9\u8c61purchaseQualityCheckItemList\u4e0d\u80fd\u4e3a\u7a7a;");
                resultMap.put("checkResult", checkResultStr.toString());
                return resultMap;
            }
            dataMap.put("itemList", itemList);
            dataList.add(dataMap);
        }
        resultMap.put("dataList", dataList);
        return resultMap;
    }

    private PurchaseQualityCheckHead convertHeadInfo(JSONObject jsonObject) {
        PurchaseQualityCheckHead head = (PurchaseQualityCheckHead)((Object)JSONObject.parseObject((String)jsonObject.toJSONString(), PurchaseQualityCheckHead.class));
        head.setSrmReceiptNumber(jsonObject.getString("sourceNumber"));
        head.setPublishAudit("0");
        head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        head.setCheckStatus(CheckStatusEnum.CHECK_DONE.getValue());
        head.setSourceType(CheckSourceTypeEnum.OUT_SYS.getValue());
        head.setResultSyncSupplier("1");
        SupplierMasterDataDTO supplier = this.qualityInvokeSupplierRpcService.getBySupplierCode(head.getSupplierCode());
        head.setToElsAccount(supplier.getToElsAccount());
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("qualityCheck");
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_businessTemplate", (String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        TemplateHeadDTO templateHead = (TemplateHeadDTO)templateList.get(0);
        head.setTemplateName(templateHead.getTemplateName());
        head.setTemplateNumber(templateHead.getTemplateNumber());
        head.setTemplateVersion(templateHead.getTemplateVersion());
        head.setTemplateAccount(templateHead.getElsAccount());
        return head;
    }

    private List<PurchaseQualityCheckItem> convertItemList(String itemStr, PurchaseQualityCheckHead head) {
        List jsonObjectList = JSONArray.parseArray((String)itemStr, JSONObject.class);
        return jsonObjectList.stream().map(jsonObject -> {
            PurchaseQualityCheckItem item = (PurchaseQualityCheckItem)((Object)((Object)JSONObject.parseObject((String)jsonObject.toJSONString(), PurchaseQualityCheckItem.class)));
            String checkResult = jsonObject.getString("checkResult");
            item.setTestResult("1".equals(checkResult) ? "0" : "1");
            item.setCheckNumber(head.getCheckNumber());
            SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            return item;
        }).collect(Collectors.toList());
    }

    private String syncToSupplier(PurchaseQualityCheckHead head, List<PurchaseQualityCheckItem> itemList) {
        SaleQualityCheckHead saleHead = new SaleQualityCheckHead();
        BeanUtil.copyProperties((Object)((Object)head), (Object)((Object)saleHead), (String[])new String[0]);
        saleHead.setId(IdWorker.getIdStr());
        saleHead.setRelationId(head.getId());
        saleHead.setElsAccount(head.getToElsAccount());
        saleHead.setToElsAccount(head.getElsAccount());
        this.saleQualityCheckHeadMapper.insert((Object)saleHead);
        ArrayList<SaleQualityCheckItem> saleItemList = new ArrayList<SaleQualityCheckItem>();
        for (PurchaseQualityCheckItem item : itemList) {
            SaleQualityCheckItem saleItem = new SaleQualityCheckItem();
            BeanUtil.copyProperties((Object)((Object)item), (Object)((Object)saleItem), (String[])new String[0]);
            saleItem.setId(null);
            saleItem.setHeadId(saleHead.getId());
            saleItem.setRelationId(item.getId());
            saleItem.setCheckNumber(saleHead.getCheckNumber());
            saleItem.setItemNumber(saleHead.getId());
            saleItem.setElsAccount(saleHead.getElsAccount());
            saleItemList.add(saleItem);
        }
        this.saleQualityCheckItemMapper.insertBatchSomeColumn(saleItemList);
        return saleHead.getId();
    }
}

