/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.sample.entity.PurchaseSampleCheckHead;
import com.els.modules.sample.entity.PurchaseSampleCheckItem;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.entity.PurchaseSampleTrackingItem;
import com.els.modules.sample.enumerate.PurchaseSampleCheckHeadEnum;
import com.els.modules.sample.enumerate.PurchaseSampleItemCheckStatusEnum;
import com.els.modules.sample.enumerate.SampleUseLinkEnum;
import com.els.modules.sample.mapper.PurchaseSampleCheckHeadMapper;
import com.els.modules.sample.mapper.PurchaseSampleCheckItemMapper;
import com.els.modules.sample.mapper.PurchaseSampleTrackingItemMapper;
import com.els.modules.sample.service.PurchaseSampleCheckHeadService;
import com.els.modules.sample.service.PurchaseSampleCheckItemService;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PurchaseSampleCheckHeadServiceImpl
extends BaseServiceImpl<PurchaseSampleCheckHeadMapper, PurchaseSampleCheckHead>
implements PurchaseSampleCheckHeadService {
    @Resource
    private PurchaseSampleCheckHeadMapper purchaseSampleCheckHeadMapper;
    @Resource
    private PurchaseSampleCheckItemMapper purchaseSampleCheckItemMapper;
    @Resource
    private PurchaseSampleCheckItemService purchaseSampleCheckItemService;
    @Resource
    private PurchaseSampleTrackingItemMapper purchaseSampleTrackingItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseSampleItemService purchaseSampleItemService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseSampleCheckHead.setCheckNumber(this.invokeBaseRpcService.getNextCode("srmSampleCheckNumber", (Object)purchaseSampleCheckHead));
        purchaseSampleCheckHead.setCheckStatus(PurchaseSampleCheckHeadEnum.NEW.getValue());
        if ("1".equals(purchaseSampleCheckHead.getResultAudit())) {
            purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseSampleCheckHeadMapper.insert((Object)purchaseSampleCheckHead);
        this.insertData(purchaseSampleCheckHead, purchaseSampleCheckItemList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, Integer type) {
        Date now = new Date();
        if (type != null && 2 == type) {
            purchaseSampleCheckHead.setCheckStartDate(now);
        }
        if ("1".equals(purchaseSampleCheckHead.getResultAudit())) {
            purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseSampleCheckHeadMapper.updateById((Object)purchaseSampleCheckHead);
        this.purchaseSampleCheckItemMapper.deleteByMainId(purchaseSampleCheckHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseSampleCheckHead.getId());
        this.insertData(purchaseSampleCheckHead, purchaseSampleCheckItemList, purchaseAttachmentList);
        if (type != null && 2 == type) {
            PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
            trackingItem.setHeadId(purchaseSampleCheckHead.getSampleHeadId());
            trackingItem.setSampleNumber(purchaseSampleCheckHead.getCheckNumber());
            trackingItem.setSampleId(purchaseSampleCheckHead.getId());
            trackingItem.setPurchasePrincipal(purchaseSampleCheckHead.getPrincipal());
            trackingItem.setActualBeginTime(now);
            trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_ING.getValue());
            trackingItem.setCheckResult(purchaseSampleCheckHead.getCheckResult());
            trackingItem.setQualified(purchaseSampleCheckHead.getQualified());
            trackingItem.setSampleUseLink(SampleUseLinkEnum.CHEAK.getValue());
            this.purchaseSampleTrackingItemMapper.insert((Object)trackingItem);
            UpdateWrapper sampleItemQueryWrapper = new UpdateWrapper();
            sampleItemQueryWrapper.lambda().eq(BaseEntity::getId, (Object)purchaseSampleCheckHead.getSampleItemId());
            sampleItemQueryWrapper.lambda().set(PurchaseSampleItem::getCheckStatus, (Object)PurchaseSampleItemCheckStatusEnum.TEST_ING.getValue());
            this.purchaseSampleItemService.update((Wrapper)sampleItemQueryWrapper);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void resultRecord(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, Integer type) {
        Date now = new Date();
        if (type != null && 2 == type && "0".equals(purchaseSampleCheckHead.getResultAudit())) {
            purchaseSampleCheckHead.setCheckEndDate(now);
        }
        this.purchaseSampleCheckHeadMapper.updateById((Object)purchaseSampleCheckHead);
        for (PurchaseSampleCheckItem entity : purchaseSampleCheckItemList) {
            this.purchaseSampleCheckItemMapper.updateById((Object)entity);
        }
        if (!purchaseAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseSampleCheckHead.getId());
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
        if (type != null && 2 == type) {
            PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
            trackingItem.setSampleId(purchaseSampleCheckHead.getId());
            trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
            trackingItem.setCheckResult(purchaseSampleCheckHead.getCheckResult());
            trackingItem.setQualified(purchaseSampleCheckHead.getQualified());
            if ("0".equals(purchaseSampleCheckHead.getResultAudit())) {
                trackingItem.setActualEndTime(now);
                if (purchaseSampleCheckHead.getCheckStartDate() != null) {
                    trackingItem.setEstimatedTimePeriod(String.valueOf((now.getTime() - purchaseSampleCheckHead.getCheckStartDate().getTime()) / 86400000L));
                }
                UpdateWrapper sampleItemQueryWrapper = new UpdateWrapper();
                sampleItemQueryWrapper.lambda().eq(BaseEntity::getId, (Object)purchaseSampleCheckHead.getSampleItemId());
                sampleItemQueryWrapper.lambda().set(PurchaseSampleItem::getCheckStatus, (Object)PurchaseSampleItemCheckStatusEnum.TEST_END.getValue());
                this.purchaseSampleItemService.update((Wrapper)sampleItemQueryWrapper);
            }
            this.purchaseSampleTrackingItemMapper.updateBySampleId(trackingItem);
        }
    }

    private void insertData(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (purchaseSampleCheckItemList != null && !purchaseSampleCheckItemList.isEmpty()) {
            for (PurchaseSampleCheckItem entity : purchaseSampleCheckItemList) {
                entity.setHeadId(purchaseSampleCheckHead.getId());
                entity.setCheckNumber(purchaseSampleCheckHead.getCheckNumber());
                entity.setId(null);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSampleCheckHead);
            }
            this.purchaseSampleCheckItemService.saveBatch(purchaseSampleCheckItemList);
        }
        if (purchaseAttachmentList != null && !purchaseAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSampleCheckItemMapper.deleteByMainId(id);
        this.purchaseSampleCheckHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSampleCheckItemMapper.deleteByMainId(serializable.toString());
            this.purchaseSampleCheckHeadMapper.deleteById(serializable);
        }
    }
}

