/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.advice.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.advice.entity.ComplaintAdviceHead;
import com.els.modules.advice.entity.ComplaintAdviceRecord;
import com.els.modules.advice.service.ComplaintAdviceHeadService;
import com.els.modules.advice.service.ComplaintAdviceRecordService;
import com.els.modules.advice.vo.ComplaintAdviceHeadVO;
import com.els.modules.advice.vo.OperateVO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.workorder.vo.ScoreResultVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/other/complaintAdviceHead"})
@Api(tags={"\u6295\u8bc9\u5efa\u8bae\u7ba1\u7406"})
public class ComplaintAdviceHeadController
extends BaseController<ComplaintAdviceHead, ComplaintAdviceHeadService> {
    @Autowired
    private ComplaintAdviceHeadService complaintAdviceHeadService;
    @Autowired
    private ComplaintAdviceRecordService complaintAdviceRecordService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ComplaintAdviceHead complaintAdviceHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)complaintAdviceHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.complaintAdviceHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    public Result<?> queryTabsCount(ComplaintAdviceHead head, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"advice_status", "count(0) as participateQuantity"}).eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"advice_status");
        List list = ((ComplaintAdviceHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(ComplaintAdviceHead::getAdviceStatus, ComplaintAdviceHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "adviceStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("adviceStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "adviceStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(busModule="\u6295\u8bc9\u5efa\u8bae\u7ba1\u7406", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ComplaintAdviceHeadVO complaintAdviceHeadPage) {
        ComplaintAdviceHead complaintAdviceHead = new ComplaintAdviceHead();
        BeanUtils.copyProperties((Object)((Object)complaintAdviceHeadPage), (Object)((Object)complaintAdviceHead));
        this.complaintAdviceHeadService.saveMain(complaintAdviceHead, complaintAdviceHeadPage.getComplaintAdviceRecordList());
        return Result.ok((Object)((Object)complaintAdviceHead));
    }

    @AutoLog(busModule="\u6295\u8bc9\u5efa\u8bae\u7ba1\u7406", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ComplaintAdviceHeadVO complaintAdviceHeadPage) {
        ComplaintAdviceHead complaintAdviceHead = new ComplaintAdviceHead();
        BeanUtils.copyProperties((Object)((Object)complaintAdviceHeadPage), (Object)((Object)complaintAdviceHead));
        this.complaintAdviceHeadService.updateMain(complaintAdviceHead, complaintAdviceHeadPage.getComplaintAdviceRecordList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6295\u8bc9\u5efa\u8bae\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.complaintAdviceHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ComplaintAdviceHead complaintAdviceHead = (ComplaintAdviceHead)((Object)this.complaintAdviceHeadService.getById((Serializable)((Object)id)));
        ComplaintAdviceHeadVO complaintAdviceHeadVO = new ComplaintAdviceHeadVO();
        BeanUtils.copyProperties((Object)((Object)complaintAdviceHead), (Object)((Object)complaintAdviceHeadVO));
        List<ComplaintAdviceRecord> complaintAdviceRecordList = this.complaintAdviceRecordService.selectByMainId(id);
        complaintAdviceHeadVO.setComplaintAdviceRecordList(complaintAdviceRecordList);
        return Result.ok((Object)((Object)complaintAdviceHeadVO));
    }

    @AutoLog(busModule="\u6295\u8bc9\u5efa\u8bae\u7ba1\u7406", value="\u63d0\u4ea4\u5355\u636e")
    @ApiOperation(value="\u63d0\u4ea4\u5355\u636e", notes="\u63d0\u4ea4\u5355\u636e")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody ComplaintAdviceHead complaintAdviceHead) {
        this.complaintAdviceHeadService.submit(complaintAdviceHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6295\u8bc9\u5efa\u8bae\u7ba1\u7406", value="\u53d1\u9001\u6d88\u606f")
    @ApiOperation(value="\u53d1\u9001\u6d88\u606f", notes="\u53d1\u9001\u6d88\u606f")
    @PostMapping(value={"/sendMsg"})
    public Result<?> sendMsg(@RequestBody OperateVO operateVO) {
        ComplaintAdviceRecord record = this.complaintAdviceHeadService.sendMsg(operateVO);
        return Result.ok((Object)((Object)record));
    }

    @AutoLog(busModule="\u6295\u8bc9\u5efa\u8bae\u7ba1\u7406", value="\u5173\u95ed\u5355\u636e")
    @ApiOperation(value="\u5173\u95ed\u5355\u636e", notes="\u5173\u95ed\u5355\u636e")
    @PostMapping(value={"/close"})
    public Result<?> close(@RequestBody OperateVO operateVO) {
        this.complaintAdviceHeadService.close(operateVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6295\u8bc9\u5efa\u8bae\u7ba1\u7406", value="\u91cd\u53d1\u6d88\u606f")
    @ApiOperation(value="\u91cd\u53d1\u6d88\u606f", notes="\u91cd\u53d1\u6d88\u606f")
    @PostMapping(value={"/retryRecord"})
    public Result<?> retryRecord(@RequestBody ComplaintAdviceRecord record) {
        ComplaintAdviceRecord adviceRecord = this.complaintAdviceHeadService.retryRecord(record);
        return Result.ok((Object)((Object)adviceRecord));
    }

    @AutoLog(busModule="\u6295\u8bc9\u5efa\u8bae\u7ba1\u7406", value="\u8bc4\u5206")
    @ApiOperation(value="\u8bc4\u5206", notes="\u8bc4\u5206")
    @PostMapping(value={"/score"})
    public Result<?> score(@RequestBody ScoreResultVO resultVO) {
        this.complaintAdviceHeadService.score(resultVO);
        return this.commonSuccessResult(3);
    }
}

