/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.advice.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.advice.entity.ComplaintAdviceRecord;
import com.els.modules.advice.service.ComplaintAdviceRecordService;
import com.els.modules.workorder.enumerate.ContentTypeEnum;
import com.els.modules.workorder.enumerate.RecordSendStatusEnum;
import com.els.modules.workorder.service.WorkOrderApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sendAdviceRecord")
public class AdviceRecordServiceImpl
implements WorkOrderApiService {
    @Autowired
    private ComplaintAdviceRecordService complaintAdviceRecordService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public String invoke(JSONObject param) {
        ComplaintAdviceRecord adviceRecord = (ComplaintAdviceRecord)((Object)JSON.parseObject((String)param.getJSONObject("record").toString(), ComplaintAdviceRecord.class));
        adviceRecord.setContentType(ContentTypeEnum.OTHER.getValue());
        adviceRecord.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        this.complaintAdviceRecordService.save((Object)adviceRecord);
        JSONObject msgBody = SysUtil.objectToJSON((Object)((Object)adviceRecord));
        msgBody.put("id", (Object)adviceRecord.getHeadId());
        msgBody.put("type", (Object)"message");
        this.redisUtil.publish("advice-record-srm-topic", (Object)msgBody.toJSONString());
        return "SUCCESS";
    }
}

