/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.trial.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.Html2Text;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.trial.entity.SaleTrialProductionHead;
import com.els.modules.trial.entity.SaleTrialProductionItem;
import com.els.modules.trial.service.SaleTrialProductionHeadService;
import com.els.modules.trial.service.SaleTrialProductionItemService;
import com.els.modules.trial.vo.SaleTrialProductionHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/trial/saleTrialProductionHead"})
@Api(tags={"\u9500\u552e\u8bd5\u5236\u5934\u4fe1\u606f"})
public class SaleTrialProductionHeadController
extends BaseController<SaleTrialProductionHead, SaleTrialProductionHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleTrialProductionHeadController.class);
    @Autowired
    private SaleTrialProductionHeadService saleTrialProductionHeadService;
    @Autowired
    private SaleTrialProductionItemService saleTrialProductionItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"trialProduction#saleTrialProductionHead:view"})
    public Result<?> queryPageList(SaleTrialProductionHead saleTrialProductionHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleTrialProductionHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleTrialProductionHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u9500\u552e\u8bd5\u5236\u5934\u4fe1\u606f", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"trialProduction#saleTrialProductionHead:add"})
    public Result<?> add(@RequestBody SaleTrialProductionHeadVO saleTrialProductionHeadPage) {
        SaleTrialProductionHead saleTrialProductionHead = new SaleTrialProductionHead();
        BeanUtils.copyProperties((Object)((Object)saleTrialProductionHeadPage), (Object)((Object)saleTrialProductionHead));
        this.saleTrialProductionHeadService.saveMain(saleTrialProductionHead, saleTrialProductionHeadPage.getPurchaseTrialProductionItemList());
        return Result.ok((Object)((Object)saleTrialProductionHead));
    }

    @AutoLog(busModule="\u9500\u552e\u8bd5\u5236\u5934\u4fe1\u606f", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"trialProduction#saleTrialProductionHead:edit"})
    public Result<?> edit(@RequestBody SaleTrialProductionHeadVO saleTrialProductionHeadPage) {
        SaleTrialProductionHead saleTrialProductionHead = new SaleTrialProductionHead();
        BeanUtils.copyProperties((Object)((Object)saleTrialProductionHeadPage), (Object)((Object)saleTrialProductionHead));
        this.saleTrialProductionHeadService.updateMain(saleTrialProductionHead, saleTrialProductionHeadPage.getPurchaseTrialProductionItemList(), 1);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9500\u552e\u8bd5\u5236\u5934\u4fe1\u606f", value="\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"trialProduction#saleTrialProductionHead:submit"})
    public Result<?> submit(@RequestBody SaleTrialProductionHeadVO saleTrialProductionHeadPage) {
        SaleTrialProductionHead saleTrialProductionHead = new SaleTrialProductionHead();
        BeanUtils.copyProperties((Object)((Object)saleTrialProductionHeadPage), (Object)((Object)saleTrialProductionHead));
        this.saleTrialProductionHeadService.updateMain(saleTrialProductionHead, saleTrialProductionHeadPage.getPurchaseTrialProductionItemList(), 2);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9500\u552e\u8bd5\u5236\u5934\u4fe1\u606f", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"trialProduction#saleTrialProductionHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleTrialProductionHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9500\u552e\u8bd5\u5236\u5934\u4fe1\u606f", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"trialProduction#saleTrialProductionHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.saleTrialProductionHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"trialProduction#saleTrialProductionHead:view"})
    public Result<?> queryById(@RequestParam(name="id") String id, @RequestParam(name="type", required=false) String type) {
        SaleTrialProductionHead saleTrialProductionHead = (SaleTrialProductionHead)((Object)this.saleTrialProductionHeadService.getById((Serializable)((Object)id)));
        if (!StringUtils.isEmpty((Object)type) && "view".equals(type)) {
            saleTrialProductionHead.setSampleStatus(Html2Text.getContent((String)saleTrialProductionHead.getSampleStatus()));
        }
        SaleTrialProductionHeadVO saleTrialProductionHeadVO = new SaleTrialProductionHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleTrialProductionHead), (Object)((Object)saleTrialProductionHeadVO));
        List<SaleTrialProductionItem> saleTrialProductionItemList = this.saleTrialProductionItemService.selectByMainId(id);
        saleTrialProductionHeadVO.setPurchaseTrialProductionItemList(saleTrialProductionItemList);
        List attachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleTrialProductionHeadVO.setSaleAttachmentList(attachmentList);
        return Result.ok((Object)((Object)saleTrialProductionHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u8bd5\u5236\u5934\u4fe1\u606fid\u67e5\u8be2\u9500\u552e\u8bd5\u5236\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u9500\u552e\u8bd5\u5236\u5934\u4fe1\u606fid\u67e5\u8be2\u9500\u552e\u8bd5\u5236\u884c\u4fe1\u606f")
    @GetMapping(value={"/querySaleTrialProductionItemByMainId"})
    public Result<?> querySaleTrialProductionItemListByMainId(@RequestParam(name="id") String id) {
        List<SaleTrialProductionItem> saleTrialProductionItemList = this.saleTrialProductionItemService.selectByMainId(id);
        return Result.ok(saleTrialProductionItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(SaleTrialProductionHead saleTrialProductionHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleTrialProductionHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"trial_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"trial_status");
        List list = ((SaleTrialProductionHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleTrialProductionHead::getTrialStatus, SaleTrialProductionHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "trialStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("trialStatus", TenantContext.getTenant());
        String[] statuses = new String[]{"2", "3", "4"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmContractStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "trialStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

