/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.eightReport.rpc.service.InvokeMainDataRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.quality.entity.PurchaseRetificationReviewTeam;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportItem;
import com.els.modules.quality.entity.SaleSupplierRectificationReportHead;
import com.els.modules.quality.entity.SaleSupplierRectificationReportItem;
import com.els.modules.quality.enumerate.SupplierRectificationPublishStatusEnum;
import com.els.modules.quality.enumerate.SupplierRectificationReviewResultStatusEnum;
import com.els.modules.quality.enumerate.SupplierRectificationStatusEnum;
import com.els.modules.quality.mapper.PurchaseRetificationReviewTeamMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportItemMapper;
import com.els.modules.quality.mapper.SaleSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.SaleSupplierRectificationReportItemMapper;
import com.els.modules.quality.service.PurchaseSupplierRectificationReportHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PurchaseSupplierRectificationReportHeadServiceImpl
extends BaseServiceImpl<PurchaseSupplierRectificationReportHeadMapper, PurchaseSupplierRectificationReportHead>
implements PurchaseSupplierRectificationReportHeadService {
    @Resource
    private PurchaseSupplierRectificationReportHeadMapper purchaseSupplierRectificationReportHeadMapper;
    @Resource
    private PurchaseSupplierRectificationReportItemMapper purchaseSupplierRectificationReportItemMapper;
    @Resource
    private PurchaseRetificationReviewTeamMapper purchaseRetificationReviewTeamMapper;
    @Resource
    private SaleSupplierRectificationReportHeadMapper saleSupplierRectificationReportHeadMapper;
    @Resource
    private SaleSupplierRectificationReportItemMapper saleSupplierRectificationReportItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InvokeMainDataRpcService invokeMainDataRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead, List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItemList, List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseSupplierRectificationReportHead.setDeleted(Integer.parseInt("0"));
        purchaseSupplierRectificationReportHead.setReportCode(this.invokeBaseRpcService.getNextCode("saleRetification", (Object)purchaseSupplierRectificationReportHead));
        if ("0".equals(purchaseSupplierRectificationReportHead.getPreAudit())) {
            purchaseSupplierRectificationReportHead.setPreAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseSupplierRectificationReportHead.setPreAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        if ("0".equals(purchaseSupplierRectificationReportHead.getResultAudit())) {
            purchaseSupplierRectificationReportHead.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseSupplierRectificationReportHead.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        purchaseSupplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.NEW.getValue());
        purchaseSupplierRectificationReportHead.setPublishStatus(SupplierRectificationPublishStatusEnum.UN_PUBLISH.getValue());
        purchaseSupplierRectificationReportHead.setApplicant(loginUser.getRealname());
        purchaseSupplierRectificationReportHead.setApplicantId(loginUser.getSubAccount());
        List<PurchaseOrganizationInfoDTO> deptOrgList = this.getDeptById(loginUser.getOrgCode());
        if (CollectionUtil.isNotEmpty(deptOrgList)) {
            String deptName = this.getDeptName(deptOrgList);
            String deptId = this.getDeptCode(deptOrgList);
            if (!StringUtils.isEmpty((Object)deptName)) {
                purchaseSupplierRectificationReportHead.setApplicantDepartment(deptName);
            }
            if (!StringUtils.isEmpty((Object)deptId)) {
                purchaseSupplierRectificationReportHead.setApplicantDepartmentId(deptId);
            }
        }
        purchaseSupplierRectificationReportHead.setBusAccount(TenantContext.getTenant());
        purchaseSupplierRectificationReportHead.setRelationId(IdWorker.getIdStr());
        purchaseSupplierRectificationReportHead.setRectificationDate(new Date());
        this.purchaseSupplierRectificationReportHeadMapper.insert((Object)purchaseSupplierRectificationReportHead);
        this.updateMain(purchaseSupplierRectificationReportHead, purchaseSupplierRectificationReportItemList, purchaseRetificationReviewTeamList, purchaseAttachmentList);
    }

    private String getDeptName(List<PurchaseOrganizationInfoDTO> deptOrgList) throws NullPointerException {
        if (CollectionUtil.isEmpty(deptOrgList)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < deptOrgList.size(); ++i) {
            PurchaseOrganizationInfoDTO purchaseOrganizationInfo = deptOrgList.get(i);
            if (StringUtils.isEmpty((Object)purchaseOrganizationInfo.getOrgName())) continue;
            sb.append(purchaseOrganizationInfo.getOrgName());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private String getDeptCode(List<PurchaseOrganizationInfoDTO> deptOrgList) throws NullPointerException {
        if (CollectionUtil.isEmpty(deptOrgList)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < deptOrgList.size(); ++i) {
            PurchaseOrganizationInfoDTO purchaseOrganizationInfo = deptOrgList.get(i);
            if (StringUtils.isEmpty((Object)purchaseOrganizationInfo.getOrgCode())) continue;
            sb.append(purchaseOrganizationInfo.getOrgCode());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private List<PurchaseOrganizationInfoDTO> getDeptById(String deptIds) {
        if (StringUtils.isEmpty((Object)deptIds)) {
            return new ArrayList<PurchaseOrganizationInfoDTO>();
        }
        String[] depts = deptIds.split(",");
        return this.invokeMainDataRpcService.selectOrgByIds(depts, "dept");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead, List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItemList, List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if ("0".equals(purchaseSupplierRectificationReportHead.getPreAudit())) {
            purchaseSupplierRectificationReportHead.setPreAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseSupplierRectificationReportHead.setPreAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        }
        if ("0".equals(purchaseSupplierRectificationReportHead.getResultAudit())) {
            purchaseSupplierRectificationReportHead.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseSupplierRectificationReportHead.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        int count = this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)purchaseSupplierRectificationReportHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseSupplierRectificationReportItemMapper.deleteByMainId(purchaseSupplierRectificationReportHead.getId());
        this.purchaseRetificationReviewTeamMapper.deleteByMainId(purchaseSupplierRectificationReportHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseSupplierRectificationReportHead.getId());
        this.insertData(purchaseSupplierRectificationReportHead, purchaseSupplierRectificationReportItemList, purchaseRetificationReviewTeamList, purchaseAttachmentList);
    }

    private void insertData(PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead, List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItemList, List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        for (PurchaseSupplierRectificationReportItem purchaseSupplierRectificationReportItem : purchaseSupplierRectificationReportItemList) {
            purchaseSupplierRectificationReportItem.setHeadId(purchaseSupplierRectificationReportHead.getId());
            purchaseSupplierRectificationReportItem.setRelationId(IdWorker.getIdStr());
            purchaseSupplierRectificationReportItem.setToElsAccount(purchaseSupplierRectificationReportHead.getToElsAccount());
            purchaseSupplierRectificationReportItem.setReportCode(purchaseSupplierRectificationReportHead.getReportCode());
            SysUtil.setSysParam((BaseEntity)purchaseSupplierRectificationReportItem, (BaseEntity)purchaseSupplierRectificationReportHead);
        }
        if (!purchaseSupplierRectificationReportItemList.isEmpty()) {
            for (PurchaseSupplierRectificationReportItem purchaseSupplierRectificationReportItem : purchaseSupplierRectificationReportItemList) {
                this.purchaseSupplierRectificationReportItemMapper.insert((Object)purchaseSupplierRectificationReportItem);
            }
        }
        if (CollectionUtil.isNotEmpty(purchaseRetificationReviewTeamList)) {
            for (PurchaseRetificationReviewTeam purchaseRetificationReviewTeam : purchaseRetificationReviewTeamList) {
                purchaseRetificationReviewTeam.setHeadId(purchaseSupplierRectificationReportHead.getId());
                purchaseRetificationReviewTeam.setReportCode(purchaseSupplierRectificationReportHead.getReportCode());
                SysUtil.setSysParam((BaseEntity)purchaseRetificationReviewTeam, (BaseEntity)purchaseSupplierRectificationReportHead);
            }
            if (!purchaseRetificationReviewTeamList.isEmpty()) {
                this.purchaseRetificationReviewTeamMapper.insertBatchSomeColumn(purchaseRetificationReviewTeamList);
            }
        }
        if (CollectionUtil.isNotEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
                purchaseAttachmentDTO.setId(null);
                purchaseAttachmentDTO.setHeadId(purchaseSupplierRectificationReportHead.getId());
                purchaseAttachmentDTO.setElsAccount(purchaseSupplierRectificationReportHead.getElsAccount());
                purchaseAttachmentDTO.setCreateBy(purchaseSupplierRectificationReportHead.getCreateBy());
                purchaseAttachmentDTO.setCreateTime(purchaseSupplierRectificationReportHead.getCreateTime());
                purchaseAttachmentDTO.setUpdateBy(purchaseSupplierRectificationReportHead.getUpdateBy());
                purchaseAttachmentDTO.setUpdateTime(purchaseSupplierRectificationReportHead.getUpdateTime());
                purchaseAttachmentDTO.setDeleted(CommonConstant.DEL_FLAG_0);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSupplierRectificationReportItemMapper.deleteByMainId(id);
        this.purchaseRetificationReviewTeamMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.purchaseSupplierRectificationReportHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSupplierRectificationReportItemMapper.deleteByMainId(serializable.toString());
            this.purchaseRetificationReviewTeamMapper.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            this.purchaseSupplierRectificationReportHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction
    public void publish(PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead, List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItems, List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeams, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.updateMain(purchaseSupplierRectificationReportHead, purchaseSupplierRectificationReportItems, purchaseRetificationReviewTeams, purchaseAttachmentList);
        purchaseSupplierRectificationReportHead.setPublishStatus(SupplierRectificationPublishStatusEnum.PUBLISH.getValue());
        purchaseSupplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.RECTIFICATIONING.getValue());
        int count = this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)purchaseSupplierRectificationReportHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        SaleSupplierRectificationReportHead saleSupplierRectificationReportHead = new SaleSupplierRectificationReportHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSupplierRectificationReportHead), (Object)((Object)saleSupplierRectificationReportHead));
        saleSupplierRectificationReportHead.setId(purchaseSupplierRectificationReportHead.getRelationId());
        saleSupplierRectificationReportHead.setRelationId(purchaseSupplierRectificationReportHead.getId());
        saleSupplierRectificationReportHead.setElsAccount(purchaseSupplierRectificationReportHead.getToElsAccount());
        saleSupplierRectificationReportHead.setToElsAccount(purchaseSupplierRectificationReportHead.getElsAccount());
        this.saleSupplierRectificationReportHeadMapper.insert((Object)saleSupplierRectificationReportHead);
        if (CollectionUtil.isNotEmpty(purchaseSupplierRectificationReportItems)) {
            ArrayList<SaleSupplierRectificationReportItem> saleSupplierRectificationReportItems = new ArrayList<SaleSupplierRectificationReportItem>();
            for (PurchaseSupplierRectificationReportItem item : purchaseSupplierRectificationReportItems) {
                SaleSupplierRectificationReportItem saleSupplierRectificationReportItem = new SaleSupplierRectificationReportItem();
                BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleSupplierRectificationReportItem));
                saleSupplierRectificationReportItem.setElsAccount(item.getToElsAccount());
                saleSupplierRectificationReportItem.setToElsAccount(item.getElsAccount());
                saleSupplierRectificationReportItem.setId(item.getRelationId());
                saleSupplierRectificationReportItem.setRelationId(item.getId());
                saleSupplierRectificationReportItem.setHeadId(saleSupplierRectificationReportHead.getId());
                saleSupplierRectificationReportItems.add(saleSupplierRectificationReportItem);
            }
            this.saleSupplierRectificationReportItemMapper.insertBatchSomeColumn(saleSupplierRectificationReportItems);
        }
        if (CollectionUtil.isNotEmpty(purchaseAttachmentList)) {
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setElsAccount(TenantContext.getTenant());
            sendVO.setHeadId(purchaseSupplierRectificationReportHead.getId());
            HashMap<String, String> toSend = new HashMap<String, String>();
            toSend.put(saleSupplierRectificationReportHead.getId(), saleSupplierRectificationReportHead.getElsAccount());
            sendVO.setToSend(toSend);
            this.invokeBaseRpcService.sendPurchaseFile(sendVO, true);
        }
        String url = "reportCode=" + purchaseSupplierRectificationReportHead.getReportCode();
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void acceptRectification(PurchaseRetificationReviewTeam purchaseRetificationReviewTeam) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList = this.purchaseRetificationReviewTeamMapper.selectByMainId(purchaseRetificationReviewTeam.getHeadId());
        Assert.isNotEmpty(purchaseRetificationReviewTeamList, (String)I18nUtil.translate((String)"i18n_alert_APtFjUUXVWFLVW_9829c940", (String)"\u5f53\u524d\u5355\u636e\u7684\u8bc4\u5ba1\u5c0f\u7ec4\u6570\u636e\u4e3a\u7a7a!"));
        List purchaseRetificationReviewTeams = purchaseRetificationReviewTeamList.stream().filter(item -> loginUser.getSubAccount().equals(item.getSubAccount())).collect(Collectors.toList());
        Assert.isNotEmpty(purchaseRetificationReviewTeams, (String)I18nUtil.translate((String)"i18n_alert_APEHLjWWWWWWxKrirtFjUULjWPKxORcrtkW_b63535ed", (String)"\u5f53\u524d\u767b\u5f55\u4eba\u5458[$(0)]\u4e0d\u662f\u8be5\u6574\u6539\u5355\u636e\u7684\u8bc4\u5ba1\u4eba\u5458,\u6682\u65f6\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c!", (String[])new String[]{loginUser.getRealname()}));
        for (PurchaseRetificationReviewTeam retificationReviewTeam : purchaseRetificationReviewTeams) {
            if (StringUtils.isEmpty((Object)retificationReviewTeam.getReviewResult())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APEHLjWWWWIOkRUUWxOVBtk_c9900dce", (String)"\u5f53\u524d\u767b\u5f55\u4eba\u5458${0}\u5df2\u7ecf\u505a\u8fc7\u8bc4\u5ba1\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c", (String[])new String[]{loginUser.getRealname()}));
        }
        PurchaseRetificationReviewTeam retificationReviewTeam = new PurchaseRetificationReviewTeam();
        retificationReviewTeam.setId(((PurchaseRetificationReviewTeam)((Object)purchaseRetificationReviewTeams.get(0))).getId());
        retificationReviewTeam.setReviewResult(SupplierRectificationReviewResultStatusEnum.ACCEPT.getValue());
        retificationReviewTeam.setReviesOption(purchaseRetificationReviewTeam.getReviesOption());
        this.purchaseRetificationReviewTeamMapper.updateById((Object)retificationReviewTeam);
        this.syncRetificationStatus(purchaseRetificationReviewTeam.getHeadId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void rejectRectification(PurchaseRetificationReviewTeam purchaseRetificationReviewTeam) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList = this.purchaseRetificationReviewTeamMapper.selectByMainId(purchaseRetificationReviewTeam.getHeadId());
        Assert.isNotEmpty(purchaseRetificationReviewTeamList, (String)I18nUtil.translate((String)"i18n_alert_APtFjUUXVWFLVW_9829c940", (String)"\u5f53\u524d\u5355\u636e\u7684\u8bc4\u5ba1\u5c0f\u7ec4\u6570\u636e\u4e3a\u7a7a!"));
        List purchaseRetificationReviewTeams = purchaseRetificationReviewTeamList.stream().filter(item -> loginUser.getSubAccount().equals(item.getSubAccount())).collect(Collectors.toList());
        Assert.isNotEmpty(purchaseRetificationReviewTeams, (String)I18nUtil.translate((String)"i18n_alert_APEHLjWWWWWWxKrirtFjUULjWPKxORcrtkW_b63535ed", (String)"\u5f53\u524d\u767b\u5f55\u4eba\u5458[$(0)]\u4e0d\u662f\u8be5\u6574\u6539\u5355\u636e\u7684\u8bc4\u5ba1\u4eba\u5458,\u6682\u65f6\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c!", (String[])new String[]{loginUser.getRealname()}));
        for (PurchaseRetificationReviewTeam retificationReviewTeam : purchaseRetificationReviewTeams) {
            if (StringUtils.isEmpty((Object)retificationReviewTeam.getReviewResult())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APEHLjWWWWIOkRUUWxOVBtk_c9900dce", (String)"\u5f53\u524d\u767b\u5f55\u4eba\u5458${0}\u5df2\u7ecf\u505a\u8fc7\u8bc4\u5ba1\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c", (String[])new String[]{loginUser.getRealname()}));
        }
        PurchaseRetificationReviewTeam retificationReviewTeam = new PurchaseRetificationReviewTeam();
        retificationReviewTeam.setId(((PurchaseRetificationReviewTeam)((Object)purchaseRetificationReviewTeams.get(0))).getId());
        retificationReviewTeam.setReviewResult(SupplierRectificationReviewResultStatusEnum.REJECT.getValue());
        retificationReviewTeam.setReviesOption(purchaseRetificationReviewTeam.getReviesOption());
        this.purchaseRetificationReviewTeamMapper.updateById((Object)retificationReviewTeam);
        this.syncRetificationStatus(purchaseRetificationReviewTeam.getHeadId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void finishRectification(PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead) {
        purchaseSupplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.RECTIFICATIONED.getValue());
        this.updateById((Object)purchaseSupplierRectificationReportHead);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().set(SaleSupplierRectificationReportHead::getRectificationStatus, (Object)SupplierRectificationStatusEnum.RECTIFICATIONED.getValue());
        updateWrapper.lambda().set(SaleSupplierRectificationReportHead::getRectificationConclusion, (Object)purchaseSupplierRectificationReportHead.getRectificationConclusion());
        updateWrapper.lambda().eq(SaleSupplierRectificationReportHead::getRelationId, (Object)purchaseSupplierRectificationReportHead.getId());
        this.saleSupplierRectificationReportHeadMapper.update((Object)new SaleSupplierRectificationReportHead(), (Wrapper)updateWrapper);
    }

    private void syncRetificationStatus(String headId) {
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = (PurchaseSupplierRectificationReportHead)((Object)this.purchaseSupplierRectificationReportHeadMapper.selectById((Serializable)((Object)headId)));
        PurchaseSupplierRectificationReportHead tempSuppplierRectificationRepostHead = new PurchaseSupplierRectificationReportHead();
        SaleSupplierRectificationReportHead tempSaleSupplierRectificationReportHead = new SaleSupplierRectificationReportHead();
        tempSuppplierRectificationRepostHead.setId(purchaseSupplierRectificationReportHead.getId());
        tempSaleSupplierRectificationReportHead.setId(purchaseSupplierRectificationReportHead.getRelationId());
        List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList = this.purchaseRetificationReviewTeamMapper.selectByMainId(headId);
        List purchaseRetificationReviewTeam4HadCacluationList = purchaseRetificationReviewTeamList.stream().filter(item -> !StringUtils.isEmpty((Object)item.getReviewResult())).collect(Collectors.toList());
        if (purchaseRetificationReviewTeamList.size() == purchaseRetificationReviewTeam4HadCacluationList.size()) {
            tempSuppplierRectificationRepostHead.setRectificationStatus(SupplierRectificationStatusEnum.EVALUATIONED.getValue());
        } else {
            tempSuppplierRectificationRepostHead.setRectificationStatus(SupplierRectificationStatusEnum.EVALUATIONING.getValue());
        }
        tempSaleSupplierRectificationReportHead.setRectificationStatus(tempSuppplierRectificationRepostHead.getRectificationStatus());
        this.saleSupplierRectificationReportHeadMapper.updateById((Object)tempSaleSupplierRectificationReportHead);
        this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)tempSuppplierRectificationRepostHead);
    }
}

