/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workorder.websocket;

import cn.hutool.core.lang.UUID;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/workorder/{orderId}")
public class WorkOrderWebSocket {
    private static final Logger log = LoggerFactory.getLogger(WorkOrderWebSocket.class);
    private Session session;
    private String orderId;
    private String id;
    private static Map<String, List<WorkOrderWebSocket>> clientMap = new ConcurrentHashMap<String, List<WorkOrderWebSocket>>();

    @OnOpen
    public void onOpen(Session session, @PathParam(value="orderId") String orderId) {
        try {
            this.session = session;
            this.orderId = orderId;
            this.id = UUID.randomUUID().toString();
            List<Object> clients = clientMap.get(orderId) == null ? new ArrayList() : clientMap.get(orderId);
            clients.add(this);
            clientMap.put(orderId, clients);
        }
        catch (Exception e) {
            log.error("\u3010WorkOrderWebSocket\u6d88\u606f\u3011\u5efa\u7acb\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    @OnClose
    public void onClose() {
        try {
            List<WorkOrderWebSocket> clients = clientMap.get(this.orderId);
            if (clients != null) {
                List result = clients.stream().filter(socket -> !this.id.equals(socket.id)).collect(Collectors.toList());
                clientMap.put(this.orderId, result);
            }
            log.info("\u3010WorkOrderWebSocket\u6d88\u606f\u3011\u8fde\u63a5\u65ad\u5f00");
        }
        catch (Exception e) {
            log.error("\u3010WorkOrderWebSocket\u6d88\u606f\u3011\u65ad\u5f00\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    @OnMessage
    public void onMessage(String message) {
        this.session.getAsyncRemote().sendText(message);
    }

    public void sendQuoteMessage(String orderId, String msgText) {
        List<WorkOrderWebSocket> clients = clientMap.get(orderId);
        if (clients != null && !clients.isEmpty()) {
            for (WorkOrderWebSocket socket : clients) {
                if (socket.session == null || !socket.session.isOpen()) continue;
                socket.session.getAsyncRemote().sendText(msgText);
            }
        }
    }
}

