/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workorder.controller;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import cn.hutool.crypto.asymmetric.SignAlgorithm;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.workorder.service.WorkOrderApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/other/workOrder"})
@Api(tags={"\u5de5\u5355\u7cfb\u7edf\u56de\u8c03"})
public class WorkOrderCallBackController {
    @Value(value="${els.config.panshi.publicKey}")
    private String publicKey;

    @AutoLog(value="\u5de5\u5355\u7cfb\u7edf\u56de\u8c03-\u5de5\u5355\u7cfb\u7edf\u8c03\u7528SRM")
    @ApiOperation(value="\u5de5\u5355\u7cfb\u7edf\u8c03\u7528SRM", notes="\u5de5\u5355\u7cfb\u7edf\u8c03\u7528SRM")
    @PostMapping(value={"/noToken/callback"})
    public Result<?> callback(@RequestBody JSONObject param) {
        this.checkParam(param);
        String interfaceCode = param.getString("interfaceCode");
        WorkOrderApiService service = (WorkOrderApiService)SpringContextUtils.getBean((String)interfaceCode, WorkOrderApiService.class);
        if (service == null) {
            throw new ELSBootException("\u63a5\u53e3\u7f16\u7801\uff1a" + interfaceCode + " \u4e0d\u5b58\u5728\uff01");
        }
        String resultStr = service.invoke(param.getJSONObject("body"));
        try {
            return Result.ok((Object)JSONObject.parse((String)resultStr));
        }
        catch (Exception e) {
            Result r = new Result();
            r.setSuccess(true);
            r.setCode(CommonConstant.SC_OK_200);
            r.setResult((Object)resultStr);
            return r;
        }
    }

    private void checkParam(JSONObject param) {
        String interfaceCode = param.getString("interfaceCode");
        if (StrUtil.isBlank((CharSequence)interfaceCode)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVAoWWWWWWWWWWWWWWWxOLVW_61a79d80", (String)"\u63a5\u53e3\u7f16\u7801 interfaceCode \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String signStr = param.getString("sign");
        String body = param.getJSONObject("body").toJSONString();
        if (!this.checkSign(body, signStr, this.publicKey)) {
            throw new ELSBootException("\u975e\u6cd5\u53c2\u6570\uff01");
        }
    }

    private boolean checkSign(String data, String signStr, String publicKey) {
        if (StrUtil.isBlank((CharSequence)data) || StrUtil.isBlank((CharSequence)signStr)) {
            return false;
        }
        byte[] bData = data.getBytes();
        byte[] signed = Base64.decode((CharSequence)signStr);
        Sign sign = SecureUtil.sign((SignAlgorithm)SignAlgorithm.MD5withRSA, null, (String)publicKey);
        return sign.verify(bData, signed);
    }
}

