/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.formula.controller;

import com.els.common.api.vo.Result;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.formula.service.FormulaService;
import com.els.modules.formula.vo.FormulaVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formula"})
@Api(tags={"\u516c\u5f0f\u8ba1\u7b97"})
public class FormulaController {
    private static final Logger log = LoggerFactory.getLogger(FormulaController.class);
    @Autowired
    private FormulaService formulaService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u8ba1\u7b97\u516c\u5f0f", notes="\u8ba1\u7b97\u516c\u5f0f")
    @PostMapping(value={"/compute"})
    public Result<?> compute(@Valid @RequestBody FormulaVO formulaVO) {
        TemplateHeadDTO headDTO = this.invokeBaseRpcService.getTemplateConfig(formulaVO.getBusAccount(), formulaVO.getTemplateNumber(), formulaVO.getTemplateVersion());
        List<TemplateConfigItemDTO> itemList = headDTO.getTemplateConfigItemList().stream().filter(item -> formulaVO.getRef().equals(item.getGroupCode()) || StringUtils.isBlank((CharSequence)item.getGroupCode())).collect(Collectors.toList());
        this.formulaService.compute(formulaVO, itemList);
        List sumList = itemList.stream().filter(item -> "1".equals(item.getSum())).collect(Collectors.toList());
        if (!sumList.isEmpty()) {
            formulaVO.setSumName(((TemplateConfigItemDTO)sumList.get(0)).getFieldName());
        }
        return Result.ok((Object)formulaVO);
    }
}

