/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.apply.service.impl;

import cn.hutool.extra.mail.MailAccount;
import cn.hutool.extra.mail.MailUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.apply.entity.ElsApplyTable;
import com.els.modules.apply.enumerate.ElsApplyTypeEnum;
import com.els.modules.apply.mapper.ElsApplyTableMapper;
import com.els.modules.apply.rpc.service.OrderInvokeBaseRpcService;
import com.els.modules.apply.service.ElsApplyTableService;
import com.els.modules.base.api.dto.ElsEmailConfigDTO;
import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.NullCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElsApplyTableServiceImpl
extends BaseServiceImpl<ElsApplyTableMapper, ElsApplyTable>
implements ElsApplyTableService {
    @Resource
    private OrderInvokeBaseRpcService orderInvokeBaseRpcService;
    private static Set<String> tos = new HashSet<String>();
    private static Set<String> ccs = new HashSet<String>();

    @Override
    public void sendMessage(ElsApplyTable apply) {
        apply.setId(null);
        apply.setElsAccount("100000");
        apply.setApplyType(ElsApplyTypeEnum.MESSAGE.getValue());
        this.save((Object)apply);
        this.sendMail(apply);
    }

    @Override
    public void submitDemo(ElsApplyTable apply) {
        apply.setId(null);
        apply.setElsAccount("100000");
        apply.setApplyType(ElsApplyTypeEnum.DEMO.getValue());
        this.save((Object)apply);
        this.sendMail(apply);
    }

    @Override
    public void submitUse(ElsApplyTable apply) {
        apply.setId(null);
        apply.setElsAccount("100000");
        apply.setApplyType(ElsApplyTypeEnum.USE.getValue());
        this.save((Object)apply);
        this.sendMail(apply);
    }

    private void sendMail(ElsApplyTable apply) {
        String visitDemon = "1".equals(apply.getVisitDemon()) ? "\u662f" : "\u5426";
        apply.setVisitDemon(visitDemon);
        JSONObject object = StringUtils.isNotBlank((CharSequence)apply.getDemand()) ? JSONObject.parseObject((String)apply.getDemand()) : new JSONObject();
        StringBuilder demand = new StringBuilder();
        for (String key : object.keySet()) {
            String value = object.getString(key);
            if ("1".equals(value) && !"\u5176\u4ed6".equals(key)) {
                if (StringUtils.isNotBlank((CharSequence)demand)) {
                    demand.append("\uff0c");
                }
                demand.append(key);
                continue;
            }
            if (!"\u5176\u4ed6".equals(key)) continue;
            if (StringUtils.isNotBlank((CharSequence)demand) && StringUtils.isNotBlank((CharSequence)value)) {
                demand.append("\uff0c");
            }
            demand.append(value);
        }
        apply.setDemand(demand.toString());
        List<ElsEmailConfigDTO> emailConfigs = this.orderInvokeBaseRpcService.getEmailConfigs("100000");
        if (CollectionUtils.isEmpty(emailConfigs)) {
            this.log.error("\u7f3a\u5c11\u90ae\u7bb1\u914d\u7f6e...");
        }
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
        configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(ElsApplyTableServiceImpl.class, "/templates"));
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        configuration.setCacheStorage((CacheStorage)NullCacheStorage.INSTANCE);
        try {
            Template template = configuration.getTemplate("applyTemplate.ftl");
            JSONObject dataModel = SysUtil.objectToJSON((Object)((Object)apply));
            MailAccount mailAccount = new MailAccount();
            for (ElsEmailConfigDTO mailConfig : emailConfigs) {
                mailAccount.setHost(mailConfig.getEmailHost());
                mailAccount.setPort(Integer.valueOf(null == mailConfig.getEmailPort() ? 25 : mailConfig.getEmailPort()));
                mailAccount.setFrom(mailConfig.getEmailUsername());
                mailAccount.setUser(mailConfig.getEmailUsername());
                mailAccount.setPass(mailConfig.getEmailPassword());
                boolean result = this.sendEmail(template, dataModel, mailAccount);
                if (!result) continue;
                break;
            }
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6\u6a21\u677f\u5931\u8d25\u6216\u8005\u6a21\u677f\u6e32\u67d3\u5931\u8d25:", (Throwable)e);
        }
    }

    private boolean sendEmail(Template template, JSONObject dataModel, MailAccount mailAccount) {
        try {
            StringWriter stringWriter = new StringWriter();
            template.process((Object)dataModel, (Writer)stringWriter);
            String mailContent = stringWriter.toString();
            String cc = "zhujianfeng@51qqt.com,ruanxiangai@51qqt.com,panjingmao@51qqt.com";
            MailUtil.send((MailAccount)mailAccount, tos, ccs, null, (String)"\u7559\u8a00\u677f", (String)mailContent, (boolean)true, (File[])new File[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        tos.add("help@51qqt.com");
        ccs.add("zhujianfeng@51qqt.com");
        ccs.add("ruanxiangai@51qqt.com");
        ccs.add("panjingmao@51qqt.com");
    }
}

