/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.quality.entity.SaleQualityCheckHead;
import com.els.modules.quality.entity.SaleQualityCheckItem;
import com.els.modules.quality.mapper.SaleQualityCheckHeadMapper;
import com.els.modules.quality.mapper.SaleQualityCheckItemMapper;
import com.els.modules.quality.service.SaleQualityCheckHeadService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleQualityCheckHeadServiceImpl
extends ServiceImpl<SaleQualityCheckHeadMapper, SaleQualityCheckHead>
implements SaleQualityCheckHeadService {
    @Autowired
    private SaleQualityCheckHeadMapper saleQualityCheckHeadMapper;
    @Autowired
    private SaleQualityCheckItemMapper saleQualityCheckItemMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleQualityCheckHead saleQualityCheckHead, List<SaleQualityCheckItem> saleQualityCheckItemList) {
        this.saleQualityCheckHeadMapper.insert((Object)saleQualityCheckHead);
        this.insertData(saleQualityCheckHead, saleQualityCheckItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleQualityCheckHead saleQualityCheckHead, List<SaleQualityCheckItem> saleQualityCheckItemList) {
        this.saleQualityCheckHeadMapper.updateById((Object)saleQualityCheckHead);
        this.saleQualityCheckItemMapper.deleteByMainId(saleQualityCheckHead.getId());
        this.insertData(saleQualityCheckHead, saleQualityCheckItemList);
    }

    private void insertData(SaleQualityCheckHead saleQualityCheckHead, List<SaleQualityCheckItem> saleQualityCheckItemList) {
        for (SaleQualityCheckItem entity : saleQualityCheckItemList) {
            entity.setHeadId(saleQualityCheckHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleQualityCheckHead);
        }
        if (!saleQualityCheckItemList.isEmpty()) {
            this.saleQualityCheckItemMapper.insertBatchSomeColumn(saleQualityCheckItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleQualityCheckItemMapper.deleteByMainId(id);
        this.saleQualityCheckHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleQualityCheckItemMapper.deleteByMainId(serializable.toString());
            this.saleQualityCheckHeadMapper.deleteById(serializable);
        }
    }
}

