/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.sample.entity.PurchaseSampleHead;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.entity.SampleSupplierList;
import com.els.modules.sample.enumerate.PurchaseSampleStatusEnum;
import com.els.modules.sample.service.PurchaseSampleHeadService;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.modules.sample.service.SampleSupplierListService;
import com.els.modules.sample.service.impl.PurchaseSampleHeadServiceImpl;
import com.els.modules.sample.vo.PurchaseSampleHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="publishSampleAdapter")
public class PublishSampleAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseSampleHeadService purchaseSampleHeadService;
    @Autowired
    private PurchaseSampleItemService purchaseSampleItemService;
    @Autowired
    private SampleSupplierListService enquirySupplierListService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StringUtils.isEmpty((Object)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseSampleHeadVO headVO = (PurchaseSampleHeadVO)((Object)JSONObject.parseObject((String)param, PurchaseSampleHeadVO.class));
        PurchaseSampleHeadServiceImpl.setHeadParamAndCheck(headVO, true);
        headVO.setSampleStatus(PurchaseSampleStatusEnum.SAMPLE_NEW.getValue());
        headVO.setWorkFlowType(outputParamVO.getBpmnType());
        headVO.setPublishTime(null);
        headVO.setPublishUser(null);
        this.purchaseSampleHeadService.updateMain(headVO, headVO.getPurchaseSampleItemList(), headVO.getPurchaseSampleTrackingItemList(), headVO.getSampleSupplierList(), headVO.getPurchaseAttachmentList());
        this.updateAuditStatus(inputParamVO, outputParamVO);
        String operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
        }
        this.sendMsg(inputParamVO, outputParamVO, operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            this.sendMsg(inputParamVO, outputParamVO, operataion);
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            PurchaseSampleHeadVO headVO = new PurchaseSampleHeadVO();
            String id = inputParamVO.getBusinessId();
            PurchaseSampleHead dbHead = (PurchaseSampleHead)((Object)this.purchaseSampleHeadService.getById((Serializable)((Object)id)));
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            List<PurchaseSampleItem> itemList = this.purchaseSampleItemService.selectByMainId(id);
            headVO.setPurchaseSampleItemList(itemList);
            List<SampleSupplierList> supplierList = this.enquirySupplierListService.selectByMainId(id);
            headVO.setSampleSupplierList(supplierList);
            List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
            headVO.setPurchaseAttachmentList(demandList);
            this.purchaseSampleHeadService.publish(headVO);
        }
        PurchaseSampleHead updateHead = new PurchaseSampleHead();
        updateHead.setId(inputParamVO.getBusinessId());
        updateHead.setFlowId(outputParamVO.getProcessRootId());
        updateHead.setAuditStatus(outputParamVO.getAuditStatus());
        this.purchaseSampleHeadService.updateById((Object)updateHead);
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"sample", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"sample", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseSampleHead head = (PurchaseSampleHead)((Object)this.purchaseSampleHeadService.getById((Serializable)((Object)headId)));
        PurchaseSampleHeadVO headVO = new PurchaseSampleHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<PurchaseSampleItem> itemList = this.purchaseSampleItemService.selectByMainId(headId);
        headVO.setPurchaseSampleItemList(itemList);
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

