/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.panshi.controller;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.modules.other.api.service.OtherRpcService;
import com.els.modules.workorder.api.dto.WorkOrderHeadDTO;
import com.els.modules.workorder.api.service.WorkOrderRpcService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/other/chatBi"})
public class ChatBiOtherHttpController {
    private static final Logger log = LoggerFactory.getLogger(ChatBiOtherHttpController.class);
    @Lazy
    @Resource
    private WorkOrderRpcService workOrderRpcService;
    @Lazy
    @Resource
    private OtherRpcService otherRpcService;

    @RequestMapping(value={"/invoke/{methodCode}"}, method={RequestMethod.POST})
    public Result<?> invoke(@RequestBody JSONObject object, @PathVariable(value="methodCode") String methodCode) {
        if ("createWorkorder".equals(methodCode)) {
            WorkOrderHeadDTO headDTO = (WorkOrderHeadDTO)object.toJavaObject(WorkOrderHeadDTO.class);
            this.workOrderRpcService.createWorkOrder(headDTO);
            return Result.ok();
        }
        if ("getLicenseInfo".equals(methodCode)) {
            return Result.ok((Object)this.otherRpcService.getLicenseInfo());
        }
        if ("callPanshi".equals(methodCode)) {
            String interfaceCode = object.getString("interfaceCode");
            JSONObject body = object.getJSONObject("body");
            return Result.ok((Object)this.otherRpcService.callPanshi(interfaceCode, body));
        }
        return Result.error((String)"\u4e0d\u5b58\u5728\u7684\u63a5\u53e3\u65b9\u6cd5");
    }
}

