/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.service.FileRpcService;
import com.els.modules.base.api.service.PurchaseAttachmentRpcService;
import com.els.modules.quality.entity.PurchaseSupplierTask;
import com.els.modules.quality.entity.SaleSupplierTask;
import com.els.modules.quality.enumerate.PurchaseSupplierTaskStatusEnum;
import com.els.modules.quality.mapper.PurchaseSupplierTaskMapper;
import com.els.modules.quality.service.PurchaseSupplierTaskService;
import com.els.modules.quality.service.SaleSupplierTaskService;
import com.els.modules.quality.vo.PurchaseSupplierTaskVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseSupplierTaskServiceImpl
extends BaseServiceImpl<PurchaseSupplierTaskMapper, PurchaseSupplierTask>
implements PurchaseSupplierTaskService {
    @Autowired
    private SaleSupplierTaskService saleSupplierTaskService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Value(value="${els.storage.type}")
    private String storeType;
    @Resource
    private PurchaseAttachmentRpcService purchaseAttachmentRpcService;
    private static final String BIZ_PATH = "files";
    private static final String STR_FORMAT = "yyyyMMddHHmmssSSS";
    @Autowired
    private FileRpcService fileRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addAndSynSale(PurchaseSupplierTask purchaseSupplierTask) {
        purchaseSupplierTask.setId(IdWorker.getIdStr());
        purchaseSupplierTask.setRelationId(IdWorker.getIdStr());
        purchaseSupplierTask.setTaskStatus(PurchaseSupplierTaskStatusEnum.PUBLISH.getValue());
        ((PurchaseSupplierTaskMapper)this.baseMapper).insert((Object)purchaseSupplierTask);
        if (StringUtils.isNotBlank((CharSequence)purchaseSupplierTask.getFileUrl())) {
            String[] split;
            for (String url : split = purchaseSupplierTask.getFileUrl().split("\uff0c")) {
                this.dowmFile(url, purchaseSupplierTask.getId());
            }
        }
        SaleSupplierTask saleSupplierTask = (SaleSupplierTask)((Object)SysUtil.copyProperties((Object)((Object)purchaseSupplierTask), SaleSupplierTask.class));
        saleSupplierTask.setId(purchaseSupplierTask.getRelationId());
        saleSupplierTask.setRelationId(purchaseSupplierTask.getId());
        saleSupplierTask.setElsAccount(purchaseSupplierTask.getToElsAccount());
        saleSupplierTask.setToElsAccount(purchaseSupplierTask.getElsAccount());
        this.saleSupplierTaskService.add(saleSupplierTask);
        List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseSupplierTask.getId());
        if (CollectionUtil.isNotEmpty((Collection)purchaseAttachmentDTOS)) {
            ArrayList saleAttachmentDTOS = SysUtil.copyProperties((List)purchaseAttachmentDTOS, SaleAttachmentDTO.class);
            for (SaleAttachmentDTO saleAttachmentDTO : saleAttachmentDTOS) {
                saleAttachmentDTO.setHeadId(saleSupplierTask.getId());
                saleAttachmentDTO.setId(null);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn((List)saleAttachmentDTOS);
        }
    }

    private void processFile(String fileUrl, byte[] bytes, String headId) {
        String[] split = fileUrl.split("&");
        String fileName = null;
        for (String s : split) {
            if (!s.contains("filename")) continue;
            fileName = s.split("=")[1];
        }
        if (StringUtils.isBlank(fileName)) {
            String[] parts = fileUrl.split("/");
            fileName = parts[parts.length - 1];
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        LocalDateTime time = LocalDateTime.now();
        String nowDay = dtf.format(time);
        Object documentLocation = File.separator + BIZ_PATH + File.separator + TenantContext.getTenant() + File.separator + nowDay + File.separator + fileName;
        if (((String)documentLocation).contains("\\")) {
            documentLocation = ((String)documentLocation).replace("\\", "/");
        }
        if (((String)documentLocation).startsWith("\\")) {
            ((String)documentLocation).replace("\\", "");
        }
        if (((String)documentLocation).startsWith("/")) {
            documentLocation = ((String)documentLocation).substring(1);
        }
        String path = this.fileRpcService.uploadFiles(bytes, (String)documentLocation, fileName);
        PurchaseAttachmentDTO attachment = new PurchaseAttachmentDTO();
        attachment.setHeadId(headId);
        attachment.setUploadSubAccount(SysUtil.getLoginUser().getSubAccount());
        attachment.setUploadElsAccount(SysUtil.getPurchaseAccount());
        attachment.setFileName(fileName);
        attachment.setFileSize("" + bytes.length);
        attachment.setFilePath(path);
        attachment.setSaveType(this.storeType);
        attachment.setSendStatus("0");
        attachment.setReceiveStatus("0");
        attachment.setUploadTime(new Date());
        attachment.setSourceType("1");
        this.purchaseAttachmentRpcService.insert(attachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dowmFile(String fileUrl, String headId) {
        HttpURLConnection httpConn = null;
        InputStream inputStream = null;
        try {
            OkHttpClient okHttpClient = new OkHttpClient();
            Request request = new Request.Builder().url(fileUrl).get().build();
            Response response = okHttpClient.newCall(request).execute();
            ResponseBody body = response.body();
            this.processFile(fileUrl, body.bytes(), headId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (httpConn != null) {
                httpConn.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void add(PurchaseSupplierTask purchaseSupplierTask) {
        ((PurchaseSupplierTaskMapper)this.baseMapper).insert((Object)purchaseSupplierTask);
    }

    @Override
    public void edit(PurchaseSupplierTask purchaseSupplierTask) {
        int count = ((PurchaseSupplierTaskMapper)this.baseMapper).updateById((Object)purchaseSupplierTask);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseSupplierTaskMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseSupplierTaskMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void reply(SaleSupplierTask saleSupplierTask, List<SaleAttachmentDTO> saleAttachmentList) {
        PurchaseSupplierTask purchaseSupplierTask = (PurchaseSupplierTask)((Object)this.getById((Serializable)((Object)saleSupplierTask.getRelationId())));
        purchaseSupplierTask.setId(saleSupplierTask.getRelationId());
        purchaseSupplierTask.setReplyContent(saleSupplierTask.getReplyContent());
        purchaseSupplierTask.setReplyTime(saleSupplierTask.getReplyTime());
        purchaseSupplierTask.setTaskStatus(saleSupplierTask.getTaskStatus());
        this.updateById((Object)purchaseSupplierTask);
        PurchaseSupplierTaskVO purchaseSupplierTaskVO = (PurchaseSupplierTaskVO)((Object)SysUtil.copyProperties((Object)((Object)purchaseSupplierTask), PurchaseSupplierTaskVO.class));
        TenantContext.setTenant((String)SysUtil.getPurchaseAccount());
        if (CollectionUtil.isNotEmpty(saleAttachmentList)) {
            ArrayList purchaseAttachmentDTOS = SysUtil.copyProperties(saleAttachmentList, PurchaseAttachmentDTO.class);
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentDTOS) {
                purchaseAttachmentDTO.setId(null);
                purchaseAttachmentDTO.setElsAccount(purchaseSupplierTask.getElsAccount());
                purchaseAttachmentDTO.setHeadId(purchaseSupplierTask.getId());
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn((List)purchaseAttachmentDTOS);
            purchaseSupplierTaskVO.setAttachmentList(purchaseAttachmentDTOS);
        }
        this.interfaceUtil.callInterface(TenantContext.getTenant(), null, "ReplyTaskQMS", (Object)purchaseSupplierTaskVO);
    }
}

