/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.quality.entity.SaleSupplierTask;
import com.els.modules.quality.enumerate.PurchaseSupplierTaskStatusEnum;
import com.els.modules.quality.mapper.SaleSupplierTaskMapper;
import com.els.modules.quality.service.PurchaseSupplierTaskService;
import com.els.modules.quality.service.SaleSupplierTaskService;
import com.els.modules.quality.vo.SaleSupplierTaskVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleSupplierTaskServiceImpl
extends BaseServiceImpl<SaleSupplierTaskMapper, SaleSupplierTask>
implements SaleSupplierTaskService {
    @Autowired
    @Lazy
    private PurchaseSupplierTaskService purchaseSupplierTaskService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void add(SaleSupplierTask saleSupplierTask) {
        ((SaleSupplierTaskMapper)this.baseMapper).insert((Object)saleSupplierTask);
    }

    @Override
    public void edit(SaleSupplierTaskVO saleSupplierTaskVO) {
        List<Object> saleAttachmentList;
        SaleSupplierTask dbSaleSupplierTask = (SaleSupplierTask)((Object)((SaleSupplierTaskMapper)this.baseMapper).selectById((Serializable)((Object)saleSupplierTaskVO.getId())));
        Assert.isTrue((boolean)"2".equals(dbSaleSupplierTask.getTaksType()), (String)I18nUtil.translate((String)"i18n_field_ZzAcLSxTPMB_54b6d6f0", (String)"\u9605\u8bfb\u7c7b\u578b\u4efb\u52a1\u4e0d\u9700\u8981\u56de\u590d\uff01"));
        Assert.isTrue((boolean)PurchaseSupplierTaskStatusEnum.PUBLISH.getValue().equals(dbSaleSupplierTask.getTaskStatus()), (String)I18nUtil.translate((String)"i18n_field_APzExiTtkW_8e5927f3", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)saleSupplierTaskVO.getReplyContent()), (String)I18nUtil.translate((String)"", (String)"\u56de\u590d\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"));
        dbSaleSupplierTask.setReplyContent(saleSupplierTaskVO.getReplyContent());
        this.updateById((Object)dbSaleSupplierTask);
        List saleAttachmentDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(dbSaleSupplierTask.getId());
        List attachmentIds = saleAttachmentDTOS.stream().filter(saleAttachmentDTO -> !SysUtil.getPurchaseAccount().equals(saleAttachmentDTO.getUploadElsAccount())).map(BaseDTO::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(attachmentIds)) {
            this.invokeBaseRpcService.deleteSaleAttachmentByBatchId(attachmentIds);
        }
        if (CollectionUtil.isNotEmpty(saleAttachmentList = saleSupplierTaskVO.getAttachmentList()) && CollectionUtil.isNotEmpty(saleAttachmentList = saleAttachmentList.stream().filter(saleAttachmentDTO -> !"1".equals(saleAttachmentDTO.getFbk1())).collect(Collectors.toList()))) {
            for (SaleAttachmentDTO saleAttachmentDTO2 : saleAttachmentList) {
                saleAttachmentDTO2.setId(null);
                saleAttachmentDTO2.setHeadId(dbSaleSupplierTask.getId());
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentList);
        }
    }

    @Override
    public void delete(String id) {
        ((SaleSupplierTaskMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleSupplierTaskMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void reply(SaleSupplierTaskVO saleSupplierTaskVO) {
        List<Object> saleAttachmentList;
        SaleSupplierTask dbSaleSupplierTask = (SaleSupplierTask)((Object)((SaleSupplierTaskMapper)this.baseMapper).selectById((Serializable)((Object)saleSupplierTaskVO.getId())));
        Assert.isTrue((boolean)"2".equals(dbSaleSupplierTask.getTaksType()), (String)I18nUtil.translate((String)"i18n_field_ZzAcLSxTPMB_54b6d6f0", (String)"\u9605\u8bfb\u7c7b\u578b\u4efb\u52a1\u4e0d\u9700\u8981\u56de\u590d\uff01"));
        Assert.isTrue((boolean)PurchaseSupplierTaskStatusEnum.PUBLISH.getValue().equals(dbSaleSupplierTask.getTaskStatus()), (String)I18nUtil.translate((String)"i18n_field_APzExiTtkW_8e5927f3", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)saleSupplierTaskVO.getReplyContent()), (String)I18nUtil.translate((String)"", (String)"\u56de\u590d\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"));
        dbSaleSupplierTask.setTaskStatus(PurchaseSupplierTaskStatusEnum.COMPLETED.getValue());
        dbSaleSupplierTask.setReplyTime(new Date());
        dbSaleSupplierTask.setReplyContent(saleSupplierTaskVO.getReplyContent());
        this.updateById((Object)dbSaleSupplierTask);
        List saleAttachmentDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(dbSaleSupplierTask.getId());
        List attachmentIds = saleAttachmentDTOS.stream().filter(saleAttachmentDTO -> !SysUtil.getPurchaseAccount().equals(saleAttachmentDTO.getUploadElsAccount())).map(BaseDTO::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(attachmentIds)) {
            this.invokeBaseRpcService.deleteSaleAttachmentByBatchId(attachmentIds);
        }
        if (CollectionUtil.isNotEmpty(saleAttachmentList = saleSupplierTaskVO.getAttachmentList()) && CollectionUtil.isNotEmpty(saleAttachmentList = saleAttachmentList.stream().filter(saleAttachmentDTO -> !SysUtil.getPurchaseAccount().equals(saleAttachmentDTO.getUploadElsAccount())).collect(Collectors.toList()))) {
            for (SaleAttachmentDTO saleAttachmentDTO2 : saleAttachmentList) {
                saleAttachmentDTO2.setHeadId(dbSaleSupplierTask.getId());
                saleAttachmentDTO2.setId(null);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentList);
        }
        this.purchaseSupplierTaskService.reply(dbSaleSupplierTask, saleAttachmentList);
    }
}

