/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.report.entity.PerformanceReviewForm;
import com.els.modules.report.mapper.PerformanceReviewFormMapper;
import com.els.modules.report.service.PerformanceReviewFormService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PerformanceReviewFormAdapter
implements AuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PerformanceReviewFormAdapter.class);
    @Autowired
    private PerformanceReviewFormService performanceReviewFormService;
    @Autowired
    private PerformanceReviewFormMapper performanceReviewFormMapper;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        log.info("come in PerformanceReviewFormAdapter to startCallBack\uff1a" + inputParamVO.getBusinessId());
        this.updateSource(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            Object operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)"performanceReviewForm", (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String headId = inputParamVO.getBusinessId();
        PerformanceReviewForm head = (PerformanceReviewForm)((Object)this.performanceReviewFormMapper.selectById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)head));
        ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(outputParamVO.getAuditStatus())) {
            paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
            paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
            if (account.split("_").length > 2) {
                paramObj.put("taskId", (Object)account.split("_")[2]);
            }
            if (account.split("_").length > 3) {
                paramObj.put("processInstanceId", (Object)account.split("_")[3]);
            }
        } else {
            paramObj.put("id", (Object)inputParamVO.getBusinessId());
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }

    private void updateSource(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        int count;
        PerformanceReviewForm source = new PerformanceReviewForm();
        source.setId(inputParamVO.getBusinessId());
        source.setAuditStatus(outputParamVO.getAuditStatus());
        source.setFlowId(outputParamVO.getProcessRootId());
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(source.getAuditStatus())) {
            source.setPerformanceStatus("1");
        }
        if ((count = this.performanceReviewFormMapper.updateById((Object)source)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            PerformanceReviewForm changeHead = new PerformanceReviewForm();
            changeHead.setId(inputParamVO.getBusinessId());
            changeHead.setAuditStatus(outputParamVO.getAuditStatus());
            changeHead.setFlowId(outputParamVO.getProcessRootId());
            changeHead.setWorkFlowType(outputParamVO.getBpmnType());
            this.performanceReviewFormMapper.updateById((Object)changeHead);
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                Object operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)"performanceReviewForm", (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSource(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateSource(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        PerformanceReviewForm head = (PerformanceReviewForm)((Object)this.performanceReviewFormService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }
}

