/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.api.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.extend.api.dto.PurchaseDeliveryHeadExtDTO;
import com.els.modules.extend.api.dto.PurchaseDeliveryItemExtDTO;
import com.els.modules.extend.api.service.PurchaseDeliveryHeadExtRpcService;
import com.els.modules.extend.api.service.PurchaseVoucherItemExtRpcService;
import com.els.modules.report.entity.PurchaseFrequencyDeviationData;
import com.els.modules.report.service.PurchaseFrequencyDeviationDataService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseFrequencyDeviationDataApiServiceimpl
implements SimpleOpenApiRpcService {
    @Autowired
    PurchaseVoucherItemExtRpcService purchaseVoucherItemRpcService;
    @Autowired
    SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Autowired
    PurchaseDeliveryHeadExtRpcService purchaseDeliveryHeadExtRpcService;
    @Autowired
    PurchaseFrequencyDeviationDataService purchaseFrequencyDeviationDataService;

    public JSONObject invoke(JSONObject jsonObject) {
        List purchaseFrequencyDeviationDataList = (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject.getJSONArray("list")), (TypeReference)new TypeReference<List<PurchaseFrequencyDeviationData>>(){}, (Feature[])new Feature[0]);
        Map<String, List<PurchaseFrequencyDeviationData>> purchaseFrequencyDeviationDataMap = purchaseFrequencyDeviationDataList.stream().collect(Collectors.groupingBy(PurchaseFrequencyDeviationData::getSupplierCode));
        Set<String> supplieCodeSet = purchaseFrequencyDeviationDataMap.keySet();
        ArrayList<String> supplieCodeList = new ArrayList<String>(supplieCodeSet);
        List supplierMasterDataDTOList = this.supplierMasterDataRpcService.getSupplierMasterDataBySupplierCode(supplieCodeList);
        Map supplierMasterDataDTOMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getSupplierCode, Function.identity()));
        ArrayList allDeliveryNumberList = new ArrayList();
        for (String supplierCode : purchaseFrequencyDeviationDataMap.keySet()) {
            List<PurchaseFrequencyDeviationData> purchaseFrequencyDeviationDataParam = purchaseFrequencyDeviationDataMap.get(supplierCode);
            Set voucherNumbers = purchaseFrequencyDeviationDataParam.stream().map(PurchaseFrequencyDeviationData::getByBatchNumber).collect(Collectors.toSet());
            SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(supplierCode);
            List purchaseVoucherItemDTOList = this.purchaseVoucherItemRpcService.checkVoucherByBaiyaoNums(voucherNumbers, SysUtil.getPurchaseAccount(), supplierMasterDataDTO.getToElsAccount());
            List deliveryNumberList = purchaseVoucherItemDTOList.stream().map(PurchaseVoucherItemDTO::getDeliveryNumber).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(deliveryNumberList)) continue;
            allDeliveryNumberList.addAll(deliveryNumberList);
        }
        if (CollectionUtil.isEmpty(allDeliveryNumberList)) {
            throw new ELSBootException("\u53d1\u8d27\u5355\u4e3a\u7a7a");
        }
        List deliveryItemDTOList = this.purchaseDeliveryHeadExtRpcService.selectPurcherDeliveryItemByDeliveryNumbers(allDeliveryNumberList);
        Map<String, List<PurchaseDeliveryItemExtDTO>> deliveryItemMap = deliveryItemDTOList.stream().collect(Collectors.groupingBy(PurchaseDeliveryItemExtDTO::getBaiyaoBatchNumber));
        List deliveryDTOList = this.purchaseDeliveryHeadExtRpcService.selectPurcherDeliveryHeadByDeliveryNumbers(allDeliveryNumberList);
        Map deliveryHeadMap = deliveryDTOList.stream().collect(Collectors.toMap(PurchaseDeliveryHeadExtDTO::getDeliveryNumber, Function.identity()));
        ArrayList<PurchaseFrequencyDeviationData> purchaseFrequencyDeviationDataResult = new ArrayList<PurchaseFrequencyDeviationData>();
        for (PurchaseFrequencyDeviationData purchaseFrequencyDeviationData : purchaseFrequencyDeviationDataList) {
            String supplierCode = purchaseFrequencyDeviationData.getSupplierCode();
            SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(supplierCode);
            Optional purchaseDeliveryItemExtDTOOp = deliveryItemMap.get(purchaseFrequencyDeviationData.getByBatchNumber()).stream().findFirst();
            if (!purchaseDeliveryItemExtDTOOp.isPresent()) {
                throw new ELSBootException("\u51ed\u8bc1\u53f7\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355");
            }
            PurchaseDeliveryItemExtDTO purchaseDeliveryItemExtDTO = (PurchaseDeliveryItemExtDTO)purchaseDeliveryItemExtDTOOp.get();
            PurchaseDeliveryHeadExtDTO purchaseDeliveryHeadExtDTO = (PurchaseDeliveryHeadExtDTO)deliveryHeadMap.get(purchaseDeliveryItemExtDTO.getDeliveryNumber());
            purchaseFrequencyDeviationData.setToElsAccount(supplierMasterDataDTO.getToElsAccount());
            purchaseFrequencyDeviationData.setSupplierCode(supplierMasterDataDTO.getSupplierCode());
            purchaseFrequencyDeviationData.setSupplierName(supplierMasterDataDTO.getSupplierName());
            purchaseFrequencyDeviationData.setFrequencyDeviationNumber("");
            purchaseFrequencyDeviationData.setOrderNumber(purchaseDeliveryItemExtDTO.getOrderNumber());
            purchaseFrequencyDeviationData.setOrderItemNumber(purchaseDeliveryItemExtDTO.getOrderItemNumber());
            purchaseFrequencyDeviationData.setBusinessUnit(purchaseDeliveryHeadExtDTO.getBusinessUnit());
            purchaseFrequencyDeviationData.setBusinessEntity("");
            purchaseFrequencyDeviationData.setMaterialCategory(purchaseDeliveryHeadExtDTO.getMaterialCategory());
            purchaseFrequencyDeviationData.setMaterialMiddleCategory(purchaseDeliveryHeadExtDTO.getMaterialMiddleCategory());
            purchaseFrequencyDeviationData.setMaterialSmallCategory(purchaseDeliveryHeadExtDTO.getMaterialSmallCategory());
            purchaseFrequencyDeviationData.setDeliveryNumber(purchaseDeliveryHeadExtDTO.getDeliveryNumber());
            purchaseFrequencyDeviationData.setDeliveryItemNumber(purchaseDeliveryItemExtDTO.getItemNumber());
            purchaseFrequencyDeviationData.setMaterialNumber(purchaseDeliveryItemExtDTO.getMaterialNumber());
            purchaseFrequencyDeviationData.setMaterialDesc(purchaseDeliveryItemExtDTO.getMaterialDesc());
            purchaseFrequencyDeviationData.setPerformanceDeduce("\u4e0d\u5408\u683c");
            purchaseFrequencyDeviationData.setPerformanceDeduceDate(new Date());
            purchaseFrequencyDeviationDataResult.add(purchaseFrequencyDeviationData);
        }
        if (CollUtil.isNotEmpty(purchaseFrequencyDeviationDataResult)) {
            this.purchaseFrequencyDeviationDataService.saveOrUpdateBatch(purchaseFrequencyDeviationDataResult);
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)Result.ok((String)"\u6210\u529f")));
    }
}

