/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.api.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.els.common.api.vo.Result;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.extend.api.dto.PurchaseDeliveryHeadExtDTO;
import com.els.modules.extend.api.dto.PurchaseOrderHeadExtDTO;
import com.els.modules.extend.api.dto.PurchasePassRateDataExtDTO;
import com.els.modules.extend.api.service.PurchaseDeliveryHeadExtRpcService;
import com.els.modules.extend.api.service.PurchaseOrderHeadExtRpcService;
import com.els.modules.report.entity.PurchaseDeviationReleaseData;
import com.els.modules.report.entity.PurchasePassRateData;
import com.els.modules.report.service.PurchaseDeviationReleaseDataService;
import com.els.modules.report.service.PurchasePassRateDataService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchasePassRateDataApiServiceimpl
implements SimpleOpenApiRpcService {
    @Autowired
    SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Autowired
    PurchaseDeliveryHeadExtRpcService purchaseDeliveryHeadExtRpcService;
    @Autowired
    PurchaseOrderHeadExtRpcService purchaseOrderHeadExtRpcService;
    @Autowired
    PurchasePassRateDataService purchasePassRateDataService;
    @Autowired
    PurchaseDeviationReleaseDataService purchaseDeviationReleaseDataService;

    public JSONObject invoke(JSONObject jsonObject) {
        List purchasePassRateDataList = (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject.getJSONArray("list")), (TypeReference)new TypeReference<List<PurchasePassRateDataExtDTO>>(){}, (Feature[])new Feature[0]);
        Map<String, List<PurchasePassRateDataExtDTO>> purchasePassRateDataMap = purchasePassRateDataList.stream().collect(Collectors.groupingBy(PurchasePassRateDataExtDTO::getSupplierCode));
        Set<String> supplieCodeSet = purchasePassRateDataMap.keySet();
        ArrayList<String> supplieCodeList = new ArrayList<String>(supplieCodeSet);
        List supplierMasterDataDTOList = this.supplierMasterDataRpcService.getSupplierMasterDataBySupplierCode(supplieCodeList);
        Map supplierMasterDataDTOMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getSupplierCode, Function.identity()));
        List allDeliveryNumberList = purchasePassRateDataList.stream().map(PurchasePassRateDataExtDTO::getDeliveryNum).collect(Collectors.toList());
        List allOrderNumberList = purchasePassRateDataList.stream().map(PurchasePassRateDataExtDTO::getOrderNum).collect(Collectors.toList());
        List deliveryDTOList = this.purchaseDeliveryHeadExtRpcService.selectPurcherDeliveryHeadByDeliveryNumbers(allDeliveryNumberList);
        Map deliveryHeadMap = deliveryDTOList.stream().collect(Collectors.toMap(PurchaseDeliveryHeadExtDTO::getDeliveryNumber, Function.identity()));
        List purchaseOrderHeadExtDTOList = this.purchaseOrderHeadExtRpcService.selectPurcherOrderHeadByNumbers(allOrderNumberList);
        Map orderHeadMap = purchaseOrderHeadExtDTOList.stream().collect(Collectors.toMap(PurchaseOrderHeadExtDTO::getOrderNumber, Function.identity()));
        ArrayList<PurchasePassRateData> purchasePassRateDataResult = new ArrayList<PurchasePassRateData>();
        ArrayList<PurchaseDeviationReleaseData> purchaseDeviationReleaseDataResult = new ArrayList<PurchaseDeviationReleaseData>();
        for (PurchasePassRateDataExtDTO purchasePassRateDataExtDTO : purchasePassRateDataList) {
            String supplierCode = purchasePassRateDataExtDTO.getSupplierCode();
            SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(supplierCode);
            if (!"\u504f\u5dee\u653e\u884c".equals(purchasePassRateDataExtDTO.getCheckFormResult())) {
                PurchaseDeliveryHeadExtDTO purchaseDeliveryHeadExtDTO = (PurchaseDeliveryHeadExtDTO)deliveryHeadMap.get(purchasePassRateDataExtDTO.getDeliveryNum());
                PurchasePassRateData purchasePassRateData = new PurchasePassRateData();
                purchasePassRateData.setToElsAccount(supplierMasterDataDTO.getToElsAccount());
                purchasePassRateData.setSupplierCode(purchasePassRateDataExtDTO.getSupplierCode());
                purchasePassRateData.setSupplierName(purchasePassRateDataExtDTO.getSupplierName());
                purchasePassRateData.setOrderNumber(purchasePassRateDataExtDTO.getOrderNum());
                purchasePassRateData.setOrderItemNumber(purchasePassRateDataExtDTO.getOrderItemNum());
                purchasePassRateData.setBusinessUnit(purchaseDeliveryHeadExtDTO.getBusinessUnit());
                purchasePassRateData.setMaterialCategory(purchaseDeliveryHeadExtDTO.getMaterialCategory());
                purchasePassRateData.setMaterialMiddleCategory(purchaseDeliveryHeadExtDTO.getMaterialMiddleCategory());
                purchasePassRateData.setMaterialSmallCategory(purchaseDeliveryHeadExtDTO.getMaterialSmallCategory());
                purchasePassRateData.setDeliveryNumber(purchasePassRateDataExtDTO.getDeliveryNum());
                purchasePassRateData.setDeliveryItemNumber(purchasePassRateDataExtDTO.getDeliveryItemNum());
                purchasePassRateData.setMaterialNumber(purchasePassRateDataExtDTO.getMaterialNum());
                purchasePassRateData.setMaterialDesc(purchasePassRateDataExtDTO.getMaterialName());
                purchasePassRateData.setRequisitionNumber(purchasePassRateDataExtDTO.getCheckFormNum());
                purchasePassRateData.setRequisitionResult(purchasePassRateDataExtDTO.getCheckFormResult());
                purchasePassRateData.setPerformanceDeduce("\u68c0\u9a8c\u5408\u683c".equals(purchasePassRateDataExtDTO.getCheckFormResult()) ? "\u5408\u683c" : "\u4e0d\u5408\u683c");
                purchasePassRateData.setPerformanceDeduceDate(new Date());
                purchasePassRateDataResult.add(purchasePassRateData);
                continue;
            }
            if (!orderHeadMap.containsKey(purchasePassRateDataExtDTO.getOrderNum())) continue;
            PurchaseOrderHeadExtDTO purchaseOrderHeadExtDTO = (PurchaseOrderHeadExtDTO)orderHeadMap.get(purchasePassRateDataExtDTO.getOrderNum());
            PurchaseDeviationReleaseData purchaseDeviationReleaseData = new PurchaseDeviationReleaseData();
            purchaseDeviationReleaseData.setToElsAccount(supplierMasterDataDTO.getToElsAccount());
            purchaseDeviationReleaseData.setSupplierCode(supplierMasterDataDTO.getSupplierCode());
            purchaseDeviationReleaseData.setSupplierName(supplierMasterDataDTO.getSupplierName());
            purchaseDeviationReleaseData.setOrderNumber(purchasePassRateDataExtDTO.getOrderNum());
            purchaseDeviationReleaseData.setK3OrderNumber(purchasePassRateDataExtDTO.getOrderNum());
            purchaseDeviationReleaseData.setBusinessUnit(purchaseOrderHeadExtDTO.getBusinessUnit());
            purchaseDeviationReleaseData.setMaterialCategory(purchaseOrderHeadExtDTO.getMaterialCategory());
            purchaseDeviationReleaseData.setMaterialMiddleCategory(purchaseOrderHeadExtDTO.getMaterialMiddleCategory());
            purchaseDeviationReleaseData.setMaterialSmallCategory(purchaseOrderHeadExtDTO.getMaterialSmallCategory());
            purchaseDeviationReleaseData.setDeduction(purchasePassRateDataExtDTO.getDeduct());
            purchaseDeviationReleaseData.setMaterialNumber(purchasePassRateDataExtDTO.getMaterialNum());
            purchaseDeviationReleaseData.setMaterialDesc(purchasePassRateDataExtDTO.getMaterialName());
            purchaseDeviationReleaseData.setPerformanceDeduce("");
            purchaseDeviationReleaseData.setPerformanceDeduceDate(new Date());
            purchaseDeviationReleaseDataResult.add(purchaseDeviationReleaseData);
        }
        if (CollUtil.isNotEmpty(purchasePassRateDataResult)) {
            this.purchasePassRateDataService.saveOrUpdateBatch(purchasePassRateDataResult);
        }
        if (CollUtil.isNotEmpty(purchaseDeviationReleaseDataResult)) {
            this.purchaseDeviationReleaseDataService.saveOrUpdateBatch(purchaseDeviationReleaseDataResult);
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)Result.ok((String)"\u6210\u529f")));
    }
}

