/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.api.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.extend.api.dto.PurchaseDeliveryHeadExtDTO;
import com.els.modules.extend.api.dto.PurchaseDeliveryItemExtDTO;
import com.els.modules.extend.api.service.PurchaseDeliveryHeadExtRpcService;
import com.els.modules.extend.api.service.PurchaseVoucherItemExtRpcService;
import com.els.modules.report.entity.PurchaseUnnumberedSourceData;
import com.els.modules.report.service.PurchaseUnnumberedSourceDataService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseUnnumberedSourceDataApiServiceimpl
implements SimpleOpenApiRpcService {
    @Autowired
    PurchaseVoucherItemExtRpcService purchaseVoucherItemRpcService;
    @Autowired
    SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Autowired
    PurchaseDeliveryHeadExtRpcService purchaseDeliveryHeadExtRpcService;
    @Autowired
    PurchaseUnnumberedSourceDataService purchaseUnnumberedSourceDataService;

    public JSONObject invoke(JSONObject jsonObject) {
        List purchaseUnnumberedSourceDataList = (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonObject.getJSONArray("list")), (TypeReference)new TypeReference<List<PurchaseUnnumberedSourceData>>(){}, (Feature[])new Feature[0]);
        Map<String, List<PurchaseUnnumberedSourceData>> purchaseUnnumberedSourceDataMap = purchaseUnnumberedSourceDataList.stream().collect(Collectors.groupingBy(PurchaseUnnumberedSourceData::getSupplierCode));
        Set<String> supplieCodeSet = purchaseUnnumberedSourceDataMap.keySet();
        ArrayList<String> supplieCodeList = new ArrayList<String>(supplieCodeSet);
        List supplierMasterDataDTOList = this.supplierMasterDataRpcService.getSupplierMasterDataBySupplierCode(supplieCodeList);
        Map supplierMasterDataDTOMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getSupplierCode, Function.identity()));
        ArrayList allDeliveryNumberList = new ArrayList();
        for (String supplierCode : purchaseUnnumberedSourceDataMap.keySet()) {
            List<PurchaseUnnumberedSourceData> purchaseUnnumberedSourceDataParam = purchaseUnnumberedSourceDataMap.get(supplierCode);
            Set voucherNumbers = purchaseUnnumberedSourceDataParam.stream().map(PurchaseUnnumberedSourceData::getByBatchNumber).collect(Collectors.toSet());
            SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(supplierCode);
            List purchaseVoucherItemDTOList = this.purchaseVoucherItemRpcService.checkVoucherByBaiyaoNums(voucherNumbers, SysUtil.getPurchaseAccount(), supplierMasterDataDTO.getToElsAccount());
            List deliveryNumberList = purchaseVoucherItemDTOList.stream().map(PurchaseVoucherItemDTO::getDeliveryNumber).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(deliveryNumberList)) continue;
            allDeliveryNumberList.addAll(deliveryNumberList);
        }
        if (CollectionUtil.isEmpty(allDeliveryNumberList)) {
            throw new ELSBootException("\u53d1\u8d27\u5355\u4e3a\u7a7a");
        }
        List deliveryItemDTOList = this.purchaseDeliveryHeadExtRpcService.selectPurcherDeliveryItemByDeliveryNumbers(allDeliveryNumberList);
        Map<String, List<PurchaseDeliveryItemExtDTO>> deliveryItemMap = deliveryItemDTOList.stream().collect(Collectors.groupingBy(PurchaseDeliveryItemExtDTO::getBaiyaoBatchNumber));
        List deliveryDTOList = this.purchaseDeliveryHeadExtRpcService.selectPurcherDeliveryHeadByDeliveryNumbers(allDeliveryNumberList);
        Map deliveryHeadMap = deliveryDTOList.stream().collect(Collectors.toMap(PurchaseDeliveryHeadExtDTO::getDeliveryNumber, Function.identity()));
        ArrayList<PurchaseUnnumberedSourceData> purchaseUnnumberedSourceDataListResult = new ArrayList<PurchaseUnnumberedSourceData>();
        for (PurchaseUnnumberedSourceData purchaseUnnumberedSourceData : purchaseUnnumberedSourceDataList) {
            String supplierCode = purchaseUnnumberedSourceData.getSupplierCode();
            SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(supplierCode);
            Optional purchaseDeliveryItemExtDTOOp = deliveryItemMap.get(purchaseUnnumberedSourceData.getByBatchNumber()).stream().findFirst();
            if (!purchaseDeliveryItemExtDTOOp.isPresent()) {
                throw new ELSBootException("\u51ed\u8bc1\u53f7\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355");
            }
            PurchaseDeliveryItemExtDTO purchaseDeliveryItemExtDTO = (PurchaseDeliveryItemExtDTO)purchaseDeliveryItemExtDTOOp.get();
            PurchaseDeliveryHeadExtDTO purchaseDeliveryHeadExtDTO = (PurchaseDeliveryHeadExtDTO)deliveryHeadMap.get(purchaseDeliveryItemExtDTO.getDeliveryNumber());
            purchaseUnnumberedSourceData.setToElsAccount(supplierMasterDataDTO.getToElsAccount());
            purchaseUnnumberedSourceData.setSupplierCode(supplierMasterDataDTO.getSupplierCode());
            purchaseUnnumberedSourceData.setSupplierName(supplierMasterDataDTO.getSupplierName());
            purchaseUnnumberedSourceData.setUnnumberedSourceNumber("");
            purchaseUnnumberedSourceData.setOrderNumber(purchaseDeliveryItemExtDTO.getOrderNumber());
            purchaseUnnumberedSourceData.setOrderItemNumber(purchaseDeliveryItemExtDTO.getOrderItemNumber());
            purchaseUnnumberedSourceData.setBusinessUnit(purchaseDeliveryHeadExtDTO.getBusinessUnit());
            purchaseUnnumberedSourceData.setBusinessEntity("");
            purchaseUnnumberedSourceData.setMaterialCategory(purchaseDeliveryHeadExtDTO.getMaterialCategory());
            purchaseUnnumberedSourceData.setMaterialMiddleCategory(purchaseDeliveryHeadExtDTO.getMaterialMiddleCategory());
            purchaseUnnumberedSourceData.setMaterialSmallCategory(purchaseDeliveryHeadExtDTO.getMaterialSmallCategory());
            purchaseUnnumberedSourceData.setDeliveryNumber(purchaseDeliveryHeadExtDTO.getDeliveryNumber());
            purchaseUnnumberedSourceData.setDeliveryItemNumber(purchaseDeliveryItemExtDTO.getItemNumber());
            purchaseUnnumberedSourceData.setMaterialNumber(purchaseDeliveryItemExtDTO.getMaterialNumber());
            purchaseUnnumberedSourceData.setMaterialDesc(purchaseDeliveryItemExtDTO.getMaterialDesc());
            purchaseUnnumberedSourceData.setPerformanceDeduce("\u4e0d\u5408\u683c");
            purchaseUnnumberedSourceData.setPerformanceDeduceDate(new Date());
            purchaseUnnumberedSourceDataListResult.add(purchaseUnnumberedSourceData);
        }
        if (CollUtil.isNotEmpty(purchaseUnnumberedSourceDataListResult)) {
            this.purchaseUnnumberedSourceDataService.saveOrUpdateBatch(purchaseUnnumberedSourceDataListResult);
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)Result.ok((String)"\u6210\u529f")));
    }
}

