/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.job;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.DateUtils;
import com.els.common.util.SysUtil;
import com.els.modules.extend.api.dto.PurchaseOrderDeliveryPlanExtDTO;
import com.els.modules.extend.api.dto.PurchaseOrderItemExtDTO;
import com.els.modules.extend.api.service.PurchaseOrderDeliveryPlanExtRpcService;
import com.els.modules.extend.api.service.PurchaseOrderItemExtRpcService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.service.PurchaseOrderHeadRpcService;
import com.els.modules.report.entity.PurchaseCrossSourceData;
import com.els.modules.report.service.PurchaseCrossSourceDataService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseCrossSourceDataJob")
public class CrossSourceDataJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(CrossSourceDataJob.class);
    @Autowired
    private PurchaseCrossSourceDataService purchaseCrossSourceDataService;
    @Autowired
    private PurchaseOrderItemExtRpcService purchaseOrderItemExtRpcService;
    @Autowired
    private PurchaseOrderDeliveryPlanExtRpcService purchaseOrderDeliveryPlanExtRpcService;
    @Autowired
    private PurchaseOrderHeadRpcService purchaseOrderHeadRpcService;
    @Autowired
    private SupplierMasterDataRpcService supplierMasterDataRpcService;

    public void execute(String parameter) {
        log.info("\u7ee9\u6548\u4ea4\u91cf\u6e90\u6570\u636e \u836f\u54c1\u3001\u5927\u5065\u5eb7 ContractFinishJob \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        JSONObject jsonObject = JSONObject.parseObject((String)parameter);
        String timeRange = jsonObject.get((Object)"timeRange").toString();
        String startTime = null;
        String endTime = null;
        List purchaseOrderDeliveryPlanDTOList = new ArrayList();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String yesterday = null;
        if (StringUtils.isNotBlank((CharSequence)timeRange)) {
            String[] str = timeRange.split("~");
            if (str.length != 2) {
                log.error("\u65f6\u95f4\u8303\u56f4\u683c\u5f0f\u4e0d\u6b63\u786e: " + timeRange);
                return;
            }
            startTime = str[0];
            endTime = str[1];
            purchaseOrderDeliveryPlanDTOList = this.purchaseOrderDeliveryPlanExtRpcService.getPurchaseOrderDeliveryPlanList(startTime, endTime);
        } else {
            purchaseOrderDeliveryPlanDTOList = this.purchaseOrderDeliveryPlanExtRpcService.getPurchaseOrderDeliveryPlanList();
            yesterday = LocalDate.now().minusDays(1L).format(formatter);
        }
        Set orderNumberSet = purchaseOrderDeliveryPlanDTOList.stream().map(PurchaseOrderDeliveryPlanExtDTO::getOrderNumber).collect(Collectors.toSet());
        ArrayList orderNumberList = new ArrayList(orderNumberSet);
        List purchaseOrderItemDTOList = this.purchaseOrderItemExtRpcService.listPurchaseOrderItemByOrderNumber(orderNumberList);
        Map<String, Map<String, List<PurchaseOrderItemExtDTO>>> purchaseOrderItemDTOMap = purchaseOrderItemDTOList.stream().collect(Collectors.groupingBy(PurchaseOrderItemExtDTO::getOrderNumber, Collectors.groupingBy(PurchaseOrderItemExtDTO::getItemNumber)));
        List purchaseOrderHeadList = this.purchaseOrderHeadRpcService.listPurchaseOrderHeadByOrderNumber(orderNumberList);
        Map purchaseOrderHeadMap = purchaseOrderHeadList.stream().collect(Collectors.toMap(PurchaseOrderHeadDTO::getOrderNumber, Function.identity()));
        Set toElsSet = purchaseOrderDeliveryPlanDTOList.stream().map(PurchaseOrderDeliveryPlanExtDTO::getToElsAccount).collect(Collectors.toSet());
        ArrayList toElsList = new ArrayList(toElsSet);
        List supplierMasterDataDTOList = this.supplierMasterDataRpcService.selectSupplerList(SysUtil.getPurchaseAccount(), toElsList);
        Map supplierMasterDataDTOMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Map<String, List<PurchaseOrderDeliveryPlanExtDTO>> purchaseOrderDeliveryPlanDTOMap = purchaseOrderDeliveryPlanDTOList.stream().collect(Collectors.groupingBy(dto -> simpleDateFormat.format(dto.getRequireDate())));
        ArrayList<PurchaseCrossSourceData> result = new ArrayList<PurchaseCrossSourceData>();
        if (StringUtils.isNotBlank((CharSequence)timeRange)) {
            purchaseOrderDeliveryPlanDTOMap.values().forEach(list -> {
                for (PurchaseOrderDeliveryPlanExtDTO dto : list) {
                    PurchaseOrderItemExtDTO orderItemDTO;
                    Optional orderItemDTOOptional = ((List)((Map)purchaseOrderItemDTOMap.get(dto.getOrderNumber())).get(dto.getOrderItemNumber())).stream().findFirst();
                    if (!orderItemDTOOptional.isPresent()) {
                        log.error("\u4ea4\u8d27\u8ba1\u5212id:" + dto.getId() + "\u627e\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355\u884c");
                    }
                    if ("ZY".equals((orderItemDTO = (PurchaseOrderItemExtDTO)orderItemDTOOptional.get()).getBusinessUnit())) continue;
                    SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(dto.getToElsAccount());
                    PurchaseOrderHeadDTO purchaseOrderHeadDTO = (PurchaseOrderHeadDTO)purchaseOrderHeadMap.get(dto.getOrderNumber());
                    PurchaseCrossSourceData purchaseCrossSourceData = new PurchaseCrossSourceData();
                    purchaseCrossSourceData.setToElsAccount(dto.getToElsAccount());
                    purchaseCrossSourceData.setSupplierCode(supplierMasterDataDTO.getSupplierCode());
                    purchaseCrossSourceData.setSupplierName(supplierMasterDataDTO.getSupplierName());
                    purchaseCrossSourceData.setCrossSourceNumber("");
                    purchaseCrossSourceData.setOrderNumber(orderItemDTO.getOrderNumber());
                    purchaseCrossSourceData.setOrderItemNumber(orderItemDTO.getItemNumber());
                    purchaseCrossSourceData.setBusinessUnit(orderItemDTO.getBusinessUnit());
                    purchaseCrossSourceData.setBusinessEntity(purchaseOrderHeadDTO.getPurchaseOrg());
                    purchaseCrossSourceData.setMaterialCategory(orderItemDTO.getMaterialCategory());
                    purchaseCrossSourceData.setMaterialMiddleCategory(orderItemDTO.getMaterialMiddleCategory());
                    purchaseCrossSourceData.setMaterialSmallCategory(orderItemDTO.getMaterialSmallCategory());
                    purchaseCrossSourceData.setMaterialNumber(orderItemDTO.getMaterialNumber());
                    purchaseCrossSourceData.setMaterialDesc(orderItemDTO.getMaterialDesc());
                    purchaseCrossSourceData.setRequiredQuantity(dto.getPlanDeliveryQuantity());
                    purchaseCrossSourceData.setCheckArrivalQuantity(dto.getReceiveQuantity());
                    purchaseCrossSourceData.setPerformanceDeduceDate(dto.getPlanDeliveryDate());
                    purchaseCrossSourceData.setElsAccount(SysUtil.getPurchaseAccount());
                    BigDecimal quantity = dto.getQuantity();
                    if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                        log.error("\u4ea4\u8d27\u8ba1\u5212id:" + dto.getId() + "\u8ba2\u5355\u6570\u91cf\u4e3a\u96f6\uff0c\u65e0\u6cd5\u8ba1\u7b97\u4ea4\u8d27\u8ba1\u5212\u5f97\u5206");
                        continue;
                    }
                    BigDecimal difference = purchaseCrossSourceData.getCheckArrivalQuantity().subtract(quantity);
                    BigDecimal point = difference.divide(quantity, 2, RoundingMode.HALF_UP);
                    BigDecimal absoluteResult = point.abs();
                    purchaseCrossSourceData.setDeliveryScheduleScore(absoluteResult);
                    result.add(purchaseCrossSourceData);
                }
            });
        } else {
            for (PurchaseOrderDeliveryPlanExtDTO dto2 : purchaseOrderDeliveryPlanDTOMap.get(yesterday)) {
                PurchaseOrderItemExtDTO orderItemDTO;
                Optional orderItemDTOOptional = purchaseOrderItemDTOMap.get(dto2.getOrderNumber()).get(dto2.getOrderItemNumber()).stream().findFirst();
                if (!orderItemDTOOptional.isPresent()) {
                    log.error("\u4ea4\u8d27\u8ba1\u5212id:" + dto2.getId() + "\u627e\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355\u884c");
                }
                if ("ZY".equals((orderItemDTO = (PurchaseOrderItemExtDTO)orderItemDTOOptional.get()).getBusinessUnit())) continue;
                SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(dto2.getToElsAccount());
                PurchaseOrderHeadDTO purchaseOrderHeadDTO = (PurchaseOrderHeadDTO)purchaseOrderHeadMap.get(dto2.getOrderNumber());
                PurchaseCrossSourceData purchaseCrossSourceData = new PurchaseCrossSourceData();
                purchaseCrossSourceData.setToElsAccount(dto2.getToElsAccount());
                purchaseCrossSourceData.setSupplierCode(supplierMasterDataDTO.getSupplierCode());
                purchaseCrossSourceData.setSupplierName(supplierMasterDataDTO.getSupplierName());
                purchaseCrossSourceData.setCrossSourceNumber("");
                purchaseCrossSourceData.setOrderNumber(orderItemDTO.getOrderNumber());
                purchaseCrossSourceData.setOrderItemNumber(orderItemDTO.getItemNumber());
                purchaseCrossSourceData.setBusinessUnit(orderItemDTO.getBusinessUnit());
                purchaseCrossSourceData.setBusinessEntity(purchaseOrderHeadDTO.getPurchaseOrg());
                purchaseCrossSourceData.setMaterialCategory(orderItemDTO.getMaterialCategory());
                purchaseCrossSourceData.setMaterialMiddleCategory(orderItemDTO.getMaterialMiddleCategory());
                purchaseCrossSourceData.setMaterialSmallCategory(orderItemDTO.getMaterialSmallCategory());
                purchaseCrossSourceData.setMaterialNumber(orderItemDTO.getMaterialNumber());
                purchaseCrossSourceData.setMaterialDesc(orderItemDTO.getMaterialDesc());
                purchaseCrossSourceData.setRequiredQuantity(dto2.getPlanDeliveryQuantity());
                purchaseCrossSourceData.setCheckArrivalQuantity(dto2.getReceiveQuantity());
                purchaseCrossSourceData.setPerformanceDeduceDate(new Date());
                purchaseCrossSourceData.setElsAccount(SysUtil.getPurchaseAccount());
                BigDecimal quantity = dto2.getQuantity();
                if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                    log.error("\u4ea4\u8d27\u8ba1\u5212id:" + dto2.getId() + "\u8ba2\u5355\u6570\u91cf\u4e3a\u96f6\uff0c\u65e0\u6cd5\u8ba1\u7b97\u4ea4\u8d27\u8ba1\u5212\u5f97\u5206");
                    continue;
                }
                BigDecimal difference = purchaseCrossSourceData.getCheckArrivalQuantity().subtract(quantity);
                BigDecimal point = difference.divide(quantity, 2, RoundingMode.HALF_UP);
                BigDecimal absoluteResult = point.abs();
                purchaseCrossSourceData.setDeliveryScheduleScore(absoluteResult);
                result.add(purchaseCrossSourceData);
            }
        }
        this.purchaseCrossSourceDataService.saveOrUpdateBatch(result);
    }
}

