/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.job;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.extend.api.dto.PurchaseContractHeadDTOS;
import com.els.modules.extend.api.service.PurchaseContractApiService;
import com.els.modules.report.entity.PurchasePaymentMethodData;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentMethodDataJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(PaymentMethodDataJob.class);
    @Autowired
    private PurchaseContractApiService purchaseContractApiService;
    @Autowired
    private RedisUtil redisUtil;
    private final String LOCK_PREFIX = "paymentMethodDataJob";
    private final long EXPIRE_TIME = 50000L;

    public void execute(String parameter) {
        log.info("\u91c7\u8d2d\u5408\u540c\u6267\u884c\u5b8c\u6210\u63d0\u9192\u5b9a\u65f6\u4efb\u52a1 ContractFinishJob \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String tenantId = paramObj.getString("tenantId");
        String contractNumber = paramObj.getString("contractNumber");
        String contractStatus = paramObj.getString("contractStatus");
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            tenantId = "100000";
        }
        TenantContext.setTenant((String)tenantId);
        String requestId = TenantContext.getTenant();
        if (!this.redisUtil.tryGetDistributedLock("paymentMethodDataJob", requestId, 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXLiJLRvIKLSiKRcWVxPVBRc_5c1c55b42", (String)"\u83b7\u53d6\u7ee9\u6548\u4ed8\u6b3e\u65b9\u5f0f\uff0c\u8d26\u671f\u6e90\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            List purchaseContractHeadDTOS = this.purchaseContractApiService.selectByContractStatus(contractStatus, contractNumber);
            for (PurchaseContractHeadDTOS purchaseContractHeadDTO : purchaseContractHeadDTOS) {
                PurchasePaymentMethodData purchasePaymentMethodData = new PurchasePaymentMethodData();
                purchasePaymentMethodData.setToElsAccount(purchaseContractHeadDTO.getToElsAccount());
                purchasePaymentMethodData.setSupplierName(purchaseContractHeadDTO.getSupplierName());
                purchasePaymentMethodData.setSupplierCode(purchaseContractHeadDTO.getSupplierCode());
                purchasePaymentMethodData.setContractNumber(purchaseContractHeadDTO.getContractNumber());
                purchasePaymentMethodData.setContractName(purchaseContractHeadDTO.getContractName());
                purchasePaymentMethodData.setContractExpirationDate(purchaseContractHeadDTO.getExpiryDate());
                purchasePaymentMethodData.setBusinessUnit(purchaseContractHeadDTO.getBusinessUnit());
                purchasePaymentMethodData.setBusinessEntity(purchaseContractHeadDTO.getCompany());
                purchasePaymentMethodData.setPayCycle(purchaseContractHeadDTO.getPaymentCondition());
                if (!purchaseContractHeadDTO.getPaymentCondition().equals("")) continue;
                purchasePaymentMethodData.setContractPeriodScore(new BigDecimal(0));
            }
        }
        catch (Exception e) {
            log.info(Thread.currentThread().getName() + "\u83b7\u53d6\u7ee9\u6548\u4ed8\u6b3e\u65b9\u5f0f\uff0c\u8d26\u671f\u6e90\u6570\u636e\u5b9a\u65f6\u4efb\u52a1:", (Throwable)e);
            throw new ELSBootException("\u83b7\u53d6\u7ee9\u6548\u4ed8\u6b3e\u65b9\u5f0f\uff0c\u8d26\u671f\u6e90\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock("paymentMethodDataJob", requestId);
            LoginUserContext.clear();
        }
    }
}

