/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.job;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.modules.extend.api.dto.PaymentClauseDTO;
import com.els.modules.extend.api.dto.PurchaseContractHeadDTO;
import com.els.modules.extend.api.dto.PurchaseContractItemExtDTO;
import com.els.modules.extend.api.service.PaymentClauseBeanService;
import com.els.modules.extend.api.service.PurchaseContractApiService;
import com.els.modules.report.entity.PurchasePaymentMethodData;
import com.els.modules.report.service.PurchasePaymentMethodDataService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="PurchasePaymentMethodDataJob")
public class PurchasePaymentMethodDataJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePaymentMethodDataJob.class);
    @Resource
    private PurchasePaymentMethodDataService purchasePaymentMethodDataService;
    @Resource
    private PurchaseContractApiService purchaseContractApiService;
    @Resource
    private PaymentClauseBeanService paymentClause;

    public void execute(String parameter) {
        List<PurchaseContractHeadDTO> PurchaseContractHeadDTOList;
        JSONObject jsonObject = JSONObject.parseObject((String)parameter);
        String timeRange = jsonObject.getString("timeRange");
        ArrayList<PurchasePaymentMethodData> result = new ArrayList<PurchasePaymentMethodData>();
        if (StringUtils.isNotEmpty((CharSequence)timeRange)) {
            String[] timeRangeArr = timeRange.split("~");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate startDate = LocalDate.parse(timeRangeArr[0], formatter);
            LocalDate endDate = timeRangeArr.length > 1 ? LocalDate.parse(timeRangeArr[1], formatter) : LocalDate.now();
            PurchaseContractHeadDTOList = this.purchaseContractApiService.getPurchaseContractHeadDataList(startDate, endDate);
        } else {
            PurchaseContractHeadDTOList = this.purchaseContractApiService.getPurchaseContractHeadDataList();
        }
        Set contractNumberSet = PurchaseContractHeadDTOList.stream().map(PurchaseContractHeadDTO::getContractNumber).collect(Collectors.toSet());
        ArrayList<String> contractNumberList = new ArrayList<String>(contractNumberSet);
        if (contractNumberList.size() < 1) {
            return;
        }
        List<PurchasePaymentMethodData> purchasePaymentMethodDataList = this.purchasePaymentMethodDataService.getPurchasePaymentMethodDataList(contractNumberList);
        Set paymentMethodOrderNumberSet = purchasePaymentMethodDataList.stream().map(PurchasePaymentMethodData::getContractNumber).collect(Collectors.toSet());
        List<PurchaseContractHeadDTO> matchedContractList = paymentMethodOrderNumberSet.isEmpty() ? PurchaseContractHeadDTOList : PurchaseContractHeadDTOList.stream().filter(contract -> !paymentMethodOrderNumberSet.contains(contract.getContractNumber())).toList();
        Set headIdSet = matchedContractList.stream().map(PurchaseContractHeadDTO::getId).collect(Collectors.toSet());
        ArrayList headIdList = new ArrayList(headIdSet);
        List purchaseContractItemDataList = this.purchaseContractApiService.getPurchaseContractItemDataList(headIdList);
        List paymentClauseList = this.paymentClause.getPaymentClauseList();
        Map<String, BigDecimal> paymentClauseMap = paymentClauseList.stream().collect(Collectors.toMap(PaymentClauseDTO::getPaymentClauseCode, PaymentClauseDTO::getPayCycle));
        for (PurchaseContractItemExtDTO purchaseContractItem : purchaseContractItemDataList) {
            PurchasePaymentMethodData purchasePaymentMethodData = new PurchasePaymentMethodData();
            String paymentCondition = purchaseContractItem.getPaymentCondition();
            if (!paymentClauseMap.containsKey(paymentCondition)) continue;
            BigDecimal payCycle = paymentClauseMap.get(paymentCondition);
            BigDecimal contractPeriodScore = this.assignContractPeriodScore(payCycle);
            purchasePaymentMethodData.setToElsAccount(purchaseContractItem.getToElsAccount());
            purchasePaymentMethodData.setSupplierCode(purchaseContractItem.getSupplierCode());
            purchasePaymentMethodData.setSupplierName(purchaseContractItem.getSupplierName());
            purchasePaymentMethodData.setBusinessUnit(purchaseContractItem.getBusinessUnit());
            purchasePaymentMethodData.setBusinessEntity(purchaseContractItem.getBusinessEntity());
            purchasePaymentMethodData.setMaterialCategory(purchaseContractItem.getMaterialCategory());
            purchasePaymentMethodData.setMaterialMiddleCategory(purchaseContractItem.getMaterialMiddleCategory());
            purchasePaymentMethodData.setMaterialSmallCategory(purchaseContractItem.getMaterialSmallCategory());
            purchasePaymentMethodData.setContractNumber(purchaseContractItem.getContractNumber());
            purchasePaymentMethodData.setContractName(purchaseContractItem.getContractName());
            purchasePaymentMethodData.setContractExpirationDate(purchaseContractItem.getContractExpirationDate());
            purchasePaymentMethodData.setPayCycle(this.determinePayCycle(contractPeriodScore));
            purchasePaymentMethodData.setContractPeriodScore(contractPeriodScore);
            purchasePaymentMethodData.setPerformanceDeduceDate(purchaseContractItem.getContractExpirationDate());
            purchasePaymentMethodData.setPaymentMethodNumber(purchaseContractItem.getPaymentCondition());
            result.add(purchasePaymentMethodData);
        }
        if (result.size() > 0) {
            this.purchasePaymentMethodDataService.saveBatch(result);
        }
    }

    public BigDecimal assignContractPeriodScore(BigDecimal payCycle) {
        BigDecimal contractPeriodScore = BigDecimal.ZERO;
        if (payCycle.compareTo(BigDecimal.ZERO) > 0 && payCycle.compareTo(new BigDecimal("30")) < 0) {
            contractPeriodScore = new BigDecimal("3.75");
        } else if (payCycle.compareTo(new BigDecimal("30")) == 0) {
            contractPeriodScore = new BigDecimal("5");
        } else if (payCycle.compareTo(new BigDecimal("60")) > 0 && payCycle.compareTo(new BigDecimal("90")) < 0) {
            contractPeriodScore = new BigDecimal("6.25");
        } else if (payCycle.compareTo(new BigDecimal("60")) == 0) {
            contractPeriodScore = new BigDecimal("7.5");
        } else if (payCycle.compareTo(new BigDecimal("90")) >= 0) {
            contractPeriodScore = new BigDecimal("10");
        }
        return contractPeriodScore;
    }

    public String determinePayCycle(BigDecimal contractPeriodScore) {
        String payCycleName = "\u9884\u4ed8\u6b3e";
        if (contractPeriodScore.compareTo(new BigDecimal("3.75")) == 0) {
            payCycleName = "0~30\u5929\u8d26\u671f";
        } else if (contractPeriodScore.compareTo(new BigDecimal("5")) == 0) {
            payCycleName = "30\u5929\u8d26\u671f";
        } else if (contractPeriodScore.compareTo(new BigDecimal("6.25")) == 0) {
            payCycleName = "60~90\u5929\u8d26\u671f";
        } else if (contractPeriodScore.compareTo(new BigDecimal("7.5")) == 0) {
            payCycleName = "60\u5929\u8d26\u671f";
        } else if (contractPeriodScore.compareTo(new BigDecimal("8.75")) == 0) {
            payCycleName = "60~90\u5929\u8d26\u671f";
        } else if (contractPeriodScore.compareTo(new BigDecimal("10")) == 0) {
            payCycleName = "90\u5929\u53ca\u4ee5\u4e0a\u8d26\u671f";
        }
        return payCycleName;
    }
}

