/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.job;

import com.alibaba.fastjson.JSONObject;
import com.els.api.dto.BaseDTO;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.DateUtils;
import com.els.common.util.SysUtil;
import com.els.modules.extend.api.dto.PurchaseOrderDeliveryPlanExtDTO;
import com.els.modules.extend.api.dto.PurchaseOrderItemExtDTO;
import com.els.modules.extend.api.service.PurchaseOrderDeliveryPlanExtRpcService;
import com.els.modules.extend.api.service.PurchaseOrderItemExtRpcService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.service.PurchaseOrderHeadRpcService;
import com.els.modules.report.entity.PurchaseCrossSourceData;
import com.els.modules.report.service.PurchaseCrossSourceDataService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ZYPurchaseCrossSourceDataJob")
public class ZYCrossSourceDataJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(ZYCrossSourceDataJob.class);
    @Autowired
    private PurchaseCrossSourceDataService purchaseCrossSourceDataService;
    @Autowired
    private PurchaseOrderItemExtRpcService purchaseOrderItemExtRpcService;
    @Autowired
    private PurchaseOrderDeliveryPlanExtRpcService purchaseOrderDeliveryPlanExtRpcService;
    @Autowired
    private PurchaseOrderHeadRpcService purchaseOrderHeadRpcService;
    @Autowired
    private SupplierMasterDataRpcService supplierMasterDataRpcService;

    public void execute(String parameter) {
        log.info("\u7ee9\u6548\u4ea4\u91cf\u6e90\u6570\u636e \u4e2d\u836f ContractFinishJob \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        LocalDate today = LocalDate.now();
        JSONObject jsonObject = JSONObject.parseObject((String)parameter);
        String timeRange = jsonObject.get((Object)"timeRange").toString();
        String semiannual = jsonObject.get((Object)"semiannual").toString();
        if (timeRange != null && !timeRange.isEmpty()) {
            today = LocalDate.parse(timeRange);
        }
        LocalDate startDate = null;
        LocalDate endDate = null;
        LocalDate allYearStart = null;
        if (today.getMonthValue() == 7 && today.getDayOfMonth() == 1) {
            startDate = today.minus(6L, ChronoUnit.MONTHS).withDayOfMonth(1);
            endDate = today.withDayOfMonth(1).minusDays(1L);
        } else if (today.getMonthValue() == 1 && today.getDayOfMonth() == 1) {
            startDate = today.minus(6L, ChronoUnit.MONTHS).withDayOfMonth(1);
            endDate = today.withDayOfMonth(1).minusDays(1L);
            if (semiannual == null && semiannual.isEmpty()) {
                allYearStart = today.minus(12L, ChronoUnit.MONTHS).withDayOfMonth(1);
            }
        }
        List purchaseOrderDeliveryPlanDTOList = this.purchaseOrderDeliveryPlanExtRpcService.getPurchaseOrderDeliveryPlanListByDate(startDate, endDate);
        if (allYearStart != null) {
            purchaseOrderDeliveryPlanDTOList.addAll(this.purchaseOrderDeliveryPlanExtRpcService.getPurchaseOrderDeliveryPlanListByDate(allYearStart, endDate));
        }
        Set orderNumberSet = purchaseOrderDeliveryPlanDTOList.stream().map(PurchaseOrderDeliveryPlanExtDTO::getOrderNumber).collect(Collectors.toSet());
        ArrayList orderNumberList = new ArrayList(orderNumberSet);
        List purchaseOrderItemDTOList = this.purchaseOrderItemExtRpcService.listPurchaseOrderItemByOrderNumber(orderNumberList);
        Map<String, Map<String, List<PurchaseOrderItemExtDTO>>> purchaseOrderItemDTOMap = purchaseOrderItemDTOList.stream().collect(Collectors.groupingBy(PurchaseOrderItemExtDTO::getOrderNumber, Collectors.groupingBy(PurchaseOrderItemExtDTO::getItemNumber)));
        List purchaseOrderHeadList = this.purchaseOrderHeadRpcService.listPurchaseOrderHeadByOrderNumber(orderNumberList);
        Map purchaseOrderHeadMap = purchaseOrderHeadList.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity()));
        Set toElsSet = purchaseOrderDeliveryPlanDTOList.stream().map(PurchaseOrderDeliveryPlanExtDTO::getToElsAccount).collect(Collectors.toSet());
        ArrayList toElsList = new ArrayList(toElsSet);
        List supplierMasterDataDTOList = this.supplierMasterDataRpcService.selectSupplerList(SysUtil.getPurchaseAccount(), toElsList);
        Map supplierMasterDataDTOMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity()));
        ArrayList<PurchaseCrossSourceData> result = new ArrayList<PurchaseCrossSourceData>();
        for (PurchaseOrderDeliveryPlanExtDTO dto : purchaseOrderDeliveryPlanDTOList) {
            PurchaseOrderItemExtDTO orderItemDTO;
            Optional orderItemDTOOptional = purchaseOrderItemDTOMap.get(dto.getOrderNumber()).get(dto.getOrderItemNumber()).stream().findFirst();
            if (!orderItemDTOOptional.isPresent()) {
                log.error("\u4ea4\u8d27\u8ba1\u5212id:" + dto.getId() + "\u627e\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355\u884c");
            }
            if (!"ZY".equals((orderItemDTO = (PurchaseOrderItemExtDTO)orderItemDTOOptional.get()).getBusinessUnit())) continue;
            SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(dto.getToElsAccount());
            PurchaseOrderHeadDTO purchaseOrderHeadDTO = (PurchaseOrderHeadDTO)purchaseOrderHeadMap.get(dto.getOrderNumber());
            PurchaseCrossSourceData purchaseCrossSourceData = new PurchaseCrossSourceData();
            purchaseCrossSourceData.setToElsAccount(dto.getToElsAccount());
            purchaseCrossSourceData.setSupplierCode(supplierMasterDataDTO.getSupplierCode());
            purchaseCrossSourceData.setSupplierName(supplierMasterDataDTO.getSupplierName());
            purchaseCrossSourceData.setCrossSourceNumber("");
            purchaseCrossSourceData.setOrderNumber(orderItemDTO.getOrderNumber());
            purchaseCrossSourceData.setOrderItemNumber(orderItemDTO.getItemNumber());
            purchaseCrossSourceData.setBusinessUnit(orderItemDTO.getBusinessUnit());
            purchaseCrossSourceData.setBusinessEntity(purchaseOrderHeadDTO.getPurchaseOrg());
            purchaseCrossSourceData.setMaterialCategory(orderItemDTO.getMaterialCategory());
            purchaseCrossSourceData.setMaterialMiddleCategory(orderItemDTO.getMaterialMiddleCategory());
            purchaseCrossSourceData.setMaterialSmallCategory(orderItemDTO.getMaterialSmallCategory());
            purchaseCrossSourceData.setMaterialNumber(orderItemDTO.getMaterialNumber());
            purchaseCrossSourceData.setMaterialDesc(orderItemDTO.getMaterialDesc());
            purchaseCrossSourceData.setRequiredQuantity(dto.getPlanDeliveryQuantity());
            purchaseCrossSourceData.setPerformanceDeduceDate(dto.getPlanDeliveryDate());
            purchaseCrossSourceData.setElsAccount(SysUtil.getPurchaseAccount());
            BigDecimal difference = dto.getReceiveQuantity().subtract(dto.getQuantity());
            BigDecimal point = difference.divide(dto.getQuantity(), 2, RoundingMode.HALF_UP);
            BigDecimal absoluteResult = point.abs();
            purchaseCrossSourceData.setDeliveryScheduleScore(absoluteResult);
            purchaseCrossSourceData.setPerformanceDeduce(absoluteResult.compareTo(new BigDecimal("0.5")) > 0 ? "\u5408\u683c" : "\u4e0d\u5408\u683c");
            if (allYearStart == null) {
                purchaseCrossSourceData.setCheckArrivalQuantity(dto.getReceiveQuantity());
            } else {
                purchaseCrossSourceData.setAnnualArrivalQuantity(dto.getReceiveQuantity());
            }
            result.add(purchaseCrossSourceData);
        }
        this.purchaseCrossSourceDataService.saveOrUpdateBatch(result);
    }
}

