/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.extend.api.dto.PurchaseOrderDeliveryPlanExtDTO;
import com.els.modules.extend.api.dto.PurchaseOrderItemExtDTO;
import com.els.modules.extend.api.service.PurchaseOrderDeliveryPlanExtRpcService;
import com.els.modules.extend.api.service.PurchaseOrderItemExtRpcService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.service.PurchaseOrderHeadRpcService;
import com.els.modules.report.entity.PurchaseCrossSourceData;
import com.els.modules.report.mapper.PurchaseCrossSourceDataMapper;
import com.els.modules.report.service.PurchaseCrossSourceDataService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseCrossSourceDataServiceImpl
extends BaseServiceImpl<PurchaseCrossSourceDataMapper, PurchaseCrossSourceData>
implements PurchaseCrossSourceDataService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseOrderItemExtRpcService purchaseOrderItemExtRpcService;
    @Autowired
    private PurchaseOrderDeliveryPlanExtRpcService purchaseOrderDeliveryPlanExtRpcService;
    @Autowired
    private PurchaseOrderHeadRpcService purchaseOrderHeadRpcService;
    @Autowired
    private SupplierMasterDataRpcService supplierMasterDataRpcService;

    @Override
    public void savePurchaseCrossSourceData(PurchaseCrossSourceData purchaseCrossSourceData) {
        if (StringUtils.isEmpty((String)purchaseCrossSourceData.getCrossSourceNumber())) {
            purchaseCrossSourceData.setCrossSourceNumber(this.invokeBaseRpcService.getNextCode("srmCrossSourceNumber", (Object)purchaseCrossSourceData));
        }
        purchaseCrossSourceData.setDeleted(CommonConstant.DEL_FLAG_0);
        ((PurchaseCrossSourceDataMapper)this.baseMapper).insert((Object)purchaseCrossSourceData);
    }

    @Override
    public void updatePurchaseCrossSourceData(PurchaseCrossSourceData purchaseCrossSourceData) {
        ((PurchaseCrossSourceDataMapper)this.baseMapper).updateById((Object)purchaseCrossSourceData);
    }

    @Override
    public void delPurchaseCrossSourceData(String id) {
        ((PurchaseCrossSourceDataMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseCrossSourceData(List<String> idList) {
        ((PurchaseCrossSourceDataMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void getPurchaseCrossSourceData() {
        List purchaseOrderDeliveryPlanDTOList = this.purchaseOrderDeliveryPlanExtRpcService.getPurchaseOrderDeliveryPlanList();
        Set orderNumberSet = purchaseOrderDeliveryPlanDTOList.stream().map(PurchaseOrderDeliveryPlanExtDTO::getOrderNumber).collect(Collectors.toSet());
        ArrayList orderNumberList = new ArrayList(orderNumberSet);
        List purchaseOrderItemDTOList = this.purchaseOrderItemExtRpcService.listPurchaseOrderItemByOrderNumber(orderNumberList);
        Map<String, Map<String, List<PurchaseOrderItemExtDTO>>> purchaseOrderItemDTOMap = purchaseOrderItemDTOList.stream().collect(Collectors.groupingBy(PurchaseOrderItemExtDTO::getOrderNumber, Collectors.groupingBy(PurchaseOrderItemExtDTO::getItemNumber)));
        List purchaseOrderHeadList = this.purchaseOrderHeadRpcService.listPurchaseOrderHeadByOrderNumber(orderNumberList);
        Map purchaseOrderHeadMap = purchaseOrderHeadList.stream().collect(Collectors.toMap(PurchaseOrderHeadDTO::getOrderNumber, Function.identity()));
        Set toElsSet = purchaseOrderDeliveryPlanDTOList.stream().map(PurchaseOrderDeliveryPlanExtDTO::getToElsAccount).collect(Collectors.toSet());
        ArrayList toElsList = new ArrayList(toElsSet);
        List supplierMasterDataDTOList = this.supplierMasterDataRpcService.selectSupplerList(SysUtil.getPurchaseAccount(), toElsList);
        Map supplierMasterDataDTOMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Map<String, List<PurchaseOrderDeliveryPlanExtDTO>> purchaseOrderDeliveryPlanDTOMap = purchaseOrderDeliveryPlanDTOList.stream().collect(Collectors.groupingBy(dto -> simpleDateFormat.format(dto.getRequireDate())));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String yesterday = LocalDate.now().minusDays(1L).format(formatter);
        ArrayList<PurchaseCrossSourceData> result = new ArrayList<PurchaseCrossSourceData>();
        for (PurchaseOrderDeliveryPlanExtDTO dto2 : purchaseOrderDeliveryPlanDTOMap.get(yesterday)) {
            PurchaseOrderItemExtDTO orderItemDTO;
            Optional orderItemDTOOptional = purchaseOrderItemDTOMap.get(dto2.getOrderNumber()).get(dto2.getOrderItemNumber()).stream().findFirst();
            if (!orderItemDTOOptional.isPresent()) {
                this.log.error("\u4ea4\u8d27\u8ba1\u5212id:" + dto2.getId() + "\u627e\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355\u884c");
            }
            if ("ZY".equals((orderItemDTO = (PurchaseOrderItemExtDTO)orderItemDTOOptional.get()).getBusinessUnit())) continue;
            SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(dto2.getToElsAccount());
            PurchaseOrderHeadDTO purchaseOrderHeadDTO = (PurchaseOrderHeadDTO)purchaseOrderHeadMap.get(dto2.getOrderNumber());
            PurchaseCrossSourceData purchaseCrossSourceData = new PurchaseCrossSourceData();
            purchaseCrossSourceData.setToElsAccount(dto2.getToElsAccount());
            purchaseCrossSourceData.setSupplierCode(supplierMasterDataDTO.getSupplierCode());
            purchaseCrossSourceData.setSupplierName(supplierMasterDataDTO.getSupplierName());
            purchaseCrossSourceData.setCrossSourceNumber("");
            purchaseCrossSourceData.setOrderNumber(orderItemDTO.getOrderNumber());
            purchaseCrossSourceData.setOrderItemNumber(orderItemDTO.getItemNumber());
            purchaseCrossSourceData.setBusinessUnit(orderItemDTO.getBusinessUnit());
            purchaseCrossSourceData.setBusinessEntity(purchaseOrderHeadDTO.getPurchaseOrg());
            purchaseCrossSourceData.setMaterialCategory(orderItemDTO.getMaterialCategory());
            purchaseCrossSourceData.setMaterialMiddleCategory(orderItemDTO.getMaterialMiddleCategory());
            purchaseCrossSourceData.setMaterialSmallCategory(orderItemDTO.getMaterialSmallCategory());
            purchaseCrossSourceData.setMaterialNumber(orderItemDTO.getMaterialNumber());
            purchaseCrossSourceData.setMaterialDesc(orderItemDTO.getMaterialDesc());
            purchaseCrossSourceData.setRequiredQuantity(dto2.getPlanDeliveryQuantity());
            purchaseCrossSourceData.setCheckArrivalQuantity(dto2.getReceiveQuantity());
            purchaseCrossSourceData.setPerformanceDeduceDate(new Date());
            purchaseCrossSourceData.setElsAccount(SysUtil.getPurchaseAccount());
            BigDecimal difference = purchaseCrossSourceData.getRequiredQuantity().subtract(dto2.getQuantity());
            BigDecimal point = difference.divide(dto2.getQuantity(), 2, RoundingMode.HALF_UP);
            BigDecimal absoluteResult = point.abs();
            purchaseCrossSourceData.setDeliveryScheduleScore(absoluteResult);
            result.add(purchaseCrossSourceData);
        }
        this.saveOrUpdateBatch(result);
    }

    @Override
    public void getZYPurchaseCrossSourceData() {
        LocalDate today = LocalDate.now();
        LocalDate startDate = null;
        LocalDate endDate = null;
        LocalDate allYearStart = null;
        if (today.getMonthValue() == 7 && today.getDayOfMonth() == 1) {
            startDate = today.minus(6L, ChronoUnit.MONTHS).withDayOfMonth(1);
            endDate = today.withDayOfMonth(1).minusDays(1L);
        } else if (today.getMonthValue() == 1 && today.getDayOfMonth() == 1) {
            startDate = today.minus(6L, ChronoUnit.MONTHS).withDayOfMonth(1);
            endDate = today.minus(1L, ChronoUnit.YEARS).withDayOfMonth(1).minusDays(1L);
            allYearStart = today.minus(12L, ChronoUnit.MONTHS).withDayOfMonth(1);
        }
        List purchaseOrderDeliveryPlanDTOList = this.purchaseOrderDeliveryPlanExtRpcService.getPurchaseOrderDeliveryPlanListByDate(startDate, endDate);
        if (allYearStart != null) {
            purchaseOrderDeliveryPlanDTOList.addAll(this.purchaseOrderDeliveryPlanExtRpcService.getPurchaseOrderDeliveryPlanListByDate(allYearStart, endDate));
        }
        Set orderNumberSet = purchaseOrderDeliveryPlanDTOList.stream().map(PurchaseOrderDeliveryPlanExtDTO::getOrderNumber).collect(Collectors.toSet());
        ArrayList orderNumberList = new ArrayList(orderNumberSet);
        List purchaseOrderItemDTOList = this.purchaseOrderItemExtRpcService.listPurchaseOrderItemByOrderNumber(orderNumberList);
        Map<String, Map<String, List<PurchaseOrderItemExtDTO>>> purchaseOrderItemDTOMap = purchaseOrderItemDTOList.stream().collect(Collectors.groupingBy(PurchaseOrderItemExtDTO::getOrderNumber, Collectors.groupingBy(PurchaseOrderItemExtDTO::getItemNumber)));
        List purchaseOrderHeadList = this.purchaseOrderHeadRpcService.listPurchaseOrderHeadByOrderNumber(orderNumberList);
        Map purchaseOrderHeadMap = purchaseOrderHeadList.stream().collect(Collectors.toMap(PurchaseOrderHeadDTO::getOrderNumber, Function.identity()));
        Set toElsSet = purchaseOrderDeliveryPlanDTOList.stream().map(PurchaseOrderDeliveryPlanExtDTO::getToElsAccount).collect(Collectors.toSet());
        ArrayList toElsList = new ArrayList(toElsSet);
        List supplierMasterDataDTOList = this.supplierMasterDataRpcService.selectSupplerList(SysUtil.getPurchaseAccount(), toElsList);
        Map supplierMasterDataDTOMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity()));
        ArrayList<PurchaseCrossSourceData> result = new ArrayList<PurchaseCrossSourceData>();
        for (PurchaseOrderDeliveryPlanExtDTO dto : purchaseOrderDeliveryPlanDTOList) {
            PurchaseOrderItemExtDTO orderItemDTO;
            Optional orderItemDTOOptional = purchaseOrderItemDTOMap.get(dto.getOrderNumber()).get(dto.getOrderItemNumber()).stream().findFirst();
            if (!orderItemDTOOptional.isPresent()) {
                this.log.error("\u4ea4\u8d27\u8ba1\u5212id:" + dto.getId() + "\u627e\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355\u884c");
            }
            if ("ZY".equals((orderItemDTO = (PurchaseOrderItemExtDTO)orderItemDTOOptional.get()).getBusinessUnit())) continue;
            SupplierMasterDataDTO supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(dto.getToElsAccount());
            PurchaseOrderHeadDTO purchaseOrderHeadDTO = (PurchaseOrderHeadDTO)purchaseOrderHeadMap.get(dto.getOrderNumber());
            PurchaseCrossSourceData purchaseCrossSourceData = new PurchaseCrossSourceData();
            purchaseCrossSourceData.setToElsAccount(dto.getToElsAccount());
            purchaseCrossSourceData.setSupplierCode(supplierMasterDataDTO.getSupplierCode());
            purchaseCrossSourceData.setSupplierName(supplierMasterDataDTO.getSupplierName());
            purchaseCrossSourceData.setCrossSourceNumber("");
            purchaseCrossSourceData.setOrderNumber(orderItemDTO.getOrderNumber());
            purchaseCrossSourceData.setOrderItemNumber(orderItemDTO.getItemNumber());
            purchaseCrossSourceData.setBusinessUnit(orderItemDTO.getBusinessUnit());
            purchaseCrossSourceData.setBusinessEntity(purchaseOrderHeadDTO.getPurchaseOrg());
            purchaseCrossSourceData.setMaterialCategory(orderItemDTO.getMaterialCategory());
            purchaseCrossSourceData.setMaterialMiddleCategory(orderItemDTO.getMaterialMiddleCategory());
            purchaseCrossSourceData.setMaterialSmallCategory(orderItemDTO.getMaterialSmallCategory());
            purchaseCrossSourceData.setMaterialNumber(orderItemDTO.getMaterialNumber());
            purchaseCrossSourceData.setMaterialDesc(orderItemDTO.getMaterialDesc());
            purchaseCrossSourceData.setRequiredQuantity(dto.getPlanDeliveryQuantity());
            purchaseCrossSourceData.setCheckArrivalQuantity(dto.getReceiveQuantity());
            purchaseCrossSourceData.setPerformanceDeduceDate(new Date());
            purchaseCrossSourceData.setElsAccount(SysUtil.getPurchaseAccount());
            BigDecimal difference = purchaseCrossSourceData.getRequiredQuantity().subtract(dto.getQuantity());
            BigDecimal point = difference.divide(dto.getQuantity(), 2, RoundingMode.HALF_UP);
            BigDecimal absoluteResult = point.abs();
            purchaseCrossSourceData.setDeliveryScheduleScore(absoluteResult);
            purchaseCrossSourceData.setCheckArrivalQuantity(dto.getDeliveryQuantity());
            purchaseCrossSourceData.setAnnualArrivalQuantity(dto.getDeliveryQuantity());
            purchaseCrossSourceData.setPerformanceDeduce(absoluteResult.compareTo(new BigDecimal("0.5")) > 0 ? "\u5408\u683c" : "\u4e0d\u5408\u683c");
            result.add(purchaseCrossSourceData);
        }
        this.saveOrUpdateBatch(result);
    }
}

