/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.extend.api.dto.PurchaseOrderDeliveryPlanExtDTO;
import com.els.modules.extend.api.dto.PurchaseOrderItemExtDTO;
import com.els.modules.extend.api.service.PurchaseOrderDeliveryPlanExtRpcService;
import com.els.modules.extend.api.service.PurchaseOrderItemExtRpcService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.service.PurchaseOrderHeadRpcService;
import com.els.modules.report.entity.PurchaseDeliverySourceData;
import com.els.modules.report.mapper.PurchaseDeliverySourceDataMapper;
import com.els.modules.report.service.PurchaseDeliverySourceDataService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseDeliverySourceDataServiceImpl
extends BaseServiceImpl<PurchaseDeliverySourceDataMapper, PurchaseDeliverySourceData>
implements PurchaseDeliverySourceDataService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseOrderItemExtRpcService purchaseOrderItemExtRpcService;
    @Autowired
    private PurchaseOrderDeliveryPlanExtRpcService purchaseOrderDeliveryPlanExtRpcService;
    @Autowired
    private PurchaseOrderHeadRpcService purchaseOrderHeadRpcService;
    @Autowired
    private SupplierMasterDataRpcService supplierMasterDataRpcService;

    @Override
    public void savePurchaseDeliverySourceData(PurchaseDeliverySourceData purchaseDeliverySourceData) {
        if (StringUtils.isEmpty((String)purchaseDeliverySourceData.getDeliverySourceNumber())) {
            purchaseDeliverySourceData.setDeliverySourceNumber(this.invokeBaseRpcService.getNextCode("srmDeliverySourceNumber", (Object)purchaseDeliverySourceData));
        }
        purchaseDeliverySourceData.setDeleted(CommonConstant.DEL_FLAG_0);
        ((PurchaseDeliverySourceDataMapper)this.baseMapper).insert((Object)purchaseDeliverySourceData);
    }

    @Override
    public void updatePurchaseDeliverySourceData(PurchaseDeliverySourceData purchaseDeliverySourceData) {
        ((PurchaseDeliverySourceDataMapper)this.baseMapper).updateById((Object)purchaseDeliverySourceData);
    }

    @Override
    public void delPurchaseDeliverySourceData(String id) {
        ((PurchaseDeliverySourceDataMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseDeliverySourceData(List<String> idList) {
        ((PurchaseDeliverySourceDataMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void getPurchaseDeliverySourceData() {
        PurchaseDeliverySourceData purchaseDeliverySourceData;
        PurchaseOrderHeadDTO purchaseOrderHeadDTO;
        SupplierMasterDataDTO supplierMasterDataDTO;
        PurchaseOrderItemExtDTO orderItemDTO;
        Optional orderItemDTOOptional;
        List purchaseOrderDeliveryPlanDTOList = this.purchaseOrderDeliveryPlanExtRpcService.getPurchaseOrderDeliveryPlanList();
        Set orderNumberSet = purchaseOrderDeliveryPlanDTOList.stream().map(PurchaseOrderDeliveryPlanExtDTO::getOrderNumber).collect(Collectors.toSet());
        ArrayList orderNumberList = new ArrayList(orderNumberSet);
        List purchaseOrderItemDTOList = this.purchaseOrderItemExtRpcService.listPurchaseOrderItemByOrderNumber(orderNumberList);
        Map<String, Map<String, List<PurchaseOrderItemExtDTO>>> purchaseOrderItemDTOMap = purchaseOrderItemDTOList.stream().collect(Collectors.groupingBy(PurchaseOrderItemExtDTO::getOrderNumber, Collectors.groupingBy(PurchaseOrderItemExtDTO::getItemNumber)));
        List purchaseOrderHeadList = this.purchaseOrderHeadRpcService.listPurchaseOrderHeadByOrderNumber(orderNumberList);
        Map purchaseOrderHeadMap = purchaseOrderHeadList.stream().collect(Collectors.toMap(PurchaseOrderHeadDTO::getOrderNumber, Function.identity()));
        Set toElsSet = purchaseOrderDeliveryPlanDTOList.stream().map(PurchaseOrderDeliveryPlanExtDTO::getToElsAccount).collect(Collectors.toSet());
        ArrayList toElsList = new ArrayList(toElsSet);
        List supplierMasterDataDTOList = this.supplierMasterDataRpcService.selectSupplerList(SysUtil.getPurchaseAccount(), toElsList);
        Map supplierMasterDataDTOMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Map<String, List<PurchaseOrderDeliveryPlanExtDTO>> purchaseOrderDeliveryPlanDTOMap = purchaseOrderDeliveryPlanDTOList.stream().collect(Collectors.groupingBy(dto -> simpleDateFormat.format(dto.getRequireDate())));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String yesterday = LocalDate.now().minusDays(1L).format(formatter);
        String dayBeforeYesterday = LocalDate.now().minusDays(2L).format(formatter);
        ArrayList<PurchaseDeliverySourceData> result = new ArrayList<PurchaseDeliverySourceData>();
        for (PurchaseOrderDeliveryPlanExtDTO dto2 : purchaseOrderDeliveryPlanDTOMap.get(yesterday)) {
            orderItemDTOOptional = purchaseOrderItemDTOMap.get(dto2.getOrderNumber()).get(dto2.getOrderItemNumber()).stream().findFirst();
            if (!orderItemDTOOptional.isPresent()) {
                this.log.error("\u4ea4\u8d27\u8ba1\u5212id:" + dto2.getId() + "\u627e\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355\u884c");
            }
            if ("ZY".equals((orderItemDTO = (PurchaseOrderItemExtDTO)orderItemDTOOptional.get()).getBusinessUnit())) continue;
            supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(dto2.getToElsAccount());
            purchaseOrderHeadDTO = (PurchaseOrderHeadDTO)purchaseOrderHeadMap.get(dto2.getOrderNumber());
            purchaseDeliverySourceData = new PurchaseDeliverySourceData();
            purchaseDeliverySourceData.setToElsAccount(dto2.getToElsAccount());
            purchaseDeliverySourceData.setSupplierCode(supplierMasterDataDTO.getSupplierCode());
            purchaseDeliverySourceData.setSupplierName(supplierMasterDataDTO.getSupplierName());
            purchaseDeliverySourceData.setOrderNumber(orderItemDTO.getOrderNumber());
            purchaseDeliverySourceData.setOrderItemNumber(orderItemDTO.getItemNumber());
            purchaseDeliverySourceData.setBusinessUnit(orderItemDTO.getBusinessUnit());
            purchaseDeliverySourceData.setBusinessEntity(purchaseOrderHeadDTO.getPurchaseOrg());
            purchaseDeliverySourceData.setMaterialCategory(orderItemDTO.getMaterialCategory());
            purchaseDeliverySourceData.setMaterialMiddleCategory(orderItemDTO.getMaterialMiddleCategory());
            purchaseDeliverySourceData.setMaterialSmallCategory(orderItemDTO.getMaterialSmallCategory());
            purchaseDeliverySourceData.setMaterialNumber(orderItemDTO.getMaterialNumber());
            purchaseDeliverySourceData.setMaterialDesc(orderItemDTO.getMaterialDesc());
            purchaseDeliverySourceData.setRequireDate(orderItemDTO.getRequireDate());
            purchaseDeliverySourceData.setPerformanceDeduce(dto2.getDeliveryQuantity().compareTo(new BigDecimal("0")) > 1 ? "\u5408\u683c" : "\u4e0d\u5408\u683c");
            purchaseDeliverySourceData.setPerformanceDeduceDate(new Date());
            purchaseDeliverySourceData.setElsAccount(SysUtil.getPurchaseAccount());
            result.add(purchaseDeliverySourceData);
        }
        for (PurchaseOrderDeliveryPlanExtDTO dto2 : purchaseOrderDeliveryPlanDTOMap.get(dayBeforeYesterday)) {
            orderItemDTOOptional = purchaseOrderItemDTOMap.get(dto2.getOrderNumber()).get(dto2.getOrderItemNumber()).stream().findFirst();
            if (!orderItemDTOOptional.isPresent()) {
                this.log.error("\u4ea4\u8d27\u8ba1\u5212id:" + dto2.getId() + "\u627e\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355\u884c");
            }
            if (!"ZY".equals((orderItemDTO = (PurchaseOrderItemExtDTO)orderItemDTOOptional.get()).getBusinessUnit())) continue;
            supplierMasterDataDTO = (SupplierMasterDataDTO)supplierMasterDataDTOMap.get(dto2.getToElsAccount());
            purchaseOrderHeadDTO = (PurchaseOrderHeadDTO)purchaseOrderHeadMap.get(dto2.getOrderNumber());
            purchaseDeliverySourceData = new PurchaseDeliverySourceData();
            purchaseDeliverySourceData.setToElsAccount(dto2.getToElsAccount());
            purchaseDeliverySourceData.setSupplierCode(supplierMasterDataDTO.getSupplierCode());
            purchaseDeliverySourceData.setSupplierName(supplierMasterDataDTO.getSupplierName());
            purchaseDeliverySourceData.setOrderNumber(orderItemDTO.getOrderNumber());
            purchaseDeliverySourceData.setOrderItemNumber(orderItemDTO.getItemNumber());
            purchaseDeliverySourceData.setBusinessUnit(orderItemDTO.getBusinessUnit());
            purchaseDeliverySourceData.setBusinessEntity(purchaseOrderHeadDTO.getPurchaseOrg());
            purchaseDeliverySourceData.setMaterialCategory(orderItemDTO.getMaterialCategory());
            purchaseDeliverySourceData.setMaterialMiddleCategory(orderItemDTO.getMaterialMiddleCategory());
            purchaseDeliverySourceData.setMaterialSmallCategory(orderItemDTO.getMaterialSmallCategory());
            purchaseDeliverySourceData.setMaterialNumber(orderItemDTO.getMaterialNumber());
            purchaseDeliverySourceData.setMaterialDesc(orderItemDTO.getMaterialDesc());
            purchaseDeliverySourceData.setRequireDate(orderItemDTO.getRequireDate());
            purchaseDeliverySourceData.setPerformanceDeduce(dto2.getDeliveryQuantity().compareTo(new BigDecimal("0")) > 0 ? "\u5408\u683c" : "\u4e0d\u5408\u683c");
            purchaseDeliverySourceData.setPerformanceDeduceDate(new Date());
            purchaseDeliverySourceData.setElsAccount(SysUtil.getPurchaseAccount());
            result.add(purchaseDeliverySourceData);
        }
        this.saveOrUpdateBatch(result);
    }
}

