/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.eightReport.entity.PurchaseEightDisciplinesTeam;
import com.els.modules.eightReport.entity.PurchaseEightDisciplinesZero;
import com.els.modules.eightReport.enumerate.EightReportStatusEnum;
import com.els.modules.eightReport.mapper.PurchaseEightDisciplinesZeroMapper;
import com.els.modules.eightReport.rpc.service.InvokeMainDataRpcService;
import com.els.modules.eightReport.service.PurchaseEightDisciplinesTeamService;
import com.els.modules.eightReport.service.PurchaseEightDisciplinesZeroService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportItem;
import com.els.modules.quality.enumerate.SupplierRectificationPublishStatusEnum;
import com.els.modules.quality.enumerate.SupplierRectificationSourceTypeEnum;
import com.els.modules.quality.enumerate.SupplierRectificationStatusEnum;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportItemMapper;
import com.els.modules.siteInspection.constants.SiteInspectionConstant;
import com.els.modules.siteInspection.entity.PurchaseInspectionHead;
import com.els.modules.siteInspection.entity.PurchaseInspectionItem;
import com.els.modules.siteInspection.entity.PurchaseInspectionPlan;
import com.els.modules.siteInspection.entity.PurchaseInspectionScoreGroup;
import com.els.modules.siteInspection.entity.SaleInspectionHead;
import com.els.modules.siteInspection.entity.SaleInspectionItem;
import com.els.modules.siteInspection.entity.SaleInspectionPlan;
import com.els.modules.siteInspection.entity.SaleInspectionScoreGroup;
import com.els.modules.siteInspection.enums.I18nSiteInspectEnum;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardItemDetailMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardItemMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardScoreGradeMapper;
import com.els.modules.siteInspection.mapper.PurchaseInspectionHeadMapper;
import com.els.modules.siteInspection.mapper.PurchaseInspectionItemMapper;
import com.els.modules.siteInspection.mapper.PurchaseInspectionPlanMapper;
import com.els.modules.siteInspection.mapper.PurchaseInspectionScoreGroupMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionHeadMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionItemMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionPlanMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionScoreGroupMapper;
import com.els.modules.siteInspection.rpc.SiteInspectBaseRpcService;
import com.els.modules.siteInspection.service.PurchaseInspectionHeadService;
import com.els.modules.siteInspection.service.PurchaseInspectionItemService;
import com.els.modules.siteInspection.service.PurchaseInspectionPlanService;
import com.els.modules.siteInspection.service.PurchaseInspectionSocreGroupService;
import com.els.modules.siteInspection.service.SaleInspectionItemService;
import com.els.modules.siteInspection.service.SaleInspectionPlanService;
import com.els.modules.siteInspection.service.SaleInspectionSocreGroupService;
import com.els.modules.siteInspection.service.impl.ElsInspectionPlanHeadServiceImpl;
import com.els.modules.siteInspection.utils.BigDecimalUtil;
import com.els.modules.siteInspection.vo.EightReportVo;
import com.els.modules.siteInspection.vo.GetItemsReqVo;
import com.els.modules.siteInspection.vo.InspectionPlanReqSaveVo;
import com.els.modules.siteInspection.vo.InspectionPlanReqSubmitVo;
import com.els.modules.siteInspection.vo.InspectionScoreResVo;
import com.els.modules.siteInspection.vo.PurInspectionScoreReqVo;
import com.els.modules.siteInspection.vo.PurchaseInspectionHeadSaveVO;
import com.els.modules.siteInspection.vo.PurchaseInspectionHeadSubmitVO;
import com.els.modules.siteInspection.vo.SaleRectificationVO;
import com.els.modules.siteInspection.vo.ScoreGroupVo;
import com.els.modules.siteInspection.vo.ScoreItemVo;
import com.els.modules.siteInspection.vo.inspectionSheet.PurInspectionItemScoreVo;
import com.els.modules.siteInspection.vo.inspectionSheet.PurchaseInspectionItemVo;
import com.els.modules.siteInspection.vo.inspectionSheet.PurchaseInspectionPlanVo;
import com.els.modules.siteInspection.vo.inspectionSheet.PurchaseInspectionScoreGroupVo;
import com.els.rpc.service.InvokeAccountRpcService;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseInspectionHeadServiceImpl
extends BaseServiceImpl<PurchaseInspectionHeadMapper, PurchaseInspectionHead>
implements PurchaseInspectionHeadService {
    private static final int BATCH_SIZE = 2000;
    @Resource
    private PurchaseInspectionItemMapper itemMapper;
    @Resource
    private PurchaseInspectionScoreGroupMapper scoreGroupMapper;
    @Resource
    private PurchaseInspectionPlanMapper planMapper;
    @Autowired
    private PurchaseInspectionItemService itemService;
    @Autowired
    private PurchaseInspectionSocreGroupService socreGroupService;
    @Autowired
    private PurchaseInspectionPlanService planService;
    @Resource
    private SaleInspectionHeadMapper sHeadMapper;
    @Resource
    private SaleInspectionItemMapper sItemMapper;
    @Resource
    private SaleInspectionScoreGroupMapper sScoreGroupMapper;
    @Resource
    private SaleInspectionPlanMapper sPlanMapper;
    @Autowired
    private SaleInspectionItemService sItemService;
    @Autowired
    private SaleInspectionSocreGroupService sScoreGroupService;
    @Autowired
    private SaleInspectionPlanService sPlanService;
    @Resource
    private ElsInspectionStandardItemMapper standardItemMapper;
    @Resource
    private ElsInspectionStandardScoreGradeMapper scoreGradeMapper;
    @Resource
    private PurchaseEightDisciplinesTeamService teamService;
    @Resource
    private ElsInspectionStandardItemDetailMapper itemDetailMapper;
    @Resource
    private PurchaseEightDisciplinesZeroMapper eightD0Mapper;
    @Autowired
    private SiteInspectBaseRpcService baseRpcService;
    @Autowired
    private PurchaseEightDisciplinesZeroService eight0Service;
    @Autowired
    private InvokeAccountRpcService accountRpcService;
    @Autowired
    private PurchaseSupplierRectificationReportHeadMapper sReportHeadMapper;
    @Autowired
    private InvokeMainDataRpcService invokeMainDataRpcService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseSupplierRectificationReportItemMapper supplierRectificationReportItemMapper;

    private String getSerialNumber(Object businessObj) {
        return this.baseRpcService.getNextCode("siteInspectionNumber", businessObj);
    }

    private String getElsSubAccount() {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        return sysUser.getSubAccount();
    }

    private void delByHeadId(String headId) {
        if (StringUtils.isBlank((CharSequence)headId)) {
            return;
        }
        this.itemMapper.deleteByMainId(headId);
        this.scoreGroupMapper.deleteByMainId(headId);
        this.planMapper.deleteByMainId(headId);
    }

    private void setBaseEntity(BaseEntity baseEntity) {
        Date now = new Date();
        LoginUser sysUser = SysUtil.getLoginUser();
        baseEntity.setElsAccount(TenantContext.getTenant()).setCreateTime(now).setUpdateTime(now).setCreateBy(sysUser.getSubAccount()).setUpdateBy(sysUser.getSubAccount()).setDeleted(CommonConstant.DEL_FLAG_0);
    }

    private void saveInspectionItem(PurchaseInspectionHead inspectionHead, String standardName, String versionNumber, List<PurchaseInspectionItemVo> inspectionItemList, String inspectionStep) {
        if (CollectionUtils.isEmpty(inspectionItemList)) {
            return;
        }
        List<PurchaseInspectionItem> itemList = this.standardItemMapper.getItems(standardName, versionNumber, TenantContext.getTenant());
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.forEach(item -> inspectionItemList.forEach(itemVo -> {
            if (item.getInspectionStandardItemId().equals(itemVo.getInspectionStandardItemId())) {
                item.setRemark(itemVo.getRemark());
            }
            item.setHeadId(inspectionHead.getId());
            if ("3".equals(inspectionStep) && item.getInspectionStandardItemId().equals(itemVo.getInspectionStandardItemId())) {
                item.setInspectScore(itemVo.getInspectScore());
                item.setInspectResult(itemVo.getInspectResult());
            }
            SysUtil.setSysParam((BaseEntity)item, (BaseEntity)inspectionHead);
        }));
        this.itemService.saveBatch(itemList, 2000);
    }

    private void saveScoreGroup(PurchaseInspectionHead inspectionHead, List<PurchaseInspectionScoreGroupVo> scoreGroupList) {
        if (CollectionUtils.isEmpty(scoreGroupList)) {
            return;
        }
        List inspectionScoreGroups = scoreGroupList.stream().map(vo -> {
            PurchaseInspectionScoreGroup inspectionScoreGroup = new PurchaseInspectionScoreGroup();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)inspectionScoreGroup));
            inspectionScoreGroup.setHeadId(inspectionHead.getId());
            SysUtil.setSysParam((BaseEntity)inspectionScoreGroup, (BaseEntity)inspectionHead);
            return inspectionScoreGroup;
        }).collect(Collectors.toList());
        this.socreGroupService.saveBatch(inspectionScoreGroups, 2000);
    }

    private void saveInspectionPlan(PurchaseInspectionHead inspectionHead, List<PurchaseInspectionPlanVo> inspectionPlanList) {
        if (CollectionUtils.isEmpty(inspectionPlanList)) {
            return;
        }
        List plans = inspectionPlanList.stream().map(vo -> {
            PurchaseInspectionPlan plan = new PurchaseInspectionPlan();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)plan));
            plan.setHeadId(inspectionHead.getId());
            SysUtil.setSysParam((BaseEntity)plan, (BaseEntity)inspectionHead);
            return plan;
        }).collect(Collectors.toList());
        this.planService.saveBatch(plans, 2000);
    }

    private void pushToSaleHead(PurchaseInspectionHead pHead) {
        if (pHead.getInspectionStep().equals("2") || pHead.getInspectionStep().equals("3")) {
            return;
        }
        SaleInspectionHead saleInspectionHead = new SaleInspectionHead();
        BeanUtils.copyProperties((Object)((Object)pHead), (Object)((Object)saleInspectionHead));
        saleInspectionHead.setBusAccount(TenantContext.getTenant()).setDocumentsStatus("1").setRelationId(pHead.getId()).setElsAccount(pHead.getToElsAccount()).setId(IdWorker.getIdStr());
        this.sHeadMapper.insert((Object)saleInspectionHead);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)saleInspectionHead)));
        String elsAccount = pHead.getElsAccount();
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = this.invokeAccountRpcService.getByElsAccount(elsAccount);
        if (ObjectUtil.isNotEmpty((Object)elsEnterpriseInfoDTO)) {
            jsonObject.put("purchaseName", (Object)elsEnterpriseInfoDTO.getName());
        } else {
            LoginUser loginUser = SysUtil.getLoginUser();
            if (ObjectUtil.isNotEmpty((Object)loginUser)) {
                jsonObject.put("purchaseName", (Object)loginUser.getEnterpriseName());
            }
        }
        this.sendMsg(TenantContext.getTenant(), pHead.getToElsAccount(), jsonObject, "", "siteInspection", "publish");
        pHead.setDocumentsStatus("1").setRelationId(saleInspectionHead.getId());
    }

    private void validScoreAccountRepeat(List<PurchaseInspectionScoreGroup> scoreGroupList) {
        if (CollectionUtils.isEmpty(scoreGroupList)) {
            return;
        }
        Map<String, Long> mapGroup = scoreGroupList.stream().collect(Collectors.groupingBy(PurchaseInspectionScoreGroup::getElsSubAccount, Collectors.counting()));
        for (Map.Entry<String, Long> map : mapGroup.entrySet()) {
            AssertI18nUtil.isTrue((map.getValue() > 1L ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.SCORE_GRADE_ACCOUNT_REPEAT, (String[])new String[]{map.getKey()});
        }
    }

    private void validScoreGroup(String name, String versionNumber, List<PurchaseInspectionScoreGroup> scoreGroupList) {
        if (CollectionUtils.isEmpty(scoreGroupList)) {
            return;
        }
        List<String> itemClassifys = this.standardItemMapper.getClassifys(name, versionNumber, TenantContext.getTenant());
        if (CollectionUtils.isEmpty(itemClassifys)) {
            return;
        }
        List scoreClassifys = scoreGroupList.stream().map(PurchaseInspectionScoreGroup::getInspectionClassify).collect(Collectors.toList());
        for (String itemClassify : itemClassifys) {
            int count = 0;
            for (String inspectionClassify : scoreClassifys) {
                List<String> classifys = Arrays.asList(inspectionClassify.split(","));
                count += classifys.contains(itemClassify) ? 1 : 0;
                AssertI18nUtil.isTrue((!itemClassifys.containsAll(classifys) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.SCORE_GROUP_NO_CLASSIFY);
            }
            AssertI18nUtil.isTrue((count > 1 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.CLASSIFY_MANY_SCORE_GROUP);
            AssertI18nUtil.isTrue((count <= 0 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.CLASSIFY_NO_SCORE_GROUP);
        }
    }

    private void submitInspectionItem(String name, String versionNumber, String headId, String relationId, String saleAccount, List<PurchaseInspectionItemVo> pItemVoList) {
        List<PurchaseInspectionItem> itemList = this.standardItemMapper.getItems(name, versionNumber, TenantContext.getTenant());
        AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(itemList), (Enum)I18nSiteInspectEnum.INSPECT_ITEM_IS_EMPTY);
        ArrayList<SaleInspectionItem> sItemList = new ArrayList<SaleInspectionItem>();
        for (PurchaseInspectionItem pItem : itemList) {
            pItemVoList.forEach(itemVo -> {
                if (pItem.getInspectionStandardItemId().equals(itemVo.getInspectionStandardItemId())) {
                    pItem.setRemark(itemVo.getRemark());
                }
            });
            pItem.setHeadId(headId).setRelationId(relationId).setBusAccount(TenantContext.getTenant()).setId(IdWorker.getIdStr());
            this.setBaseEntity(pItem);
            if (StringUtils.isBlank((CharSequence)relationId)) continue;
            SaleInspectionItem sItem = new SaleInspectionItem();
            BeanUtils.copyProperties((Object)((Object)pItem), (Object)((Object)sItem));
            sItem.setHeadId(relationId).setRelationId(headId).setSourceId(pItem.getId()).setBusAccount(TenantContext.getTenant()).setElsAccount(saleAccount).setId(IdWorker.getIdStr());
            sItemList.add(sItem);
            pItem.setToSaleId(sItem.getId());
        }
        this.itemService.saveBatch(itemList, 2000);
        if (!CollectionUtils.isEmpty(sItemList)) {
            this.sItemService.saveBatch(sItemList, 2000);
        }
    }

    private void submitScoreGroup(String headId, String relationId, String saleAccount, List<PurchaseInspectionScoreGroup> pScoreGroupList) {
        if (CollectionUtils.isEmpty(pScoreGroupList)) {
            return;
        }
        ArrayList<SaleInspectionScoreGroup> sScoreGroupList = new ArrayList<SaleInspectionScoreGroup>();
        for (PurchaseInspectionScoreGroup pScoreGroup : pScoreGroupList) {
            pScoreGroup.setHeadId(headId).setScoreType("0").setRelationId(relationId).setBusAccount(TenantContext.getTenant()).setId(IdWorker.getIdStr());
            this.setBaseEntity(pScoreGroup);
            if (StringUtils.isBlank((CharSequence)relationId)) continue;
            SaleInspectionScoreGroup sScoreGroup = new SaleInspectionScoreGroup();
            BeanUtils.copyProperties((Object)((Object)pScoreGroup), (Object)((Object)sScoreGroup));
            sScoreGroup.setHeadId(relationId).setRelationId(headId).setSourceId(pScoreGroup.getId()).setBusAccount(TenantContext.getTenant()).setElsAccount(saleAccount).setId(IdWorker.getIdStr());
            pScoreGroup.setToSaleId(sScoreGroup.getId());
            sScoreGroupList.add(sScoreGroup);
        }
        this.socreGroupService.saveBatch(pScoreGroupList, 2000);
        if (!CollectionUtils.isEmpty(sScoreGroupList)) {
            this.sScoreGroupService.saveBatch(sScoreGroupList, 2000);
        }
    }

    private void submitInspectionPlan(String headId, String relationId, String saleAccount, List<PurchaseInspectionPlan> pPlanList) {
        ArrayList<SaleInspectionPlan> sPlanList = new ArrayList<SaleInspectionPlan>();
        for (PurchaseInspectionPlan pPlan : pPlanList) {
            pPlan.setHeadId(headId).setRelationId(relationId).setBusAccount(TenantContext.getTenant()).setId(IdWorker.getIdStr());
            this.setBaseEntity(pPlan);
            if (StringUtils.isBlank((CharSequence)relationId)) continue;
            SaleInspectionPlan sPlan = new SaleInspectionPlan();
            BeanUtils.copyProperties((Object)((Object)pPlan), (Object)((Object)sPlan));
            sPlan.setHeadId(relationId).setRelationId(headId).setSourceId(pPlan.getId()).setBusAccount(TenantContext.getTenant()).setElsAccount(saleAccount).setId(IdWorker.getIdStr());
            pPlan.setToSaleId(sPlan.getId());
            sPlanList.add(sPlan);
        }
        this.planService.saveBatch(pPlanList, 2000);
        if (!CollectionUtils.isEmpty(sPlanList)) {
            this.sPlanService.saveBatch(sPlanList, 2000);
        }
    }

    private void sendFile(String purchaseHeadId, String saleHeadId, String elsAccount, String toElsAccount) {
        if (StringUtils.isBlank((CharSequence)saleHeadId)) {
            return;
        }
        AttachmentSendDTO attachmentSendVO = new AttachmentSendDTO();
        attachmentSendVO.setHeadId(purchaseHeadId);
        attachmentSendVO.setElsAccount(elsAccount);
        HashMap toSend = Maps.newHashMap();
        toSend.put(saleHeadId, toElsAccount);
        attachmentSendVO.setToSend((Map)toSend);
        this.baseRpcService.sendPurchaseFile(attachmentSendVO);
    }

    private void submitRow(PurchaseInspectionHeadSubmitVO submitVO) {
        this.submitInspectionItem(submitVO.getInspectionStandardName(), submitVO.getInspectionStandardVersion(), submitVO.getId(), submitVO.getRelationId(), submitVO.getToElsAccount(), submitVO.getInspectionItemList());
        this.submitScoreGroup(submitVO.getId(), submitVO.getRelationId(), submitVO.getToElsAccount(), submitVO.getScoreGroupList());
        this.submitInspectionPlan(submitVO.getId(), submitVO.getRelationId(), submitVO.getToElsAccount(), submitVO.getInspectionPlanList());
        this.sendFile(submitVO.getId(), submitVO.getRelationId(), TenantContext.getTenant(), submitVO.getToElsAccount());
    }

    private int getDecimalPlace(String fullMark) {
        return fullMark.contains(".") ? fullMark.split("\\.")[1].length() : 2;
    }

    private void saveScoreItem(String classify, PurchaseInspectionHeadSaveVO reqVo) {
        this.itemMapper.getSelfScoreItem(reqVo.getId(), classify).forEach(itemVo -> {
            reqVo.getInspectionItemList().forEach(reqItem -> {
                if (!itemVo.getId().equals(reqItem.getId())) {
                    return;
                }
                itemVo.setInspectScore(reqItem.getInspectScore()).setInspectResult(reqItem.getInspectResult());
            });
            this.itemMapper.updateById(itemVo);
        });
    }

    private void submitScoreItem(String classify, PurInspectionScoreReqVo reqVo) {
        this.itemMapper.getSelfScoreItem(reqVo.getId(), classify).forEach(itemVo -> {
            reqVo.getInspectionItemList().forEach(reqItem -> {
                if (!itemVo.getId().equals(reqItem.getId())) {
                    return;
                }
                AssertI18nUtil.isTrue((boolean)BigDecimalUtil.bigThan(reqItem.getInspectScore(), itemVo.getFullMark()), (Enum)I18nSiteInspectEnum.SCORE_BIG_FULL_MARK);
                itemVo.setInspectScore(reqItem.getInspectScore()).setInspectResult(reqItem.getInspectResult());
            });
            this.itemMapper.updateById(itemVo);
            if (StringUtils.isBlank((CharSequence)itemVo.getToSaleId())) {
                return;
            }
            SaleInspectionItem saleInspectionItem = new SaleInspectionItem();
            saleInspectionItem.setInspectScore(itemVo.getInspectScore()).setInspectResult(itemVo.getInspectResult()).setId(itemVo.getToSaleId());
            this.sItemMapper.updateById((Object)saleInspectionItem);
        });
    }

    private void updateScoreType(String classify, String id, String relationId) {
        Integer countSelfNoScore = this.itemMapper.countSelfNoScore(id, classify);
        Integer countSelfTotalScore = this.itemMapper.countSelfTotalScore(id, classify);
        String scoreType = "0";
        if (countSelfTotalScore.equals(countSelfNoScore)) {
            scoreType = "0";
        } else if (countSelfNoScore == 0 && countSelfTotalScore > 0) {
            scoreType = "2";
        } else if (countSelfNoScore > 0 && countSelfTotalScore > countSelfNoScore) {
            scoreType = "1";
        }
        this.scoreGroupMapper.updateScoreType(id, this.getElsSubAccount(), scoreType);
        this.sScoreGroupMapper.updateScoreType(relationId, this.getElsSubAccount(), scoreType);
    }

    private void updatePartScore(PurchaseInspectionHead head) {
        if (this.itemMapper.countScoreItem(head.getId()) <= 0) {
            return;
        }
        head.setDocumentsStatus("3").setResultAuditStatus(this.getAudiStatus(head.getPubishAudit()));
        ((PurchaseInspectionHeadMapper)this.baseMapper).updateById((Object)head);
        SaleInspectionHead saleInspectionHead = new SaleInspectionHead();
        saleInspectionHead.setDocumentsStatus("3").setResultAuditStatus(head.getResultAuditStatus()).setId(head.getRelationId());
        this.updateSHeadInspectionConclusionOrAbarbeitungLimitTime(head, saleInspectionHead);
        this.sHeadMapper.updateById((Object)saleInspectionHead);
    }

    private void updateScoreFinish(PurchaseInspectionHead head, String unnecessaryItemsIsNeedToScored) {
        String status;
        List<ScoreItemVo> selectScoreItemVos = "0".equals(unnecessaryItemsIsNeedToScored) ? this.itemMapper.getNecessaryItem(head.getId()) : this.itemMapper.getAllScoreItem(head.getId());
        if (selectScoreItemVos.size() == 0) {
            return;
        }
        List scoreItemVos = selectScoreItemVos.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getScore())).collect(Collectors.toList());
        if (scoreItemVos.size() == 0) {
            return;
        }
        int decimalPlace = this.getDecimalPlace(((ScoreItemVo)scoreItemVos.get(0)).getFullMark());
        BigDecimal sumSocre = BigDecimalUtil.getZero();
        Map<String, BigDecimal> mapGroup = scoreItemVos.parallelStream().collect(Collectors.groupingBy(ScoreItemVo::getInspectionItemClassify, Collectors.collectingAndThen(Collectors.toList(), m -> {
            BigDecimal sumResult = m.parallelStream().map(i -> new BigDecimal(i.getFullMark())).reduce(BigDecimal.ZERO, BigDecimal::add);
            return m.parallelStream().map(i -> BigDecimalUtil.multiplyWeight(i.getScore(), i.getWeight())).reduce(BigDecimal.ZERO, BigDecimal::add).multiply(new BigDecimal(head.getStandardFullMarks())).divide(sumResult, decimalPlace, 4);
        })));
        for (Map.Entry<String, BigDecimal> entry : mapGroup.entrySet()) {
            sumSocre = sumSocre.add(entry.getValue());
        }
        ScoreGroupVo scoreGroupVo = this.scoreGradeMapper.getScoreGroupByScore(head.getInspectionStandardName(), head.getInspectionStandardVersion(), sumSocre, TenantContext.getTenant());
        String string = "1".equals(head.getPubishAudit()) ? "4" : (status = "2".equals(scoreGroupVo.getInspectionConclusion()) ? "5" : "6");
        if (StringUtils.isBlank((CharSequence)head.getInspectionConclusion())) {
            head.setInspectionConclusion(scoreGroupVo.getInspectionConclusion());
            if (!"1".equals(head.getPubishAudit())) {
                status = SiteInspectionConstant.getInspectStatusByConclusion(head.getInspectionConclusion());
            }
        }
        head.setInspectScore(sumSocre.toString()).setScoreGrade(scoreGroupVo.getScoreGrade()).setDocumentsStatus(status).setResultAuditStatus(this.getAudiStatus(head.getPubishAudit()));
        ((PurchaseInspectionHeadMapper)this.baseMapper).updateById((Object)head);
        if ("6".equals(head.getDocumentsStatus())) {
            ElsInspectionPlanHeadServiceImpl planHeadService = (ElsInspectionPlanHeadServiceImpl)SpringContextUtils.getBean(ElsInspectionPlanHeadServiceImpl.class);
            planHeadService.caseClosedWriteBackPlanItem(head);
        }
        if (StringUtils.isBlank((CharSequence)head.getRelationId())) {
            return;
        }
        SaleInspectionHead saleInspectionHead = new SaleInspectionHead();
        saleInspectionHead.setInspectScore(sumSocre.toString()).setScoreGrade(scoreGroupVo.getScoreGrade()).setInspectionConclusion(scoreGroupVo.getInspectionConclusion()).setDocumentsStatus(status).setResultAuditStatus(head.getResultAuditStatus()).setId(head.getRelationId());
        this.updateSHeadInspectionConclusionOrAbarbeitungLimitTime(head, saleInspectionHead);
        this.sHeadMapper.updateById((Object)saleInspectionHead);
    }

    private String getAudiStatus(String pubishAudit) {
        return "1".equals(pubishAudit) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createNewRecord(PurchaseInspectionHeadSaveVO headSaveVO) {
        this.generate(headSaveVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PurchaseInspectionHeadSaveVO generate(PurchaseInspectionHeadSaveVO headSaveVO) {
        PurchaseInspectionHead inspectionHead = new PurchaseInspectionHead();
        BeanUtils.copyProperties((Object)((Object)headSaveVO), (Object)((Object)inspectionHead));
        inspectionHead.setDocumentsSerialNumber(this.getSerialNumber((Object)headSaveVO)).setDocumentsStatus("0").setResultAuditStatus(this.getAudiStatus(inspectionHead.getPubishAudit())).setBusAccount(TenantContext.getTenant()).setDataVersion(0).setId(IdWorker.getIdStr());
        headSaveVO.setId(inspectionHead.getId());
        headSaveVO.setDocumentsSerialNumber(inspectionHead.getDocumentsSerialNumber());
        ((PurchaseInspectionHeadMapper)this.baseMapper).insert((Object)inspectionHead);
        this.saveInspectionItem(inspectionHead, headSaveVO.getInspectionStandardName(), headSaveVO.getInspectionStandardVersion(), headSaveVO.getInspectionItemList(), headSaveVO.getInspectionStep());
        this.saveScoreGroup(inspectionHead, headSaveVO.getScoreGroupList());
        this.saveInspectionPlan(inspectionHead, headSaveVO.getInspectionPlanList());
        return headSaveVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRecord(PurchaseInspectionHeadSaveVO headSaveVO) {
        int countNum = ((PurchaseInspectionHeadMapper)this.baseMapper).countByIAndStatus(headSaveVO.getId(), "0");
        AssertI18nUtil.isTrue((countNum <= 0 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.P_INSPECT_NULL_NOT_NEW);
        PurchaseInspectionHead inspectionHead = new PurchaseInspectionHead();
        BeanUtils.copyProperties((Object)((Object)headSaveVO), (Object)((Object)inspectionHead));
        inspectionHead.setResultAuditStatus(this.getAudiStatus(inspectionHead.getPubishAudit()));
        int count = ((PurchaseInspectionHeadMapper)this.baseMapper).updateById((Object)inspectionHead);
        AssertI18nUtil.isTrue((count == 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
        this.delByHeadId(headSaveVO.getId());
        this.saveInspectionItem(inspectionHead, headSaveVO.getInspectionStandardName(), headSaveVO.getInspectionStandardVersion(), headSaveVO.getInspectionItemList(), headSaveVO.getInspectionStep());
        this.saveScoreGroup(inspectionHead, headSaveVO.getScoreGroupList());
        this.saveInspectionPlan(inspectionHead, headSaveVO.getInspectionPlanList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitRecordNoId(PurchaseInspectionHeadSubmitVO submitVO) {
        this.submitValid(submitVO);
        this.validScoreAccountRepeat(submitVO.getScoreGroupList());
        this.validScoreGroup(submitVO.getInspectionStandardName(), submitVO.getInspectionStandardVersion(), submitVO.getScoreGroupList());
        submitVO.setDocumentsSerialNumber(this.getSerialNumber((Object)submitVO)).setDocumentsStatus("2").setResultAuditStatus(this.getAudiStatus(submitVO.getPubishAudit())).setBusAccount(TenantContext.getTenant()).setSelfAssessmentScore(null).setInspectScore(null).setScoreGrade(null).setInspectionConclusion(null).setDataVersion(0).setId(IdWorker.getIdStr());
        this.pushToSaleHead(submitVO);
        ((PurchaseInspectionHeadMapper)this.baseMapper).insert((Object)submitVO);
        this.submitRow(submitVO);
        this.executeItemScore(submitVO);
    }

    private void executeItemScore(PurchaseInspectionHeadSubmitVO submitVO) {
        if (!"3".equals(submitVO.getInspectionStep())) {
            return;
        }
        PurInspectionScoreReqVo reqVo = new PurInspectionScoreReqVo();
        reqVo.setId(submitVO.getId());
        List<PurInspectionItemScoreVo> inspectionItemScoreList = submitVO.getInspectionItemList().stream().map(pInspectionItemVo -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"head_id", (Object)submitVO.getId());
            queryWrapper.eq((Object)"inspection_standard_item_id", (Object)pInspectionItemVo.getInspectionStandardItemId());
            PurchaseInspectionItem item = (PurchaseInspectionItem)((Object)((Object)this.itemService.getOne((Wrapper)queryWrapper)));
            PurInspectionItemScoreVo purInspectionItemScoreVo = new PurInspectionItemScoreVo();
            purInspectionItemScoreVo.setInspectScore(pInspectionItemVo.getInspectScore());
            purInspectionItemScoreVo.setInspectResult(pInspectionItemVo.getInspectResult());
            purInspectionItemScoreVo.setId(item.getId());
            return purInspectionItemScoreVo;
        }).collect(Collectors.toList());
        reqVo.setInspectionItemList(inspectionItemScoreList);
        reqVo.setUnnecessaryItemsIsNeedToScored(submitVO.getUnnecessaryItemsIsNeedToScored());
        this.submitItemScore(reqVo);
    }

    private void submitValid(PurchaseInspectionHeadSubmitVO submitVO) {
        AssertI18nUtil.isTrue((!submitVO.getInspectionStep().equals("2") && StringUtils.isBlank((CharSequence)submitVO.getCompany()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.COMPANY_CODE_NOT_NULL);
        AssertI18nUtil.isTrue((!submitVO.getInspectionStep().equals("2") && StringUtils.isBlank((CharSequence)submitVO.getPurchaseOrg()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.ORG_CODE_NOT_NULL);
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)submitVO.getToElsAccount()), (Enum)I18nSiteInspectEnum.SALE_ACCOUNT_IS_NULL);
        AssertI18nUtil.isTrue((!submitVO.getInspectionStep().equals("1") && CollectionUtils.isEmpty(submitVO.getScoreGroupList()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.SCORE_GRADE_ITEM_NOT_EMPTY);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitRecordWithId(PurchaseInspectionHeadSubmitVO submitVO) {
        this.submitValid(submitVO);
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)submitVO.getId()), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        int countNum = ((PurchaseInspectionHeadMapper)this.baseMapper).countByIAndStatus(submitVO.getId(), "0");
        AssertI18nUtil.isTrue((countNum <= 0 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.P_INSPECT_NULL_NOT_NEW);
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)submitVO.getToElsAccount()), (Enum)I18nSiteInspectEnum.SALE_ACCOUNT_IS_NULL);
        AssertI18nUtil.isTrue((!submitVO.getInspectionStep().equals("1") && CollectionUtils.isEmpty(submitVO.getScoreGroupList()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.SCORE_GRADE_ITEM_NOT_EMPTY);
        this.validScoreAccountRepeat(submitVO.getScoreGroupList());
        this.validScoreGroup(submitVO.getInspectionStandardName(), submitVO.getInspectionStandardVersion(), submitVO.getScoreGroupList());
        this.delByHeadId(submitVO.getId());
        submitVO.setDocumentsStatus("2").setResultAuditStatus(this.getAudiStatus(submitVO.getPubishAudit())).setSelfAssessmentScore(null).setInspectScore(null).setScoreGrade(null).setInspectionConclusion(null).setBusAccount(TenantContext.getTenant());
        this.pushToSaleHead(submitVO);
        int count = ((PurchaseInspectionHeadMapper)this.baseMapper).updateById((Object)submitVO);
        AssertI18nUtil.isTrue((count == 0 ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECODE_LOSE_EFFICACY);
        this.submitRow(submitVO);
        this.executeItemScore(submitVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveItemScore(PurchaseInspectionHeadSaveVO reqVo) {
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)((PurchaseInspectionHeadMapper)this.baseMapper).selectById((Serializable)((Object)reqVo.getId())));
        if (reqVo != null && reqVo.getAbarbeitungLimitTime() != null) {
            head.setAbarbeitungLimitTime(reqVo.getAbarbeitungLimitTime());
        }
        if (reqVo != null && reqVo.getInspectionConclusion() != null) {
            head.setInspectionConclusion(reqVo.getInspectionConclusion());
        }
        AssertI18nUtil.isTrue((!"2".equals(head.getDocumentsStatus()) && !"3".equals(head.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.NOT_SCORE_IN_STATUS);
        String classify = this.scoreGroupMapper.getInspectionClassify(reqVo.getId(), this.getElsSubAccount());
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)classify), (Enum)I18nSiteInspectEnum.ACCOUNT_CAN_NOT_SCORE);
        this.saveScoreItem(classify, reqVo);
        this.updatePlanItems(reqVo);
        head.setResultAuditStatus(this.getAudiStatus(head.getPubishAudit()));
        ((PurchaseInspectionHeadMapper)this.baseMapper).updateById((Object)head);
    }

    private void updatePlanItems(PurchaseInspectionHeadSaveVO reqVo) {
        if (reqVo != null && reqVo.getInspectionPlanList() != null && reqVo.getInspectionPlanList().size() > 0) {
            List<PurchaseInspectionPlanVo> inspectionPlanList = reqVo.getInspectionPlanList();
            for (PurchaseInspectionPlanVo planVo : inspectionPlanList) {
                SaleInspectionPlan saleInspectionPlan;
                PurchaseInspectionPlan plan;
                if (planVo == null || !StringUtils.isNotBlank((CharSequence)planVo.getId()) || (plan = (PurchaseInspectionPlan)((Object)this.planMapper.selectById((Serializable)((Object)planVo.getId())))) == null) continue;
                plan.setActualFinishTime(planVo.getActualFinishTime());
                plan.setPlanTailAfter(planVo.getPlanTailAfter());
                plan.setUpdateTime(new Date());
                this.planMapper.updateById((Object)plan);
                if (!StringUtils.isNotBlank((CharSequence)plan.getToSaleId()) || (saleInspectionPlan = (SaleInspectionPlan)((Object)this.sPlanMapper.selectById((Serializable)((Object)plan.getToSaleId())))) == null || !StringUtils.isNotBlank((CharSequence)saleInspectionPlan.getId())) continue;
                saleInspectionPlan.setActualFinishTime(planVo.getActualFinishTime());
                saleInspectionPlan.setPlanTailAfter(planVo.getPlanTailAfter());
                saleInspectionPlan.setUpdateTime(new Date());
                this.sPlanMapper.updateById((Object)saleInspectionPlan);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PurchaseInspectionHead submitItemScore(PurInspectionScoreReqVo reqVo) {
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)((PurchaseInspectionHeadMapper)this.baseMapper).selectById((Serializable)((Object)reqVo.getId())));
        AssertI18nUtil.isTrue((!"2".equals(head.getDocumentsStatus()) && !"3".equals(head.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.NOT_SCORE_IN_STATUS);
        this.updateHeadInspectionConclusionOrAbarbeitungLimitTime(reqVo, head);
        String classify = this.scoreGroupMapper.getInspectionClassify(reqVo.getId(), this.getElsSubAccount());
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)classify), (Enum)I18nSiteInspectEnum.ACCOUNT_CAN_NOT_SCORE);
        this.submitScoreItem(classify, reqVo);
        this.updateScoreType(classify, head.getId(), head.getRelationId());
        int noScoreItemCount = this.itemMapper.countNoScoreItem(head.getId());
        if (StringUtils.isNotBlank((CharSequence)reqVo.getUnnecessaryItemsIsNeedToScored())) {
            if ("1".equals(reqVo.getUnnecessaryItemsIsNeedToScored())) {
                this.updatePartScore(head);
            } else if (noScoreItemCount > 0) {
                this.updatePartScore(head);
            } else {
                this.updateScoreFinish(head, "1");
            }
        } else if (noScoreItemCount > 0) {
            this.updatePartScore(head);
        } else {
            this.updateScoreFinish(head, "1");
        }
        return head;
    }

    private void updateHeadInspectionConclusionOrAbarbeitungLimitTime(PurInspectionScoreReqVo reqVo, PurchaseInspectionHead head) {
        if (StringUtils.isNotBlank((CharSequence)reqVo.getInspectionConclusion())) {
            head.setInspectionConclusion(reqVo.getInspectionConclusion());
        }
        if (Objects.nonNull(reqVo.getAbarbeitungLimitTime())) {
            head.setAbarbeitungLimitTime(reqVo.getAbarbeitungLimitTime());
        }
    }

    private void updateSHeadInspectionConclusionOrAbarbeitungLimitTime(PurchaseInspectionHead head, SaleInspectionHead sHead) {
        if (StringUtils.isNotBlank((CharSequence)head.getInspectionConclusion())) {
            sHead.setInspectionConclusion(head.getInspectionConclusion());
        }
        if (Objects.nonNull(head.getAbarbeitungLimitTime())) {
            sHead.setAbarbeitungLimitTime(head.getAbarbeitungLimitTime());
        }
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public InspectionScoreResVo getById(String id) {
        InspectionScoreResVo resVo = new InspectionScoreResVo();
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)((PurchaseInspectionHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)resVo));
        List<PurchaseInspectionItem> itemList = this.itemMapper.selectByMainId(id);
        if (!CollectionUtils.isEmpty(itemList)) {
            itemList.forEach(item -> item.setItemDetailList(this.itemDetailMapper.selectWithoutElsAccountByItemId(item.getInspectionStandardItemId())));
        }
        resVo.setInspectionItemList(itemList);
        resVo.setScoreGroupList(this.scoreGroupMapper.selectByMainId(id));
        resVo.setInspectionPlanList(this.planMapper.selectByMainId(id));
        resVo.setAttachmentList(this.baseRpcService.purcahseSelectByMainId(id));
        return resVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMain(String id) {
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)((PurchaseInspectionHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(head.getResultAuditStatus()) || AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getResultAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UzsSUzeRjtFqQG_908d607c", (String)"\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u4e0d\u53ef\u5220\u9664"));
        }
        int countNum = ((PurchaseInspectionHeadMapper)this.baseMapper).countByIAndStatus(id, "0");
        AssertI18nUtil.isTrue((countNum <= 0 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.P_INSPECT_NULL_NOT_NEW);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BaseEntity::getId, (Object)id);
        PurchaseInspectionHead purchaseInspectionHead = (PurchaseInspectionHead)((Object)this.getOne((Wrapper)queryWrapper));
        ElsInspectionPlanHeadServiceImpl planHeadService = (ElsInspectionPlanHeadServiceImpl)SpringContextUtils.getBean(ElsInspectionPlanHeadServiceImpl.class);
        planHeadService.deletedOrCancelWriteBackPlanItem(purchaseInspectionHead);
        ((PurchaseInspectionHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.delByHeadId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancellation(String id) {
        PurchaseInspectionHead purchaseInspectionHead = (PurchaseInspectionHead)((Object)((PurchaseInspectionHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((purchaseInspectionHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        String status = purchaseInspectionHead.getDocumentsStatus();
        AssertI18nUtil.isTrue(("0".equals(status) || "5".equals(status) || "6".equals(status) || "7".equals(status) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.STATUS_CANCELLATION_FAIL);
        purchaseInspectionHead.setDocumentsStatus("7");
        ((PurchaseInspectionHeadMapper)this.baseMapper).updateById((Object)purchaseInspectionHead);
        ElsInspectionPlanHeadServiceImpl planHeadService = (ElsInspectionPlanHeadServiceImpl)SpringContextUtils.getBean(ElsInspectionPlanHeadServiceImpl.class);
        planHeadService.deletedOrCancelWriteBackPlanItem(purchaseInspectionHead);
        if (StringUtils.isBlank((CharSequence)purchaseInspectionHead.getRelationId())) {
            return;
        }
        SaleInspectionHead saleInspectionHead = (SaleInspectionHead)((Object)this.sHeadMapper.selectById((Serializable)((Object)purchaseInspectionHead.getRelationId())));
        saleInspectionHead.setDocumentsStatus("7");
        this.sHeadMapper.updateById((Object)saleInspectionHead);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<PurchaseInspectionItem> getItems(GetItemsReqVo reqVo) {
        List<PurchaseInspectionItem> itemList = this.standardItemMapper.getItems(reqVo.getName(), reqVo.getVersionNumber(), TenantContext.getTenant());
        if (!CollectionUtils.isEmpty(itemList) && "3".equals(reqVo.getInspectionStep())) {
            itemList.forEach(item -> item.setItemDetailList(this.itemDetailMapper.selectWithoutElsAccountByItemId(item.getInspectionStandardItemId())));
        }
        return itemList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePlanTailAfter(InspectionPlanReqSaveVo reqVo) {
        PurchaseInspectionHead purchaseInspectionHead = (PurchaseInspectionHead)((Object)((PurchaseInspectionHeadMapper)this.baseMapper).selectById((Serializable)((Object)reqVo.getId())));
        AssertI18nUtil.isTrue((purchaseInspectionHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        reqVo.getInspectionPlanList().forEach(planVo -> {
            PurchaseInspectionPlan purPlan = (PurchaseInspectionPlan)((Object)((Object)this.planMapper.selectById((Serializable)((Object)planVo.getId()))));
            AssertI18nUtil.isTrue((purPlan == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
            purPlan.setPlanStage(planVo.getPlanStage()).setPlanFinishTime(planVo.getPlanFinishTime()).setActualFinishTime(planVo.getActualFinishTime()).setPlanTailAfter(planVo.getPlanTailAfter()).setRemark(planVo.getRemark());
            this.planMapper.updateById((Object)purPlan);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitPlanTailAfter(InspectionPlanReqSubmitVo reqVo) {
        PurchaseInspectionHead purHead = (PurchaseInspectionHead)((Object)((PurchaseInspectionHeadMapper)this.baseMapper).selectById((Serializable)((Object)reqVo.getId())));
        AssertI18nUtil.isTrue((purHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        reqVo.getInspectionPlanList().forEach(planVo -> {
            this.planMapper.updateById(planVo);
            if (StringUtils.isBlank((CharSequence)planVo.getToSaleId())) {
                return;
            }
            SaleInspectionPlan salePlan = (SaleInspectionPlan)((Object)((Object)this.sPlanMapper.selectById((Serializable)((Object)planVo.getToSaleId()))));
            AssertI18nUtil.isTrue((salePlan == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
            salePlan.setPlanStage(planVo.getPlanStage()).setPlanFinishTime(planVo.getPlanFinishTime()).setActualFinishTime(planVo.getActualFinishTime()).setPlanTailAfter(planVo.getPlanTailAfter()).setRemark(planVo.getRemark());
            this.sPlanMapper.updateById((Object)salePlan);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<?> eightReportRectification(String id) {
        PurchaseInspectionHead purHead = (PurchaseInspectionHead)((Object)((PurchaseInspectionHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((purHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((!"5".equals(purHead.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.STATUS_CAN_NOT_RECTIFICATION);
        AssertI18nUtil.isTrue((!"2".equals(purHead.getInspectionConclusion()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.INSPECTION_CONCLUSION_CAN_NOT_RECTIFICATION);
        AssertI18nUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purHead.getEightReportNumber()), (Enum)I18nSiteInspectEnum.DOC_HAS_RECTIFICATION);
        List<TemplateHeadDTO> templateList = this.baseRpcService.getDefaultTemplateByType("eightDisciplines");
        PurchaseEightDisciplinesZero eightD0 = new PurchaseEightDisciplinesZero();
        LoginUser sysUser = SysUtil.getLoginUser();
        eightD0.setTemplateNumber(templateList.get(0).getTemplateNumber()).setTemplateName(templateList.get(0).getTemplateName()).setTemplateVersion(templateList.get(0).getTemplateVersion().toString()).setTemplateAccount(templateList.get(0).getElsAccount()).setEightDisciplinesNumber(this.baseRpcService.getNextCode("eightDisciplines", (Object)eightD0)).setEightDisciplinesStatus(EightReportStatusEnum.D0.getValue()).setEightDisciplinesType("gysgj").setQuestionSource("XCKC").setSourceNumber(purHead.getDocumentsSerialNumber()).setToElsAccount(purHead.getToElsAccount()).setSupplierCode(purHead.getSupplierErpCode()).setSupplierName(purHead.getSupplierName()).setPurchaseOrg(purHead.getPurchaseOrg()).setFactory(purHead.getFactory()).setMaterialNumber(purHead.getMaterialType()).setRelationId(IdWorker.getIdStr()).setPublishUser(sysUser.getSubAccount() + "_" + sysUser.getRealname()).setBusAccount(TenantContext.getTenant()).setPublishTime(new Date()).setId(IdWorker.getIdStr());
        List<PurchaseOrganizationInfoDTO> deptOrgList = this.eight0Service.getDeptById(sysUser.getOrgCode());
        if (CollectionUtil.isNotEmpty(deptOrgList)) {
            eightD0.setCreateDepartment(this.eight0Service.getDeptName(deptOrgList));
            eightD0.setCreateDepartmentId(this.eight0Service.getDeptCode(deptOrgList));
        }
        this.eightD0Mapper.insert((Object)eightD0);
        String elsAccount = StringUtils.isNotBlank((CharSequence)purHead.getToElsAccount()) ? purHead.getToElsAccount() : TenantContext.getTenant();
        String subAccount = StringUtils.isNotBlank((CharSequence)purHead.getToElsAccount()) ? "1001" : sysUser.getSubAccount();
        ElsSubAccountDTO accountDTO = this.accountRpcService.getAccount(elsAccount, subAccount);
        if (accountDTO != null) {
            ArrayList<PurchaseEightDisciplinesTeam> teams = new ArrayList<PurchaseEightDisciplinesTeam>();
            EightReportStatusEnum[] enums = EightReportStatusEnum.values();
            for (int i = 0; i < enums.length; ++i) {
                if ("D0".equals(enums[i].getValue()) || "D9".equals(enums[i].getValue()) || "D10".equals(enums[i].getValue())) continue;
                PurchaseEightDisciplinesTeam team = new PurchaseEightDisciplinesTeam();
                team.setHeadId(eightD0.getId()).setBusAccount(TenantContext.getTenant()).setEightDisciplinesNumber(eightD0.getEightDisciplinesNumber()).setItemNumber(String.valueOf(i + 1)).setReportFlowStep(enums[i].getValue()).setSourceType("XCKC");
                if ("D8".equals(enums[i].getValue())) {
                    team.setToElsAccount(TenantContext.getTenant()).setSubAccount(sysUser.getSubAccount()).setName(sysUser.getRealname()).setPhone(sysUser.getPhone()).setMail(sysUser.getEmail()).setTeamRole("teamer");
                } else {
                    team.setToElsAccount(accountDTO.getElsAccount()).setSubAccount(accountDTO.getSubAccount()).setName(accountDTO.getRealname()).setPhone(accountDTO.getPhone()).setMail(accountDTO.getEmail()).setTeamRole("member");
                }
                this.setBaseEntity(team);
                teams.add(team);
            }
            this.teamService.saveBatch(teams, 2000);
        }
        purHead.setEightReportNumber(eightD0.getEightDisciplinesNumber()).setEightReportStatus(eightD0.getEightDisciplinesStatus());
        ((PurchaseInspectionHeadMapper)this.baseMapper).updateById((Object)purHead);
        if (StringUtils.isNotBlank((CharSequence)purHead.getRelationId())) {
            SaleInspectionHead saleHead = new SaleInspectionHead();
            saleHead.setEightReportNumber(eightD0.getEightDisciplinesNumber()).setEightReportStatus(eightD0.getEightDisciplinesStatus()).setId(purHead.getRelationId());
            this.sHeadMapper.updateById((Object)saleHead);
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hAWWirLRWirtyLWWWWWWW_635c28b", (String)"\u53d1\u8d778D\u6574\u6539\u6210\u529f,\u6574\u6539\u5355\u53f7\u4e3a:[${0}]", (String[])new String[]{purHead.getEightReportNumber()}));
    }

    private List<PurchaseOrganizationInfoDTO> getDeptById(String deptIds) {
        if (org.springframework.util.StringUtils.isEmpty((Object)deptIds)) {
            return new ArrayList<PurchaseOrganizationInfoDTO>();
        }
        String[] depts = deptIds.split(",");
        return this.invokeMainDataRpcService.selectOrgByIds(depts, "dept");
    }

    private String getDeptName(List<PurchaseOrganizationInfoDTO> deptOrgList) throws NullPointerException {
        if (CollectionUtil.isEmpty(deptOrgList)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < deptOrgList.size(); ++i) {
            PurchaseOrganizationInfoDTO purchaseOrganizationInfo = deptOrgList.get(i);
            if (org.springframework.util.StringUtils.isEmpty((Object)purchaseOrganizationInfo.getOrgName())) continue;
            sb.append(purchaseOrganizationInfo.getOrgName());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private String getDeptCode(List<PurchaseOrganizationInfoDTO> deptOrgList) throws NullPointerException {
        if (CollectionUtil.isEmpty(deptOrgList)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < deptOrgList.size(); ++i) {
            PurchaseOrganizationInfoDTO purchaseOrganizationInfo = deptOrgList.get(i);
            if (org.springframework.util.StringUtils.isEmpty((Object)purchaseOrganizationInfo.getOrgCode())) continue;
            sb.append(purchaseOrganizationInfo.getOrgCode());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public Result<?> supplierRectification(String id) {
        PurchaseInspectionHead purHead = (PurchaseInspectionHead)((Object)((PurchaseInspectionHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((purHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((!"5".equals(purHead.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.STATUS_CAN_NOT_RECTIFICATION);
        AssertI18nUtil.isTrue((!"2".equals(purHead.getInspectionConclusion()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.INSPECTION_CONCLUSION_CAN_NOT_RECTIFICATION);
        AssertI18nUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purHead.getReportCode()), (Enum)I18nSiteInspectEnum.DOC_HAS_RECTIFICATION);
        List<TemplateHeadDTO> templateList = this.baseRpcService.getDefaultTemplateByType("supplierRetification");
        LoginUser loginUser = SysUtil.getLoginUser();
        PurchaseSupplierRectificationReportHead reHead = new PurchaseSupplierRectificationReportHead();
        reHead.setTemplateNumber(templateList.get(0).getTemplateNumber()).setTemplateName(templateList.get(0).getTemplateName()).setTemplateVersion(templateList.get(0).getTemplateVersion().toString()).setTemplateAccount(templateList.get(0).getElsAccount()).setReportCode(this.baseRpcService.getNextCode("saleRetification", (Object)reHead)).setBusAccount(purHead.getElsAccount()).setToElsAccount(purHead.getToElsAccount()).setSupplierCode(purHead.getSupplierErpCode()).setSupplierName(purHead.getSupplierName()).setCompany(purHead.getCompany()).setPurchaseOrg(purHead.getPurchaseOrg()).setRectificationStatus(SupplierRectificationStatusEnum.NEW.getValue()).setPublishStatus(SupplierRectificationPublishStatusEnum.UN_PUBLISH.getValue()).setFinishTime(purHead.getAbarbeitungLimitTime()).setApplicant(loginUser.getRealname()).setPreAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue()).setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue()).setRelationId(IdWorker.getIdStr()).setRectificationDate(new Date()).setDeleted(CommonConstant.DEL_FLAG_0);
        List<PurchaseOrganizationInfoDTO> deptOrgList = this.getDeptById(loginUser.getOrgCode());
        if (CollectionUtil.isNotEmpty(deptOrgList)) {
            String deptName = this.getDeptName(deptOrgList);
            String deptId = this.getDeptCode(deptOrgList);
            if (!org.springframework.util.StringUtils.isEmpty((Object)deptName)) {
                reHead.setApplicantDepartment(deptName);
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)deptId)) {
                reHead.setApplicantDepartmentId(deptId);
            }
        }
        this.sReportHeadMapper.insert((Object)reHead);
        purHead.setReportCode(reHead.getReportCode()).setRectificationStatus(reHead.getRectificationStatus());
        ((PurchaseInspectionHeadMapper)this.baseMapper).updateById((Object)purHead);
        PurchaseSupplierRectificationReportItem item = new PurchaseSupplierRectificationReportItem();
        item.setHeadId(reHead.getId());
        item.setRelationId(IdWorker.getIdStr());
        item.setElsAccount(reHead.getElsAccount());
        item.setToElsAccount(reHead.getToElsAccount());
        item.setReportCode(reHead.getReportCode());
        item.setSourceType(SupplierRectificationSourceTypeEnum.PURSITEINSPECTION.getValue());
        item.setSourceNumber(purHead.getDocumentsSerialNumber());
        item.setDeleted(CommonConstant.DEL_FLAG_0);
        this.supplierRectificationReportItemMapper.insert((Object)item);
        if (StringUtils.isNotBlank((CharSequence)purHead.getRelationId())) {
            SaleInspectionHead saleHead = new SaleInspectionHead();
            saleHead.setReportCode(reHead.getReportCode()).setRectificationStatus(reHead.getRectificationStatus()).setId(purHead.getRelationId());
            this.sHeadMapper.updateById((Object)saleHead);
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hAirLRWirtyLWWWWWWW_190a697", (String)"\u53d1\u8d77\u6574\u6539\u6210\u529f,\u6574\u6539\u5355\u53f7\u4e3a:[${0}]", (String[])new String[]{purHead.getReportCode()}));
    }

    private void setEightReport(List<PurchaseInspectionHead> heads) {
        if (CollectionUtils.isEmpty(heads)) {
            return;
        }
        List<String> ltNums = heads.stream().filter(head -> StringUtils.isNotBlank((CharSequence)head.getEightReportNumber()) && !EightReportStatusEnum.D9.getValue().equals(head.getEightReportStatus())).map(PurchaseInspectionHead::getEightReportNumber).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ltNums)) {
            return;
        }
        List<EightReportVo> eightReportVos = ((PurchaseInspectionHeadMapper)this.baseMapper).getEightReport(ltNums);
        if (CollectionUtils.isEmpty(eightReportVos)) {
            heads.forEach(purHead -> {
                if (StringUtils.isBlank((CharSequence)purHead.getEightReportNumber())) {
                    return;
                }
                purHead.setEightReportNumber(null).setEightReportStatus(null).setEightReportEvaluate(null);
                ((PurchaseInspectionHeadMapper)this.baseMapper).clearEightReport(purHead.getId());
            });
            return;
        }
        Map<String, EightReportVo> mapEightReportVos = eightReportVos.stream().collect(Collectors.toMap(EightReportVo::getEightDisciplinesNumber, reportVo -> reportVo));
        for (PurchaseInspectionHead head2 : heads) {
            if (StringUtils.isBlank((CharSequence)head2.getEightReportNumber()) || EightReportStatusEnum.D9.getValue().equals(head2.getEightReportStatus())) continue;
            EightReportVo reportVo2 = mapEightReportVos.get(head2.getEightReportNumber());
            if (reportVo2 == null || CommonConstant.DEL_FLAG_0.intValue() != reportVo2.getDeleted()) {
                head2.setEightReportNumber(null).setEightReportStatus(null).setEightReportEvaluate(null);
                ((PurchaseInspectionHeadMapper)this.baseMapper).clearEightReport(head2.getId());
                continue;
            }
            head2.setEightReportStatus(reportVo2.getEightDisciplinesStatus()).setEightReportEvaluate(reportVo2.getClosedCondition());
            if (EightReportStatusEnum.D9.getValue().equals(reportVo2.getEightDisciplinesStatus())) {
                head2.setDocumentsStatus("6");
            }
            ((PurchaseInspectionHeadMapper)this.baseMapper).updateEightReport(head2.getId(), head2.getEightReportStatus(), head2.getEightReportEvaluate(), head2.getDocumentsStatus());
            if (!"6".equals(head2.getDocumentsStatus())) continue;
            ElsInspectionPlanHeadServiceImpl planHeadService = (ElsInspectionPlanHeadServiceImpl)SpringContextUtils.getBean(ElsInspectionPlanHeadServiceImpl.class);
            planHeadService.caseClosedWriteBackPlanItem(head2);
        }
    }

    private void setSaleRectification(List<PurchaseInspectionHead> heads) {
        if (CollectionUtils.isEmpty(heads)) {
            return;
        }
        List<String> ltNums = heads.stream().filter(head -> StringUtils.isNotBlank((CharSequence)head.getReportCode()) && !SupplierRectificationStatusEnum.RECTIFICATIONED.getValue().equals(head.getRectificationStatus())).map(PurchaseInspectionHead::getReportCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ltNums)) {
            return;
        }
        List<SaleRectificationVO> reportVos = ((PurchaseInspectionHeadMapper)this.baseMapper).getSaleRectification(ltNums);
        if (CollectionUtils.isEmpty(reportVos)) {
            heads.forEach(purHead -> {
                if (StringUtils.isBlank((CharSequence)purHead.getReportCode())) {
                    return;
                }
                purHead.setReportCode(null).setRectificationStatus(null).setRectificationConclusion(null);
                ((PurchaseInspectionHeadMapper)this.baseMapper).clearSaleRectification(purHead.getId());
            });
            return;
        }
        Map<String, SaleRectificationVO> mapSaleReportVos = reportVos.stream().collect(Collectors.toMap(SaleRectificationVO::getReportCode, reportVo -> reportVo));
        for (PurchaseInspectionHead head2 : heads) {
            if (StringUtils.isBlank((CharSequence)head2.getReportCode()) || SupplierRectificationStatusEnum.RECTIFICATIONED.getValue().equals(head2.getRectificationStatus())) continue;
            SaleRectificationVO reportVo2 = mapSaleReportVos.get(head2.getReportCode());
            if (reportVo2 == null || CommonConstant.DEL_FLAG_0.intValue() != reportVo2.getDeleted() || SupplierRectificationStatusEnum.RETURNED.getValue().equals(reportVo2.getRectificationStatus())) {
                head2.setReportCode(null).setRectificationStatus(null).setRectificationConclusion(null);
                ((PurchaseInspectionHeadMapper)this.baseMapper).clearSaleRectification(head2.getId());
                continue;
            }
            head2.setRectificationStatus(reportVo2.getRectificationStatus()).setRectificationConclusion(reportVo2.getRectificationConclusion());
            if (SupplierRectificationStatusEnum.RECTIFICATIONED.getValue().equals(reportVo2.getRectificationStatus())) {
                head2.setDocumentsStatus("6");
            }
            ((PurchaseInspectionHeadMapper)this.baseMapper).updateSaleRectification(head2.getId(), head2.getRectificationStatus(), head2.getRectificationConclusion(), head2.getDocumentsStatus());
            if (!"6".equals(head2.getDocumentsStatus())) continue;
            ElsInspectionPlanHeadServiceImpl planHeadService = (ElsInspectionPlanHeadServiceImpl)SpringContextUtils.getBean(ElsInspectionPlanHeadServiceImpl.class);
            planHeadService.caseClosedWriteBackPlanItem(head2);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void setRectification(List<PurchaseInspectionHead> heads) {
        this.setEightReport(heads);
        this.setSaleRectification(heads);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public InspectionScoreResVo getSelfScoreItemDetail(String id) {
        InspectionScoreResVo resVo = new InspectionScoreResVo();
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)((PurchaseInspectionHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)resVo));
        String classify = this.scoreGroupMapper.getInspectionClassify(id, this.getElsSubAccount());
        List<PurchaseInspectionItem> itemList = this.itemMapper.getSelfScoreItem(id, classify);
        if (!CollectionUtils.isEmpty(itemList)) {
            itemList.forEach(item -> item.setItemDetailList(this.itemDetailMapper.selectWithoutElsAccountByItemId(item.getInspectionStandardItemId())));
        }
        resVo.setInspectionItemList(itemList);
        resVo.setScoreGroupList(this.scoreGroupMapper.selectByMainId(id));
        resVo.setInspectionPlanList(this.planMapper.selectByMainId(id));
        resVo.setAttachmentList(this.baseRpcService.purcahseSelectByMainId(id));
        return resVo;
    }

    @Override
    public void copy(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PurchaseInspectionHead purchaseInspectionHead = (PurchaseInspectionHead)((Object)((PurchaseInspectionHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
            LoginUser loginUser = SysUtil.getLoginUser();
            if (purchaseInspectionHead != null) {
                List<PurchaseInspectionPlan> list;
                List<PurchaseInspectionScoreGroup> groupList;
                purchaseInspectionHead.setId(null);
                purchaseInspectionHead.setCreateTime(new Date());
                purchaseInspectionHead.setCreateBy(loginUser.getSubAccount());
                purchaseInspectionHead.setCreateById(loginUser.getId());
                purchaseInspectionHead.setUpdateTime(new Date());
                purchaseInspectionHead.setUpdateBy(loginUser.getSubAccount());
                purchaseInspectionHead.setUpdateById(loginUser.getId());
                purchaseInspectionHead.setInspectScore(null);
                purchaseInspectionHead.setScoreGrade(null);
                purchaseInspectionHead.setInspectionConclusion(null);
                purchaseInspectionHead.setSelfAssessmentScore(null);
                purchaseInspectionHead.setEightReportNumber(null);
                purchaseInspectionHead.setEightReportStatus(null);
                purchaseInspectionHead.setEightReportEvaluate(null);
                purchaseInspectionHead.setReportCode(null);
                purchaseInspectionHead.setRectificationStatus(null);
                purchaseInspectionHead.setRectificationConclusion(null);
                purchaseInspectionHead.setDocumentsSerialNumber(this.getSerialNumber((Object)purchaseInspectionHead)).setDocumentsStatus("0").setResultAuditStatus(this.getAudiStatus(purchaseInspectionHead.getPubishAudit())).setBusAccount(TenantContext.getTenant()).setDataVersion(0).setId(IdWorker.getIdStr());
                ((PurchaseInspectionHeadMapper)this.baseMapper).insert((Object)purchaseInspectionHead);
                List<PurchaseInspectionItem> purchaseInspectionItems = this.itemMapper.selectByMainId(id);
                if (purchaseInspectionItems != null && purchaseInspectionItems.size() > 0) {
                    for (PurchaseInspectionItem purchaseInspectionItem : purchaseInspectionItems) {
                        purchaseInspectionItem.setId(null);
                        purchaseInspectionItem.setHeadId(purchaseInspectionHead.getId());
                        SysUtil.setSysParam((BaseEntity)purchaseInspectionItem, (BaseEntity)purchaseInspectionHead);
                        purchaseInspectionItem.setSelfAssessmentScore(null);
                        purchaseInspectionItem.setSelfAssessmentResult(null);
                        purchaseInspectionItem.setInspectResult(null);
                        purchaseInspectionItem.setInspectScore(null);
                    }
                    this.itemService.saveBatch(purchaseInspectionItems, 2000);
                }
                if ((groupList = this.scoreGroupMapper.selectByMainId(id)) != null && groupList.size() > 0) {
                    for (PurchaseInspectionScoreGroup item : groupList) {
                        item.setId(null);
                        item.setHeadId(purchaseInspectionHead.getId());
                        item.setScoreType(null);
                        SysUtil.setSysParam((BaseEntity)item, (BaseEntity)purchaseInspectionHead);
                    }
                    this.socreGroupService.saveBatch(groupList, 2000);
                }
                if ((list = this.planMapper.selectByMainId(id)) != null && list.size() > 0) {
                    for (PurchaseInspectionPlan item : list) {
                        item.setId(null);
                        item.setHeadId(purchaseInspectionHead.getId());
                        SysUtil.setSysParam((BaseEntity)item, (BaseEntity)purchaseInspectionHead);
                        item.setActualFinishTime(null);
                        item.setPlanTailAfter(null);
                    }
                    this.planService.saveBatch(list, 2000);
                }
            }
        }
    }

    @Override
    public JSONObject getDataById(String id) {
        InspectionScoreResVo inspectionScoreResVo = this.getById(id);
        Result result = Result.ok((Object)((Object)inspectionScoreResVo));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }
}

