/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.caigouwang.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.caigouwang.entity.CaigouBusinessList;
import com.els.modules.caigouwang.mapper.CaigouBusinessListMapper;
import com.els.modules.caigouwang.service.CaigouBusinessListService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CaigouBusinessListServiceImpl
extends BaseServiceImpl<CaigouBusinessListMapper, CaigouBusinessList>
implements CaigouBusinessListService {
    @Value(value="${b2b.business-opportunity}")
    private String address;
    private static String BUSINESS_LIST_URL = "business/web/notice/business-list";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd+hh:mm:ss");
    private static SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    @Resource
    private CaigouBusinessListMapper caigouBusinessListMapper;

    @Override
    public void saveCaigouBusinessList(CaigouBusinessList caigouBusinessList) {
        ((CaigouBusinessListMapper)this.baseMapper).insert((Object)caigouBusinessList);
    }

    @Override
    public void updateCaigouBusinessList(CaigouBusinessList caigouBusinessList) {
        ((CaigouBusinessListMapper)this.baseMapper).updateById((Object)caigouBusinessList);
    }

    @Override
    public void delCaigouBusinessList(String id) {
        ((CaigouBusinessListMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchCaigouBusinessList(List<String> idList) {
        ((CaigouBusinessListMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void handleData(CaigouBusinessList caigouBusinessList, Integer pageNo, Integer pageSize) {
        this.syncGetData();
    }

    @Async
    public void syncGetData() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"create_time"});
        wrapper.orderByDesc((Object)"create_time");
        wrapper.last(" limit 1");
        List list = this.list((Wrapper)wrapper);
        String startDate = null;
        String endDate = null;
        if (!list.isEmpty()) {
            startDate = sdf.format(((CaigouBusinessList)((Object)list.get(0))).getCreateTime());
            endDate = sdf.format(new Date());
        }
        String url = null;
        url = startDate == null ? this.address + BUSINESS_LIST_URL + "?size=100&current=1" : this.address + BUSINESS_LIST_URL + "?startDate=" + startDate + "&endDate=" + endDate + "&size=100&current=1";
        String response = HttpRequest.get((String)url).execute().body();
        JSONObject result = JSONObject.parseObject((String)response);
        if (result.getBoolean("success").booleanValue()) {
            ArrayList replenishList = new ArrayList();
            JSONObject data = result.getJSONObject("data");
            Integer total = data.getInteger("total");
            Integer size = data.getInteger("size");
            Integer current = data.getInteger("current");
            Integer pages = data.getInteger("pages");
            if (total != null && total > 0) {
                ArrayList lists = SysUtil.copyProperties((List)data.getJSONArray("records"), CaigouBusinessList.class);
                replenishList.addAll(lists);
            }
            for (int i = current.intValue(); i < pages; ++i) {
                Integer n = current;
                current = current + 1;
                url = startDate == null ? this.address + BUSINESS_LIST_URL + "?size=100&current=" + current : this.address + BUSINESS_LIST_URL + "?startDate=" + startDate + "&endDate=" + endDate + "&size=100&current=" + current;
                response = HttpRequest.get((String)url).execute().body();
                result = JSONObject.parseObject((String)response);
                if (!result.getBoolean("success").booleanValue()) continue;
                data = result.getJSONObject("data");
                ArrayList lists = SysUtil.copyProperties((List)data.getJSONArray("records"), CaigouBusinessList.class);
                replenishList.addAll(lists);
            }
            if (replenishList.size() > 0 && !list.isEmpty()) {
                this.caigouBusinessListMapper.deleteByTime(sdf2.format(((CaigouBusinessList)((Object)list.get(0))).getCreateTime()), sdf2.format(new Date()));
            }
            this.saveBatch(replenishList);
        }
    }
}

