/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.minerals.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.minerals.entity.PurchaseMineralsCollect;
import com.els.modules.minerals.entity.PurchaseMineralsDetail;
import com.els.modules.minerals.entity.PurchaseMineralsMetal;
import com.els.modules.minerals.entity.SaleMineralsCollect;
import com.els.modules.minerals.entity.SaleMineralsDetail;
import com.els.modules.minerals.entity.SaleMineralsMetal;
import com.els.modules.minerals.enumerate.MineralsCollectStatusEnum;
import com.els.modules.minerals.mapper.SaleMineralsCollectMapper;
import com.els.modules.minerals.service.PurchaseMineralsDetailService;
import com.els.modules.minerals.service.PurchaseMineralsMetalService;
import com.els.modules.minerals.service.SaleMineralsCollectService;
import com.els.modules.minerals.service.SaleMineralsDetailService;
import com.els.modules.minerals.service.SaleMineralsMetalService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleMineralsCollectServiceImpl
extends BaseServiceImpl<SaleMineralsCollectMapper, SaleMineralsCollect>
implements SaleMineralsCollectService {
    @Resource
    private SaleMineralsMetalService saleMineralsMetalService;
    @Resource
    private SaleMineralsDetailService saleMineralsDetailService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleMineralsCollect saleMineralsCollect, List<SaleMineralsMetal> saleMineralsMetalList, List<SaleMineralsDetail> saleMineralsDetailList, List<SaleAttachmentDTO> attachmentList) {
        ((SaleMineralsCollectMapper)this.baseMapper).insert((Object)saleMineralsCollect);
        super.setHeadDefaultValue((BaseEntity)saleMineralsCollect);
        this.insertData(saleMineralsCollect, saleMineralsMetalList, saleMineralsDetailList, attachmentList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleMineralsCollect saleMineralsCollect, List<SaleMineralsMetal> saleMineralsMetalList, List<SaleMineralsDetail> saleMineralsDetailList, List<SaleAttachmentDTO> attachmentList) {
        int count = ((SaleMineralsCollectMapper)this.baseMapper).updateById((Object)saleMineralsCollect);
        this.saleMineralsMetalService.deleteByMainId(saleMineralsCollect.getId());
        this.saleMineralsDetailService.deleteByMainId(saleMineralsCollect.getId());
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleMineralsCollect.getId());
        this.insertData(saleMineralsCollect, saleMineralsMetalList, saleMineralsDetailList, attachmentList);
    }

    private void insertData(SaleMineralsCollect saleMineralsCollect, List<SaleMineralsMetal> saleMineralsMetalList, List<SaleMineralsDetail> saleMineralsDetailList, List<SaleAttachmentDTO> attachmentList) {
        if (!CollectionUtils.isEmpty(saleMineralsMetalList)) {
            for (SaleMineralsMetal saleMineralsMetal : saleMineralsMetalList) {
                saleMineralsMetal.setHeadId(saleMineralsCollect.getId());
                SysUtil.setSysParam((BaseEntity)saleMineralsMetal, (BaseEntity)saleMineralsCollect);
            }
            this.saleMineralsMetalService.saveBatch(saleMineralsMetalList, 2000);
        }
        if (!CollectionUtils.isEmpty(saleMineralsDetailList)) {
            for (SaleMineralsDetail saleMineralsDetail : saleMineralsDetailList) {
                saleMineralsDetail.setHeadId(saleMineralsCollect.getId());
                SysUtil.setSysParam((BaseEntity)saleMineralsDetail, (BaseEntity)saleMineralsCollect);
            }
            this.saleMineralsDetailService.saveBatch(saleMineralsDetailList, 2000);
        }
        if (!CollectionUtils.isEmpty(attachmentList)) {
            for (SaleAttachmentDTO saleAttachmentDTO : attachmentList) {
                saleAttachmentDTO.setHeadId(saleMineralsCollect.getId());
                if (StringUtils.isBlank((String)saleAttachmentDTO.getFbk10())) {
                    saleAttachmentDTO.setFbk10(saleMineralsCollect.getSupplierName());
                }
                SysUtil.setSysParam((BaseDTO)saleAttachmentDTO, (BaseEntity)saleMineralsCollect);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.saleMineralsMetalService.deleteByMainId(id);
        this.saleMineralsDetailService.deleteByMainId(id);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
        ((SaleMineralsCollectMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleMineralsMetalService.deleteByMainId(serializable.toString());
            this.saleMineralsDetailService.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(serializable.toString());
            ((SaleMineralsCollectMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void submit(SaleMineralsCollect saleMineralsCollect, List<SaleMineralsMetal> mineralsMetalList, List<SaleMineralsDetail> mineralsDetailList, List<SaleAttachmentDTO> attachmentList) {
        this.handleSubmitCheck(saleMineralsCollect, mineralsMetalList, mineralsDetailList);
        String purHeadId = saleMineralsCollect.getRelationId();
        String saleElsAccount = saleMineralsCollect.getElsAccount();
        String purchaseAccount = saleMineralsCollect.getToElsAccount();
        PurchaseMineralsDetailService purchaseDetailService = (PurchaseMineralsDetailService)SpringContextUtils.getBean(PurchaseMineralsDetailService.class);
        ArrayList<PurchaseMineralsDetail> detailList = new ArrayList<PurchaseMineralsDetail>();
        int i = 0;
        for (SaleMineralsDetail detail : mineralsDetailList) {
            ++i;
            PurchaseMineralsDetail purchaseDetail = new PurchaseMineralsDetail();
            String id = StringUtils.isBlank((String)detail.getId()) ? IdWorker.getIdStr() : detail.getId();
            detail.setId(id);
            detail.setRelationId(id);
            detail.setHeadId(saleMineralsCollect.getId());
            if (!MineralsCollectStatusEnum.CONFIRM.getValue().equals(detail.getItemStatus())) {
                detail.setItemStatus(MineralsCollectStatusEnum.SUBMIT.getValue());
            }
            detail.setBatchNumber(saleMineralsCollect.getBatchNumber());
            detail.setCollectNumber(saleMineralsCollect.getCollectNumber());
            detail.setSupplierCode(saleMineralsCollect.getSupplierCode());
            detail.setSupplierName(saleMineralsCollect.getSupplierName());
            detail.setToElsAccount(purchaseAccount);
            detail.setElsAccount(saleElsAccount);
            detail.setItemNumber(String.valueOf(i));
            BeanUtils.copyProperties((Object)((Object)detail), (Object)((Object)purchaseDetail));
            purchaseDetail.setId(id);
            purchaseDetail.setRelationId(id);
            purchaseDetail.setHeadId(purHeadId);
            purchaseDetail.setElsAccount(purchaseAccount);
            purchaseDetail.setToElsAccount(saleElsAccount);
            purchaseDetail.setFbk1(saleMineralsCollect.getCollectName());
            detailList.add(purchaseDetail);
        }
        purchaseDetailService.saveOrUpdateBatch(detailList);
        this.saleMineralsDetailService.saveOrUpdateBatch(mineralsDetailList);
        PurchaseMineralsMetalService purchaseMetalService = (PurchaseMineralsMetalService)SpringContextUtils.getBean(PurchaseMineralsMetalService.class);
        ArrayList metalList = new ArrayList();
        mineralsMetalList.forEach(metal -> {
            PurchaseMineralsMetal purchaseMetal = new PurchaseMineralsMetal();
            String id = StringUtils.isBlank((String)metal.getId()) ? IdWorker.getIdStr() : metal.getId();
            metal.setId(id);
            metal.setRelationId(id);
            metal.setHeadId(saleMineralsCollect.getId());
            BeanUtils.copyProperties((Object)metal, (Object)((Object)purchaseMetal));
            purchaseMetal.setId(id);
            purchaseMetal.setRelationId(id);
            purchaseMetal.setHeadId(purHeadId);
            purchaseMetal.setElsAccount(purchaseAccount);
            purchaseMetal.setToElsAccount(saleElsAccount);
            metalList.add(purchaseMetal);
        });
        purchaseMetalService.saveOrUpdateBatch(metalList);
        this.saleMineralsMetalService.saveOrUpdateBatch(mineralsMetalList);
        this.handleAttachmentSubmit(saleMineralsCollect, attachmentList);
        saleMineralsCollect.setCollectStatus(MineralsCollectStatusEnum.SUBMIT.getValue());
        this.updateById((Object)saleMineralsCollect);
        PurchaseMineralsCollect purchaseMineralsCollect = new PurchaseMineralsCollect();
        purchaseMineralsCollect.setId(purHeadId);
        super.sendMessage(saleMineralsCollect.getElsAccount(), "minerals", "publishSupplier", saleMineralsCollect.getId(), "mineralsCollectBusDataServiceImpl", Arrays.asList(saleMineralsCollect.getBusAccount()));
    }

    private void handleSubmitCheck(SaleMineralsCollect saleMineralsCollect, List<SaleMineralsMetal> mineralsMetalList, List<SaleMineralsDetail> mineralsDetailList) {
        mineralsMetalList.forEach(mineralsMetal -> {
            if ("1".equals(mineralsMetal.getMaterialWeight())) {
                String metal = mineralsMetal.getMetal();
                SaleMineralsDetail saleMineralsDetail = mineralsDetailList.stream().filter(x -> metal.equals(x.getMetal())).findAny().orElse(null);
                if (null == saleMineralsDetail) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HWWWWWWWjdVLVWVLDW_ab1ae1ae", (String)"\u91d1\u5c5e[${0}]\u7684\u8be6\u60c5\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\uff01", (String[])new String[]{metal}));
                }
            }
        });
        List mineralsSmelterList = this.invokeBaseRpcService.queryDictItemsByCode("mineralsSmelter", saleMineralsCollect.getToElsAccount());
        mineralsDetailList.forEach(mineralsDetail -> {
            DictDTO smelterInfo = mineralsSmelterList.stream().filter(x -> mineralsDetail.getMetal().equals(x.getText()) && mineralsDetail.getSmelterIdentificationCo().equals(x.getDescription())).findAny().orElse(null);
            if (null == smelterInfo) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HWncAAnAoWWWWWWxMKW_163c73dd", (String)"\u91d1\u5c5e\u548c\u51b6\u70bc\u5382ID[${0}]\u4e0d\u5b58\u5728\uff01", (String[])new String[]{mineralsDetail.getMetal() + "_" + mineralsDetail.getSmelterIdentificationCo()}));
            }
        });
    }

    private void handleAttachmentSubmit(SaleMineralsCollect saleMineralsCollect, List<SaleAttachmentDTO> attachmentList) {
        ArrayList<PurchaseAttachmentDTO> purchaseAttachmentList = new ArrayList<PurchaseAttachmentDTO>();
        String purHeadId = saleMineralsCollect.getRelationId();
        String saleElsAccount = saleMineralsCollect.getElsAccount();
        String purchaseAccount = saleMineralsCollect.getToElsAccount();
        for (SaleAttachmentDTO item : attachmentList) {
            if (purchaseAccount.equals(item.getUploadElsAccount())) continue;
            PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)item, (Object)purchaseAttachment);
            item.setSendStatus("1");
            purchaseAttachment.setId(null);
            purchaseAttachment.setElsAccount(saleMineralsCollect.getToElsAccount());
            purchaseAttachment.setHeadId(purHeadId);
            purchaseAttachmentList.add(purchaseAttachment);
        }
        if (!purchaseAttachmentList.isEmpty()) {
            List purAttachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purHeadId);
            List purAttachmentIds = purAttachments.stream().filter(x -> saleElsAccount.equals(x.getUploadElsAccount())).map(BaseDTO::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(purAttachmentIds)) {
                this.invokeBaseRpcService.deletePurchaseAttachmentByBatchId(purAttachmentIds);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }
}

