/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.siteInspection.entity.ElsInspectionPlanHead;
import com.els.modules.siteInspection.entity.ElsInspectionPlanItem;
import com.els.modules.siteInspection.job.utils.ElsInspectionPlanJobUtil;
import com.els.modules.siteInspection.service.ElsInspectionPlanHeadService;
import com.els.modules.siteInspection.service.ElsInspectionPlanItemService;
import com.els.modules.siteInspection.vo.ElsInspectionPlanHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="inspectionPlanAdapter")
public class ElsInspectionPlanAdapter
implements AuditOptCallBackService {
    @Resource
    private ElsInspectionPlanHeadService elsInspectionPlanHeadService;
    @Resource
    private ElsInspectionPlanItemService elsInspectionPlanItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        String param = StringUtils.isEmpty((Object)inputParamDTO.getParams()) ? "{}" : inputParamDTO.getParams();
        ElsInspectionPlanHeadVO headVO = (ElsInspectionPlanHeadVO)((Object)JSONObject.parseObject((String)param, ElsInspectionPlanHeadVO.class));
        headVO.setWorkFlowType(outputParamDTO.getBpmnType());
        headVO.setResultAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        headVO.setResultFlowId(outputParamDTO.getProcessRootId());
        this.elsInspectionPlanHeadService.updateById((Object)headVO);
        Object operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
            operataion = outputParamDTO.getBpmnType() + "_submitAudit";
        }
        this.sendMsg(inputParamDTO, outputParamDTO, (String)operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        ElsInspectionPlanHead head = (ElsInspectionPlanHead)((Object)this.elsInspectionPlanHeadService.getById((Serializable)((Object)inputParamDTO.getBusinessId())));
        head.setResultAuditStatus(outputParamDTO.getAuditStatus());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            head.setStatus("1");
        }
        this.elsInspectionPlanHeadService.updateById((Object)head);
        ElsInspectionPlanHead planHead = (ElsInspectionPlanHead)((Object)this.elsInspectionPlanHeadService.getById((Serializable)((Object)head.getId())));
        if ("1".equals(planHead.getCreateMethod())) {
            ElsInspectionPlanJobUtil.createJob(planHead, planHead.getAutoExecuteDate());
        }
        this.sendMsg(inputParamDTO, outputParamDTO, "auditPass");
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
        this.sendMsg(inputParamDTO, outputParamDTO, "auditReject");
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().set(ElsInspectionPlanHead::getResultAuditStatus, (Object)outputParamDTO.getAuditStatus());
        updateWrapper.lambda().eq(BaseEntity::getId, (Object)inputParamDTO.getBusinessId());
        this.elsInspectionPlanHeadService.update((Wrapper)updateWrapper);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
    }

    public JSONObject getDataById(String id) {
        ElsInspectionPlanHead head = (ElsInspectionPlanHead)((Object)this.elsInspectionPlanHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"inspectionPlan", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"inspectionPlan", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        ElsInspectionPlanHead head = (ElsInspectionPlanHead)((Object)this.elsInspectionPlanHeadService.getById((Serializable)((Object)headId)));
        ElsInspectionPlanHeadVO headVO = new ElsInspectionPlanHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<ElsInspectionPlanItem> itemList = this.elsInspectionPlanItemService.selectByMainId(headId);
        headVO.setInspectionPlanItemList(itemList);
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

