/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.service.impl;

import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.mould.entity.PurchaseMouldTransferHead;
import com.els.modules.mould.entity.PurchaseMouldTransferItem;
import com.els.modules.mould.entity.SaleMouldTransferHead;
import com.els.modules.mould.entity.SaleMouldTransferItem;
import com.els.modules.mould.enumerate.TransferStatusEnum;
import com.els.modules.mould.mapper.SaleMouldTransferHeadMapper;
import com.els.modules.mould.service.PurchaseMouldDataService;
import com.els.modules.mould.service.PurchaseMouldTransferHeadService;
import com.els.modules.mould.service.PurchaseMouldTransferItemService;
import com.els.modules.mould.service.SaleMouldTransferHeadService;
import com.els.modules.mould.service.SaleMouldTransferItemService;
import com.els.modules.mould.service.impl.PurchaseMouldTransferHeadServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleMouldTransferHeadServiceImpl
extends BaseServiceImpl<SaleMouldTransferHeadMapper, SaleMouldTransferHead>
implements SaleMouldTransferHeadService {
    @Autowired
    private SaleMouldTransferItemService saleMouldTransferItemService;
    @Autowired
    private PurchaseMouldTransferItemService purchaseMouldTransferItemService;
    @Autowired
    private PurchaseMouldDataService purchaseMouldDataService;

    @Override
    public void add(PurchaseMouldTransferHead purchaseHead, List<PurchaseMouldTransferItem> purchaseItemList) {
        ArrayList<SaleMouldTransferHead> insertHeadList = new ArrayList<SaleMouldTransferHead>(2);
        SaleMouldTransferHead sendHead = new SaleMouldTransferHead();
        BeanUtils.copyProperties((Object)((Object)purchaseHead), (Object)((Object)sendHead));
        sendHead.setId(purchaseHead.getSendId());
        sendHead.setRelationId(purchaseHead.getId());
        sendHead.setElsAccount(purchaseHead.getSendElsAccount());
        sendHead.setToElsAccount(purchaseHead.getElsAccount());
        insertHeadList.add(sendHead);
        SaleMouldTransferHead receiveHead = new SaleMouldTransferHead();
        BeanUtils.copyProperties((Object)((Object)purchaseHead), (Object)((Object)receiveHead));
        receiveHead.setId(purchaseHead.getReceiveId());
        receiveHead.setRelationId(purchaseHead.getId());
        receiveHead.setElsAccount(purchaseHead.getReceiveElsAccount());
        receiveHead.setToElsAccount(purchaseHead.getElsAccount());
        insertHeadList.add(receiveHead);
        this.saveBatch(insertHeadList);
        ArrayList<SaleMouldTransferItem> insertItemList = new ArrayList<SaleMouldTransferItem>(purchaseItemList.size() * 2);
        for (PurchaseMouldTransferItem item : purchaseItemList) {
            SaleMouldTransferItem sendItem = new SaleMouldTransferItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)sendItem));
            sendItem.setId(item.getSendItemId());
            sendItem.setRelationId(item.getId());
            sendItem.setHeadId(sendHead.getId());
            sendItem.setElsAccount(sendHead.getElsAccount());
            sendItem.setToElsAccount(sendHead.getToElsAccount());
            insertItemList.add(sendItem);
        }
        for (PurchaseMouldTransferItem item : purchaseItemList) {
            SaleMouldTransferItem receiveItem = new SaleMouldTransferItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)receiveItem));
            receiveItem.setId(item.getReceiveItemId());
            receiveItem.setRelationId(item.getId());
            receiveItem.setHeadId(receiveHead.getId());
            receiveItem.setElsAccount(receiveHead.getElsAccount());
            receiveItem.setToElsAccount(receiveHead.getToElsAccount());
            insertItemList.add(receiveItem);
        }
        this.saleMouldTransferItemService.saveBatch(insertItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirm(SaleMouldTransferHead head, List<SaleMouldTransferItem> itemList) {
        SaleMouldTransferHead dbHead = (SaleMouldTransferHead)((Object)this.getById((Serializable)((Object)head.getId())));
        boolean receiveFlag = dbHead.getId().equals(dbHead.getReceiveId());
        itemList.forEach(item -> {
            boolean flag = receiveFlag ? TransferStatusEnum.WAIT_RECEIVE_CONFIRM.getValue().equals(item.getItemStatus()) : TransferStatusEnum.WAIT_SEND_CONFIRM.getValue().equals(item.getItemStatus());
            String message = receiveFlag ? I18nUtil.translate((String)"i18n_alert_ylCRqtkoylCRLjcWF_e2f1b2db", (String)"\u63a5\u6536\u65b9\u53ea\u53ef\u64cd\u4f5c\u5f85\u63a5\u6536\u65b9\u786e\u8ba4\u7684\u884c\u6570\u636e") : I18nUtil.translate((String)"i18n_alert_hGCRqtkohGCRLjcWF_965430ab", (String)"\u53d1\u51fa\u65b9\u53ea\u53ef\u64cd\u4f5c\u5f85\u53d1\u51fa\u65b9\u786e\u8ba4\u7684\u884c\u6570\u636e");
            Assert.isTrue((boolean)flag, (String)message);
        });
        String itemStatus = receiveFlag ? TransferStatusEnum.CONFIRMED.getValue() : TransferStatusEnum.WAIT_RECEIVE_CONFIRM.getValue();
        Date now = new Date();
        ArrayList<SaleMouldTransferItem> updateList = new ArrayList<SaleMouldTransferItem>();
        ArrayList<PurchaseMouldTransferItem> updatePurchaseList = new ArrayList<PurchaseMouldTransferItem>();
        for (SaleMouldTransferItem item2 : itemList) {
            item2.setItemStatus(itemStatus);
            item2.setPracticalReceiveTime(receiveFlag ? now : null);
            item2.setPracticalSendTime(receiveFlag ? null : now);
            SaleMouldTransferItem currentItem = new SaleMouldTransferItem();
            currentItem.setId(item2.getId());
            currentItem.setItemStatus(item2.getItemStatus());
            currentItem.setPracticalReceiveTime(item2.getPracticalReceiveTime());
            currentItem.setPracticalSendTime(item2.getPracticalSendTime());
            updateList.add(currentItem);
            SaleMouldTransferItem otherItem = new SaleMouldTransferItem();
            otherItem.setId(receiveFlag ? item2.getSendItemId() : item2.getReceiveItemId());
            otherItem.setItemStatus(item2.getItemStatus());
            otherItem.setPracticalReceiveTime(item2.getPracticalReceiveTime());
            otherItem.setPracticalSendTime(item2.getPracticalSendTime());
            updateList.add(otherItem);
            PurchaseMouldTransferItem purchaseItem = new PurchaseMouldTransferItem();
            purchaseItem.setId(item2.getRelationId());
            purchaseItem.setItemStatus(item2.getItemStatus());
            purchaseItem.setPracticalReceiveTime(item2.getPracticalReceiveTime());
            purchaseItem.setPracticalSendTime(item2.getPracticalSendTime());
            updatePurchaseList.add(purchaseItem);
        }
        this.saleMouldTransferItemService.updateBatchById(updateList);
        this.purchaseMouldTransferItemService.updateBatchById(updatePurchaseList);
        this.purchaseMouldDataService.transfer(dbHead, itemList);
        if (receiveFlag) {
            this.confirmHead(dbHead);
        }
    }

    private void confirmHead(SaleMouldTransferHead dbHead) {
        List<PurchaseMouldTransferItem> dbItemList = this.purchaseMouldTransferItemService.selectByMainId(dbHead.getRelationId());
        List confirmedList = dbItemList.stream().filter(item -> TransferStatusEnum.CONFIRMED.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        if (dbItemList.size() == confirmedList.size()) {
            ArrayList<SaleMouldTransferHead> updateHeadList = new ArrayList<SaleMouldTransferHead>();
            SaleMouldTransferHead receiveUpdate = new SaleMouldTransferHead();
            receiveUpdate.setId(dbHead.getId());
            receiveUpdate.setTransferStatus(TransferStatusEnum.CONFIRMED.getValue());
            updateHeadList.add(receiveUpdate);
            SaleMouldTransferHead sendUpdate = new SaleMouldTransferHead();
            sendUpdate.setId(dbHead.getSendId());
            sendUpdate.setTransferStatus(TransferStatusEnum.CONFIRMED.getValue());
            updateHeadList.add(sendUpdate);
            this.updateBatchById(updateHeadList);
            PurchaseMouldTransferHead purchaseHead = new PurchaseMouldTransferHead();
            purchaseHead.setId(dbHead.getRelationId());
            purchaseHead.setTransferStatus(TransferStatusEnum.CONFIRMED.getValue());
            PurchaseMouldTransferHeadService purchaseMouldTransferHeadService = (PurchaseMouldTransferHeadService)SpringContextUtils.getBean(PurchaseMouldTransferHeadServiceImpl.class);
            purchaseMouldTransferHeadService.updateById((Object)purchaseHead);
        }
    }
}

