/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ecn.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.ecn.entity.EcnBuyerList;
import com.els.modules.ecn.entity.EcnOrderDetail;
import com.els.modules.ecn.entity.EcnSupplierList;
import com.els.modules.ecn.entity.PurchaseEcn;
import com.els.modules.ecn.entity.SaleEcn;
import com.els.modules.ecn.entity.SaleEcnOrderDetail;
import com.els.modules.ecn.enumerate.EcnStatusEnum;
import com.els.modules.ecn.mapper.EcnBuyerListMapper;
import com.els.modules.ecn.mapper.EcnOrderDetailMapper;
import com.els.modules.ecn.mapper.EcnSupplierListMapper;
import com.els.modules.ecn.mapper.PurchaseEcnMapper;
import com.els.modules.ecn.rpc.service.EcnInvokeAccountRpcService;
import com.els.modules.ecn.rpc.service.EcnInvokeBaseRpcService;
import com.els.modules.ecn.rpc.service.EcnInvokeMainDataRpcService;
import com.els.modules.ecn.service.EcnBuyerListService;
import com.els.modules.ecn.service.EcnOrderDetailService;
import com.els.modules.ecn.service.EcnSupplierListService;
import com.els.modules.ecn.service.PurchaseEcnService;
import com.els.modules.ecn.service.SaleEcnService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEcnServiceImpl
extends BaseServiceImpl<PurchaseEcnMapper, PurchaseEcn>
implements PurchaseEcnService {
    @Resource
    private PurchaseEcnMapper purchaseEcnMapper;
    @Resource
    private EcnSupplierListMapper ecnSupplierListMapper;
    @Resource
    private EcnSupplierListService ecnSupplierListService;
    @Resource
    private EcnBuyerListMapper ecnBuyerListMapper;
    @Resource
    private EcnBuyerListService ecnBuyerListService;
    @Resource
    private EcnInvokeBaseRpcService ecnInvokeBaseRpcService;
    @Resource
    private EcnInvokeAccountRpcService ecnInvokeAccountRpcService;
    @Resource
    private EcnInvokeMainDataRpcService ecnInvokeMainDataRpcService;
    @Autowired
    private SaleEcnService saleEcnService;
    @Resource
    private EcnOrderDetailMapper ecnOrderDetailMapper;
    @Resource
    private EcnOrderDetailService ecnOrderDetailService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_ecn_";
    private static final Long LOCK_EXPIRE_TIME = 120000L;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseEcn saveMain(PurchaseEcn purchaseEcn, List<EcnSupplierList> ecnSupplierListList, List<EcnBuyerList> ecnBuyerListList, List<EcnOrderDetail> orderDetails) {
        purchaseEcn.setEcnNumber(this.ecnInvokeBaseRpcService.getNextCode("srmECNNumber", (Object)purchaseEcn));
        purchaseEcn.setChangeApplyTime(new Date());
        purchaseEcn.setPurchaseName(SysUtil.getLoginUser().getCompanyName());
        purchaseEcn.setEcnStatus(StrUtil.isNotBlank((CharSequence)purchaseEcn.getEcnStatus()) ? purchaseEcn.getEcnStatus() : "0");
        if ("0".equals(purchaseEcn.getNeedApprove())) {
            purchaseEcn.setAuditStatus(StrUtil.isNotBlank((CharSequence)purchaseEcn.getAuditStatus()) ? purchaseEcn.getAuditStatus() : "4");
        } else {
            purchaseEcn.setAuditStatus(StrUtil.isNotBlank((CharSequence)purchaseEcn.getAuditStatus()) ? purchaseEcn.getAuditStatus() : "0");
        }
        this.purchaseEcnMapper.insert((Object)purchaseEcn);
        this.insertData(purchaseEcn, ecnSupplierListList, ecnBuyerListList, orderDetails);
        return purchaseEcn;
    }

    @Override
    public void copyById(String id) {
        List<EcnOrderDetail> orderDetails;
        List<EcnBuyerList> ecnBuyerListList;
        PurchaseEcn purchaseEcn = (PurchaseEcn)((Object)this.getById((Serializable)((Object)id)));
        purchaseEcn.setId(null);
        purchaseEcn.setChangeApplyTime(null);
        purchaseEcn.setEcnNumber(null);
        purchaseEcn.setEcnStatus(null);
        purchaseEcn.setAuditStatus(null);
        purchaseEcn.setSendStatus("0");
        purchaseEcn.setFlowId(null);
        purchaseEcn.setWorkFlowType(null);
        purchaseEcn.setElsAccount(TenantContext.getTenant());
        purchaseEcn.setCreateBy(SysUtil.getLoginUser().getSubAccount());
        purchaseEcn.setCreateById(SysUtil.getLoginUser().getId());
        purchaseEcn.setCreateTime(null);
        purchaseEcn.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
        purchaseEcn.setUpdateById(SysUtil.getLoginUser().getId());
        purchaseEcn.setUpdateTime(null);
        List<EcnSupplierList> ecnSupplierListList = this.ecnSupplierListMapper.selectByMainId(id);
        if (CollUtil.isNotEmpty(ecnSupplierListList)) {
            ecnSupplierListList.forEach(x -> {
                x.setId(null);
                x.setHeadId(null);
                x.setElsAccount(null);
                x.setCreateBy(null);
                x.setCreateTime(null);
                x.setUpdateBy(null);
                x.setUpdateTime(null);
            });
        }
        if (CollUtil.isNotEmpty(ecnBuyerListList = this.ecnBuyerListMapper.selectByMainId(id))) {
            ecnBuyerListList.forEach(x -> {
                x.setId(null);
                x.setHeadId(null);
                x.setElsAccount(null);
                x.setCreateBy(null);
                x.setCreateTime(null);
                x.setUpdateBy(null);
                x.setUpdateTime(null);
            });
        }
        if (CollUtil.isNotEmpty(orderDetails = this.ecnOrderDetailMapper.selectByMainId(id))) {
            orderDetails.forEach(x -> {
                x.setId(null);
                x.setHeadId(null);
                x.setElsAccount(null);
                x.setCreateBy(null);
                x.setCreateTime(null);
                x.setUpdateBy(null);
                x.setUpdateTime(null);
            });
        }
        this.saveMain(purchaseEcn, ecnSupplierListList, ecnBuyerListList, orderDetails);
        List<PurchaseAttachmentDTO> attachments = this.ecnInvokeBaseRpcService.purcahseSelectByMainId(id);
        if (CollUtil.isNotEmpty(attachments)) {
            attachments.forEach(x -> {
                x.setId(null);
                x.setHeadId(purchaseEcn.getId());
                x.setElsAccount(null);
                x.setCreateBy(null);
                x.setCreateTime(null);
                x.setUpdateBy(null);
                x.setUpdateTime(null);
            });
            this.ecnInvokeBaseRpcService.insertPurchaseBatchSomeColumn(attachments);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseEcn purchaseEcn, List<EcnSupplierList> ecnSupplierListList, List<EcnBuyerList> ecnBuyerListList, List<EcnOrderDetail> orderDetails) {
        try {
            PurchaseOrganizationInfoDTO organizationInfo;
            if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, purchaseEcn.getId(), LOCK_EXPIRE_TIME.longValue())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VxPVBRc_28032791", (String)"\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c\uff01"));
            }
            if ("0".equals(purchaseEcn.getNeedApprove())) {
                purchaseEcn.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
            ElsSubAccountDTO subAccount = null;
            if (purchaseEcn.getApplyPerson() != null && StrUtil.isNotBlank((CharSequence)purchaseEcn.getApplyPerson())) {
                subAccount = this.ecnInvokeAccountRpcService.getAccount(purchaseEcn.getElsAccount(), purchaseEcn.getApplyPerson().split("_")[0]);
            }
            if (subAccount != null && StrUtil.isNotBlank((CharSequence)subAccount.getOrgCode()) && (organizationInfo = this.ecnInvokeMainDataRpcService.selectById(subAccount.getOrgCode())) != null) {
                purchaseEcn.setApplyDept(organizationInfo.getOrgCode() + "_" + organizationInfo.getOrgName());
            }
            if (!ecnSupplierListList.isEmpty()) {
                purchaseEcn.setSupplierExist("1");
            }
            if (!ecnBuyerListList.isEmpty()) {
                purchaseEcn.setBuyerExist("1");
            }
            this.purchaseEcnMapper.updateById((Object)purchaseEcn);
            this.ecnSupplierListMapper.deleteByMainId(purchaseEcn.getId());
            this.ecnBuyerListMapper.deleteByMainId(purchaseEcn.getId());
            this.ecnOrderDetailMapper.deleteByMainId(purchaseEcn.getId());
            this.insertData(purchaseEcn, ecnSupplierListList, ecnBuyerListList, orderDetails);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, purchaseEcn.getId());
        }
    }

    private void insertData(PurchaseEcn purchaseEcn, List<EcnSupplierList> ecnSupplierListList, List<EcnBuyerList> ecnBuyerListList, List<EcnOrderDetail> orderDetails) {
        if (ecnSupplierListList != null) {
            for (EcnSupplierList ecnSupplierList : ecnSupplierListList) {
                ecnSupplierList.setHeadId(purchaseEcn.getId());
                SysUtil.setSysParam((BaseEntity)ecnSupplierList, (BaseEntity)purchaseEcn);
                ecnSupplierList.setViewStatus("0");
            }
            if (!ecnSupplierListList.isEmpty()) {
                this.ecnSupplierListService.saveBatch(ecnSupplierListList);
            }
        }
        if (ecnBuyerListList != null) {
            for (EcnBuyerList ecnBuyerList : ecnBuyerListList) {
                ecnBuyerList.setHeadId(purchaseEcn.getId());
                SysUtil.setSysParam((BaseEntity)ecnBuyerList, (BaseEntity)purchaseEcn);
            }
            if (!ecnBuyerListList.isEmpty()) {
                this.ecnBuyerListService.saveBatch(ecnBuyerListList);
            }
        }
        if (orderDetails != null) {
            for (EcnOrderDetail ecnOrderDetail : orderDetails) {
                ecnOrderDetail.setHeadId(purchaseEcn.getId());
                SysUtil.setSysParam((BaseEntity)ecnOrderDetail, (BaseEntity)purchaseEcn);
                ecnOrderDetail.setDeleted(CommonConstant.DEL_FLAG_0);
                ecnOrderDetail.setId(null);
            }
            if (!orderDetails.isEmpty()) {
                this.ecnOrderDetailService.saveBatch(orderDetails);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        PurchaseEcn head = (PurchaseEcn)((Object)this.getById((Serializable)((Object)id)));
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(head.getAuditStatus()) || AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UzsSUzeRjtFqQG_908d607c", (String)"\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u4e0d\u53ef\u5220\u9664"));
        }
        this.ecnSupplierListMapper.deleteByMainId(id);
        this.ecnBuyerListMapper.deleteByMainId(id);
        this.purchaseEcnMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.ecnSupplierListMapper.deleteByMainId(serializable.toString());
            this.ecnBuyerListMapper.deleteByMainId(serializable.toString());
            this.purchaseEcnMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishSuppliers(PurchaseEcn purchaseEcn, List<EcnSupplierList> ecnSupplierListList, List<PurchaseAttachmentDTO> attachments, List<EcnOrderDetail> orderDetails) {
        purchaseEcn.setSendStatus("1");
        purchaseEcn.setEcnStatus(EcnStatusEnum.NORMAL.getValue());
        SaleEcn ecn = new SaleEcn();
        BeanUtils.copyProperties((Object)((Object)purchaseEcn), (Object)((Object)ecn));
        for (EcnSupplierList supplier : ecnSupplierListList) {
            ecn.setId(null);
            ecn.setRelationId(purchaseEcn.getId());
            ecn.setElsAccount(supplier.getToElsAccount());
            ecn.setToElsAccount(purchaseEcn.getElsAccount());
            ecn.setSupplierName(supplier.getSupplierName());
            ecn.setViewStatus("0");
            ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
            AttachmentSendDTO sendDTO = new AttachmentSendDTO();
            if (attachments != null) {
                sendDTO.setHeadId(purchaseEcn.getId());
                sendDTO.setElsAccount(purchaseEcn.getElsAccount());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(purchaseEcn.getId(), ecn.getElsAccount());
                sendDTO.setToSend(map);
            }
            ArrayList<SaleEcnOrderDetail> saleEcnOrderDetails = null;
            if (orderDetails != null) {
                saleEcnOrderDetails = new ArrayList<SaleEcnOrderDetail>();
                for (EcnOrderDetail detail : orderDetails) {
                    if (!supplier.getToElsAccount().equals(detail.getToElsAccount())) continue;
                    SaleEcnOrderDetail saleEcnOrderDetail = new SaleEcnOrderDetail();
                    BeanUtils.copyProperties((Object)((Object)detail), (Object)((Object)saleEcnOrderDetail));
                    saleEcnOrderDetail.setElsAccount(supplier.getToElsAccount());
                    saleEcnOrderDetail.setToElsAccount(purchaseEcn.getElsAccount());
                    saleEcnOrderDetail.setId(null);
                    saleEcnOrderDetail.setBusAccount(purchaseEcn.getElsAccount());
                    saleEcnOrderDetail.setPurchaseName(purchaseEcn.getPurchaseName());
                    saleEcnOrderDetails.add(saleEcnOrderDetail);
                }
            }
            Map toSend = sendDTO.getToSend() == null ? new ConcurrentHashMap() : sendDTO.getToSend();
            for (String saleHeadId : toSend.keySet()) {
                String saleElsAccount = (String)toSend.get(saleHeadId);
                for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
                    SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
                    BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
                    saleAttachment.setId(IdWorker.getIdStr());
                    saleAttachment.setElsAccount(saleElsAccount);
                    saleAttachment.setRelationId(purchaseAttachment.getId());
                    saleAttachments.add(saleAttachment);
                }
            }
            this.saleEcnService.saveSaleEcn(ecn, saleAttachments, saleEcnOrderDetails);
            if (StrUtil.isNotBlank((CharSequence)supplier.getSubAccount())) {
                super.sendMessage(TenantContext.getTenant(), "ecn", "publish", purchaseEcn.getId(), "purchaseEcnBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{supplier.getToElsAccount()}));
                continue;
            }
            super.sendMessage(TenantContext.getTenant(), "ecn", "publish", purchaseEcn.getId(), "purchaseEcnBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{supplier.getToElsAccount()}));
        }
        this.updateById((Object)purchaseEcn);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishBuyer(PurchaseEcn purchaseEcn, List<EcnBuyerList> buyerLists) {
        for (EcnBuyerList ecnBuyerList : buyerLists) {
            ElsSubAccountDTO account = this.ecnInvokeAccountRpcService.getAccount(ecnBuyerList.getElsAccount(), ecnBuyerList.getSubAccount());
            super.sendMessage(TenantContext.getTenant(), "ecn", "change", purchaseEcn.getId(), "purchaseEcnBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{account.getElsAccount()}));
        }
        purchaseEcn.setInformBuyer("1");
        this.updateById((Object)purchaseEcn);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void backout(String id) {
        PurchaseEcn ecn = (PurchaseEcn)((Object)this.getById((Serializable)((Object)id)));
        ecn.setSendStatus("0");
        ecn.setInformBuyer("0");
        this.updateById((Object)ecn);
        this.saleEcnService.delBatchByRelationId(id);
        List<EcnSupplierList> supplierLists = this.ecnSupplierListMapper.selectByMainId(id);
        if (!supplierLists.isEmpty()) {
            ArrayList<String> receiveAccount = new ArrayList<String>();
            for (EcnSupplierList ecnSupplierList : supplierLists) {
                receiveAccount.add(ecnSupplierList.getToElsAccount());
            }
            super.sendMessage(TenantContext.getTenant(), "ecn", "back", ecn.getId(), "purchaseEcnBusDataServiceImpl", receiveAccount);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancellation(String id) {
        List<EcnSupplierList> supplierLists;
        PurchaseEcn ecn = (PurchaseEcn)((Object)this.getById((Serializable)((Object)id)));
        ecn.setEcnStatus(EcnStatusEnum.CANCELLATION.getValue());
        this.updateById((Object)ecn);
        if ("1".equals(ecn.getSendStatus()) && !(supplierLists = this.ecnSupplierListMapper.selectByMainId(id)).isEmpty()) {
            ArrayList<String> receiveAccount = new ArrayList<String>();
            for (EcnSupplierList ecnSupplierList : supplierLists) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleEcnService.lambdaUpdate().eq(SaleEcn::getRelationId, (Object)id)).eq(SaleEcn::getToElsAccount, (Object)ecn.getElsAccount())).eq(BaseEntity::getElsAccount, (Object)ecnSupplierList.getToElsAccount())).set(SaleEcn::getEcnStatus, (Object)EcnStatusEnum.CANCELLATION.getValue())).update((Object)new SaleEcn());
                receiveAccount.add(ecnSupplierList.getToElsAccount());
            }
            super.sendMessage(TenantContext.getTenant(), "ecn", "invalid", ecn.getId(), "purchaseEcnBusDataServiceImpl", receiveAccount);
        }
        if ("1".equals(ecn.getInformBuyer())) {
            List<EcnBuyerList> buyerLists = this.ecnBuyerListMapper.selectByMainId(id);
            for (EcnBuyerList ecnBuyerList : buyerLists) {
                ElsSubAccountDTO account = this.ecnInvokeAccountRpcService.getAccount(ecnBuyerList.getElsAccount(), ecnBuyerList.getSubAccount());
                super.sendMessage(TenantContext.getTenant(), "ecn", "invalid", ecn.getId(), "purchaseEcnBusDataServiceImpl", (List)Lists.newArrayList((Object[])new String[]{account.getElsAccount()}));
            }
        }
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getECN", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseEcnList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseEcn purchaseEcn : purchaseEcnList) {
            String elsAccount = TenantContext.getTenant();
            this.interfaceUtil.callInterface(elsAccount, "pushECN", (Object)purchaseEcn);
        }
    }

    @Override
    public JSONObject getPurchaseEcnDataById(String id) {
        PurchaseEcn purchaseEcn = (PurchaseEcn)((Object)this.getById((Serializable)((Object)id)));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)purchaseEcn, new DictTranslateAspectParam());
        return jsonObject;
    }
}

