/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mcd.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.service.SaleAttachmentRpcService;
import com.els.modules.mcd.entity.SaleMcdCollect;
import com.els.modules.mcd.entity.SaleMcdDetail;
import com.els.modules.mcd.service.SaleMcdCollectService;
import com.els.modules.mcd.service.SaleMcdDetailService;
import com.els.modules.mcd.vo.SaleMcdCollectVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mcdcollect/saleMcdCollect"})
@Api(tags={"MCD\u8d44\u6599\u6536\u96c6\u5355"})
public class SaleMcdCollectController
extends BaseController<SaleMcdCollect, SaleMcdCollectService> {
    private static final Logger log = LoggerFactory.getLogger(SaleMcdCollectController.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleMcdCollectService saleMcdCollectService;
    @Autowired
    private SaleMcdDetailService saleMcdDetailService;
    @Autowired
    private SaleAttachmentRpcService saleAttachmentRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"gpmManagement#SaleMcdCollect:list"})
    public Result<?> queryPageList(SaleMcdCollect saleMcdCollect, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleMcdCollect), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleMcdCollectService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="MCD\u8d44\u6599\u6536\u96c6\u5355", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"gpmManagement#SaleMcdCollect:edit"})
    public Result<?> edit(@RequestBody SaleMcdCollectVO saleMcdCollectPage) {
        SaleMcdCollect saleMcdCollect = new SaleMcdCollect();
        BeanUtils.copyProperties((Object)((Object)saleMcdCollectPage), (Object)((Object)saleMcdCollect));
        this.saleMcdCollectService.updateMain(saleMcdCollect, saleMcdCollectPage.getSaleMcdDetailList(), saleMcdCollectPage.getSaleMcdReachList());
        this.saleAttachmentRpcService.deleteByMainId(saleMcdCollect.getId());
        List<SaleAttachmentDTO> saleAttachmentDTOList = saleMcdCollectPage.getSaleMcdCollectAttachmentList();
        if (CollUtil.isNotEmpty(saleAttachmentDTOList)) {
            this.saleAttachmentRpcService.insertBatchSomeColumn(saleAttachmentDTOList);
        }
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"gpmManagement#SaleMcdCollect:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleMcdCollect saleMcdCollect = (SaleMcdCollect)((Object)this.saleMcdCollectService.getById((Serializable)((Object)id)));
        SaleMcdCollectVO saleMcdCollectVO = new SaleMcdCollectVO();
        BeanUtils.copyProperties((Object)((Object)saleMcdCollect), (Object)((Object)saleMcdCollectVO));
        List<SaleMcdDetail> list = this.saleMcdDetailService.selectByMainId(id);
        List<SaleMcdDetail> purchaseMcdReachList = list.stream().filter(e -> new BigDecimal("1000").compareTo(StrUtil.isNotBlank((CharSequence)e.getPpmWeight()) ? NumberUtils.createBigDecimal((String)e.getPpmWeight()) : NumberUtils.createBigDecimal((String)"0")) < 0).collect(Collectors.toList());
        List<String> casnoList = purchaseMcdReachList.stream().map(SaleMcdDetail::getCasno).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(casnoList)) {
            List<String> reachList = this.saleMcdDetailService.selectSystemReachByCasnoList(casnoList);
            purchaseMcdReachList = purchaseMcdReachList.stream().filter(e -> reachList.contains(e.getCasno())).collect(Collectors.toList());
        }
        saleMcdCollectVO.setSaleMcdDetailList(list);
        saleMcdCollectVO.setSaleMcdReachList(purchaseMcdReachList);
        List saleAttachmentDtoList = this.saleAttachmentRpcService.selectByMainId(id);
        saleMcdCollectVO.setSaleMcdCollectAttachmentList(saleAttachmentDtoList);
        return Result.ok((Object)((Object)saleMcdCollectVO));
    }

    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"gpmManagement#SaleMcdCollect:edit"})
    public Result<?> submit(@RequestBody SaleMcdCollectVO saleMcdCollectPage) {
        SaleMcdCollect saleMcdCollect = new SaleMcdCollect();
        BeanUtils.copyProperties((Object)((Object)saleMcdCollectPage), (Object)((Object)saleMcdCollect));
        this.saleAttachmentRpcService.deleteByMainId(saleMcdCollect.getId());
        List<SaleAttachmentDTO> saleAttachmentDTOList = saleMcdCollectPage.getSaleMcdCollectAttachmentList();
        if (CollUtil.isNotEmpty(saleAttachmentDTOList)) {
            this.saleAttachmentRpcService.insertBatchSomeColumn(saleAttachmentDTOList);
        }
        this.saleMcdCollectService.submit(saleMcdCollect, saleMcdCollectPage.getSaleMcdDetailList(), saleMcdCollectPage.getSaleMcdReachList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"gpmManagement#SaleMcdCollect:list"})
    public Result<?> queryTabsCount(SaleMcdCollect saleMcdCollect, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        Map stringMap = req.getParameterMap();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleMcdCollect), (Map)stringMap);
        queryWrapper.select(new String[]{"collect_status"});
        List list = ((SaleMcdCollectService)this.service).list((Wrapper)queryWrapper);
        Integer all = list.size();
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "collectStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("mcdCollectStatus", TenantContext.getTenant());
        for (DictDTO status : srmContractStatus) {
            Integer total = list.stream().filter(pct -> String.valueOf(pct.getCollectStatus()).equals(status.getValue())).collect(Collectors.toList()).size();
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "collectStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

