/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.delivery.enumerate.CheckStatusEnum;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.quality.api.dto.PurchaseQualityCheckItemDTO;
import com.els.modules.quality.entity.PurchaseQualityCheckHead;
import com.els.modules.quality.entity.PurchaseQualityCheckItem;
import com.els.modules.quality.entity.SaleQualityCheckHead;
import com.els.modules.quality.entity.SaleQualityCheckItem;
import com.els.modules.quality.enumerate.CheckSourceTypeEnum;
import com.els.modules.quality.mapper.PurchaseQualityCheckHeadMapper;
import com.els.modules.quality.mapper.PurchaseQualityCheckItemMapper;
import com.els.modules.quality.mapper.SaleQualityCheckHeadMapper;
import com.els.modules.quality.mapper.SaleQualityCheckItemMapper;
import com.els.modules.quality.rpc.service.QualityInvokeMaterialRpcService;
import com.els.modules.quality.rpc.service.QualityInvokeSupplierRpcService;
import com.els.modules.quality.service.PurchaseQualityCheckHeadService;
import com.els.modules.quality.service.PurchaseQualityCheckItemService;
import com.els.modules.quality.service.SaleQualityCheckItemService;
import com.els.modules.quality.vo.PurchaseQualityCheckHeadVO;
import com.els.modules.report.rpc.service.InvokeOrderRpcService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseQualityCheckHeadServiceImpl
extends BaseServiceImpl<PurchaseQualityCheckHeadMapper, PurchaseQualityCheckHead>
implements PurchaseQualityCheckHeadService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseQualityCheckHeadServiceImpl.class);
    @Resource
    private PurchaseQualityCheckHeadMapper purchaseQualityCheckHeadMapper;
    @Resource
    private PurchaseQualityCheckItemMapper purchaseQualityCheckItemMapper;
    @Resource
    private PurchaseQualityCheckItemService purchaseQualityCheckItemService;
    @Resource
    private SaleQualityCheckHeadMapper saleQualityCheckHeadMapper;
    @Resource
    private SaleQualityCheckItemMapper saleQualityCheckItemMapper;
    @Resource
    private SaleQualityCheckItemService saleQualityCheckItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private QualityInvokeSupplierRpcService qualityInvokeSupplierRpcService;
    @Autowired
    private InvokeOrderRpcService invokeOrderRpcService;
    @Autowired
    private QualityInvokeMaterialRpcService purchaseMaterialHeadRpcService;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseQualityCheckHead purchaseQualityCheckHead, List<PurchaseQualityCheckItem> purchaseQualityCheckItemList) {
        if (StrUtil.isBlank((CharSequence)purchaseQualityCheckHead.getCheckStatus())) {
            purchaseQualityCheckHead.setCheckStatus(CheckStatusEnum.NEW.getValue());
        }
        if (StrUtil.isBlank((CharSequence)purchaseQualityCheckHead.getSourceType())) {
            purchaseQualityCheckHead.setSourceType(CheckSourceTypeEnum.MANUAL.getValue());
        }
        purchaseQualityCheckHead.setBusAccount(TenantContext.getTenant());
        if (StrUtil.isBlank((CharSequence)purchaseQualityCheckHead.getCheckNumber())) {
            purchaseQualityCheckHead.setCheckNumber(this.invokeBaseRpcService.getNextCode("srmCheckNumber", (Object)purchaseQualityCheckHead));
        }
        String publishAudit = purchaseQualityCheckHead.getPublishAudit();
        this.setDefualtValue(purchaseQualityCheckHead);
        if (StrUtil.isNotBlank((CharSequence)publishAudit)) {
            purchaseQualityCheckHead.setPublishAudit(publishAudit);
        }
        if ("1".equals(purchaseQualityCheckHead.getPublishAudit())) {
            purchaseQualityCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseQualityCheckHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseQualityCheckHeadMapper.insert((Object)purchaseQualityCheckHead);
        this.insertData(purchaseQualityCheckHead, purchaseQualityCheckItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseQualityCheckHead purchaseQualityCheckHead, List<PurchaseQualityCheckItem> purchaseQualityCheckItemList) {
        String publishAudit = purchaseQualityCheckHead.getPublishAudit();
        if ("1".equals(publishAudit)) {
            purchaseQualityCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseQualityCheckHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseQualityCheckHeadMapper.updateById((Object)purchaseQualityCheckHead);
        this.purchaseQualityCheckItemMapper.deleteByMainId(purchaseQualityCheckHead.getId());
        this.insertData(purchaseQualityCheckHead, purchaseQualityCheckItemList);
    }

    private void insertData(PurchaseQualityCheckHead purchaseQualityCheckHead, List<PurchaseQualityCheckItem> purchaseQualityCheckItemList) {
        if (purchaseQualityCheckItemList != null) {
            for (PurchaseQualityCheckItem entity : purchaseQualityCheckItemList) {
                entity.setHeadId(purchaseQualityCheckHead.getId());
                entity.setId(null);
                entity.setCheckNumber(purchaseQualityCheckHead.getCheckNumber());
                entity.setItemNumber(purchaseQualityCheckHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseQualityCheckHead);
            }
            if (!purchaseQualityCheckItemList.isEmpty()) {
                this.purchaseQualityCheckItemService.saveBatch(purchaseQualityCheckItemList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseQualityCheckItemMapper.deleteByMainId(id);
        this.purchaseQualityCheckHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseQualityCheckItemMapper.deleteByMainId(serializable.toString());
            this.purchaseQualityCheckHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseQualityCheckHead head, List<PurchaseQualityCheckItem> itemList) {
        String resultSyncSupplier;
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        String publishAudit = head.getPublishAudit();
        if ("1".equals(publishAudit) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_auditViaPublish", (String)"\u5ba1\u6279\u901a\u8fc7\u624d\u53ef\u4ee5\u53d1\u5e03\uff01"));
        }
        head.setCheckStatus(CheckStatusEnum.CHECK_DONE.getValue());
        head.setCheckEndDate(new Date());
        this.purchaseQualityCheckHeadMapper.updateById((Object)head);
        PurchaseQualityCheckHead checkHead = (PurchaseQualityCheckHead)((Object)this.purchaseQualityCheckHeadMapper.selectById((Serializable)((Object)head.getId())));
        this.purchaseQualityCheckItemMapper.deleteByMainId(head.getId());
        for (PurchaseQualityCheckItem item : itemList) {
            String decisionConclusion;
            SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            item.setHeadId(head.getId());
            if (StrUtil.isBlank((CharSequence)item.getId())) {
                item.setId(null);
            }
            if ("Accept".equals(decisionConclusion = item.getDecisionConclusion())) {
                item.setTestResult("0");
                JSONObject urlParam = new JSONObject();
                urlParam.put("id", (Object)head.getId());
                urlParam.put("checkNumber", (Object)item.getCheckNumber());
                receiveParamMap.put(head.getElsAccount(), urlParam);
                continue;
            }
            item.setTestResult("1");
        }
        if (itemList != null && !itemList.isEmpty()) {
            this.purchaseQualityCheckItemService.saveBatch(itemList);
        }
        if ("1".equals(resultSyncSupplier = head.getResultSyncSupplier())) {
            SaleQualityCheckHead saleHead = new SaleQualityCheckHead();
            BeanUtil.copyProperties((Object)((Object)head), (Object)((Object)saleHead), (String[])new String[0]);
            saleHead.setId(IdWorker.getIdStr());
            saleHead.setRelationId(head.getId());
            saleHead.setElsAccount(head.getToElsAccount());
            saleHead.setToElsAccount(head.getElsAccount());
            this.saleQualityCheckHeadMapper.insert((Object)saleHead);
            ArrayList<SaleQualityCheckItem> saleItemList = new ArrayList<SaleQualityCheckItem>();
            for (PurchaseQualityCheckItem item : itemList) {
                SaleQualityCheckItem saleItem = new SaleQualityCheckItem();
                BeanUtil.copyProperties((Object)((Object)item), (Object)((Object)saleItem), (String[])new String[0]);
                saleItem.setId(null);
                saleItem.setHeadId(saleHead.getId());
                saleItem.setRelationId(item.getId());
                saleItem.setCheckNumber(saleHead.getCheckNumber());
                saleItem.setItemNumber(saleHead.getId());
                saleItem.setElsAccount(saleHead.getElsAccount());
                saleItemList.add(saleItem);
            }
            if (!saleItemList.isEmpty()) {
                this.saleQualityCheckItemService.saveBatch(saleItemList);
            }
            PurchaseQualityCheckHead updateHead = new PurchaseQualityCheckHead();
            updateHead.setId(head.getId());
            updateHead.setSendStatus("1");
            updateHead.setRelationId(saleHead.getId());
            this.purchaseQualityCheckHeadMapper.updateById((Object)updateHead);
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setHeadId(head.getId());
            sendVO.setElsAccount(head.getElsAccount());
            HashMap<String, String> toSend = new HashMap<String, String>();
            String id = saleHead.getElsAccount();
            String id2 = saleHead.getId();
            toSend.put(id2, id);
            sendVO.setToSend(toSend);
            this.invokeBaseRpcService.sendPurchaseFile(sendVO, true);
            super.sendMessage(head.getBusAccount(), "qualityCheck", "publish", head.getId(), "purchaseQualityCheckBusDataServiceImpl", Arrays.asList(head.getToElsAccount()));
        }
        if (checkHead.getSourceType().equals(CheckSourceTypeEnum.DELIVERY_VOUCHER.getValue())) {
            this.invokeOrderRpcService.createChargeAgainstByQuality(SysUtil.copyProperties(itemList, PurchaseQualityCheckItemDTO.class));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(PurchaseQualityCheckHead head, List<PurchaseQualityCheckItem> itemList) {
        head.setCheckStatus(CheckStatusEnum.CHECK_ING.getValue());
        String publishAudit = head.getPublishAudit();
        if ("1".equals(publishAudit)) {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseQualityCheckHeadMapper.updateById((Object)head);
        this.purchaseQualityCheckItemMapper.deleteByMainId(head.getId());
        for (PurchaseQualityCheckItem item : itemList) {
            SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            item.setHeadId(head.getId());
            item.setId(null);
            item.setItemNumber(head.getId());
            item.setCheckNumber(head.getCheckNumber());
        }
        if (itemList != null && !itemList.isEmpty()) {
            this.purchaseQualityCheckItemService.saveBatch(itemList);
        }
    }

    private void setDefualtValue(PurchaseQualityCheckHead head) {
        Map defualtMap = this.invokeBaseRpcService.getHeadDefaultValuetMap(head.getTemplateAccount(), head.getTemplateNumber(), "" + head.getTemplateVersion());
        HashMap<String, String> defaultMap1 = new HashMap<String, String>();
        Set keys = defualtMap.keySet();
        if (CollectionUtil.isNotEmpty(keys)) {
            for (String key : keys) {
                if (!StrUtil.isNotBlank((CharSequence)((CharSequence)defualtMap.get(key)))) continue;
                defaultMap1.put(key, (String)defualtMap.get(key));
            }
        }
        BeanUtil.copyProperties(defaultMap1, (Object)((Object)head), (String[])new String[0]);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseQualityCheckHead publishCheck(PurchaseQualityCheckHead head, List<PurchaseQualityCheckItem> itemList) {
        List list = this.invokeBaseRpcService.getDefaultTemplateByType("qualityCheck");
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_businessTemplate", (String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        TemplateHeadDTO templateHead = (TemplateHeadDTO)list.get(0);
        head.setTemplateName(templateHead.getTemplateName());
        head.setTemplateNumber(templateHead.getTemplateNumber());
        head.setTemplateVersion(templateHead.getTemplateVersion());
        head.setTemplateAccount(templateHead.getElsAccount());
        this.setDefualtValue(head);
        head.setCheckStatus(CheckStatusEnum.CHECK_ING.getValue());
        head.setBusAccount(TenantContext.getTenant());
        head.setCheckNumber(this.invokeBaseRpcService.getNextCode("srmCheckNumber", (Object)head));
        head.setSourceType(CheckSourceTypeEnum.DELIVERY_VOUCHER.getValue());
        String publishAudit = head.getPublishAudit();
        if ("1".equals(publishAudit)) {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseQualityCheckHeadMapper.insert((Object)head);
        this.insertData(head, itemList);
        return head;
    }

    @Override
    public PurchaseQualityCheckHeadVO createQuality(List<PurchaseVoucherItemDTO> voucherItems) {
        if (CollectionUtil.isEmpty(voucherItems)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_voucherLine", (String)"\u51ed\u8bc1\u884c\u4e3a\u7a7a"));
        }
        log.info("\u6267\u884ccreateQuality\u65b9\u6cd5");
        PurchaseVoucherItemDTO purchaseVoucherItem = voucherItems.get(0);
        String toElsAccount = purchaseVoucherItem.getToElsAccount();
        String company = purchaseVoucherItem.getCompany();
        String purchaseOrg = purchaseVoucherItem.getPurchaseOrg();
        String purchaseGroup = purchaseVoucherItem.getPurchaseGroup();
        String factory = purchaseVoucherItem.getFactory();
        String storageLocation = purchaseVoucherItem.getStorageLocation();
        String srmReceiptNumber = purchaseVoucherItem.getVoucherNumber();
        BigDecimal quantity = purchaseVoucherItem.getQuantity();
        SupplierMasterDataDTO masterData = this.qualityInvokeSupplierRpcService.getByAccount(TenantContext.getTenant(), toElsAccount);
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        PurchaseQualityCheckHead purchaseQualityCheckHead = new PurchaseQualityCheckHead();
        purchaseQualityCheckHead.setBusAccount(TenantContext.getTenant());
        purchaseQualityCheckHead.setPurchaseName(loginUser.getCompanyName());
        purchaseQualityCheckHead.setSourceType(CheckSourceTypeEnum.DELIVERY_VOUCHER.getValue());
        purchaseQualityCheckHead.setToElsAccount(toElsAccount);
        purchaseQualityCheckHead.setSupplierCode(masterData.getSupplierCode());
        purchaseQualityCheckHead.setSupplierName(masterData.getSupplierName());
        purchaseQualityCheckHead.setCompany(company);
        purchaseQualityCheckHead.setFactory(factory);
        purchaseQualityCheckHead.setStorageLocation(storageLocation);
        purchaseQualityCheckHead.setCheckStartDate(DateUtils.getDate());
        purchaseQualityCheckHead.setSrmReceiptNumber(srmReceiptNumber);
        ArrayList<PurchaseQualityCheckItem> purchaseQualityCheckItems = new ArrayList<PurchaseQualityCheckItem>();
        for (PurchaseVoucherItemDTO voucherItem : voucherItems) {
            PurchaseMaterialHeadDTO materialHeadDTO = this.purchaseMaterialHeadRpcService.getMaterialHeadByNumber(voucherItem.getMaterialNumber());
            PurchaseQualityCheckItem purchaseQualityCheckItem = new PurchaseQualityCheckItem();
            BeanUtils.copyProperties((Object)voucherItem, (Object)((Object)purchaseQualityCheckItem));
            purchaseQualityCheckItem.setSourceType("0");
            purchaseQualityCheckItem.setSourceNumber(voucherItem.getVoucherNumber());
            purchaseQualityCheckItem.setSourceItemNumber(voucherItem.getItemNumber());
            purchaseQualityCheckItem.setSourceItemId(voucherItem.getId());
            purchaseQualityCheckItem.setCheckQuantity(voucherItem.getVoucherQuantity());
            purchaseQualityCheckItem.setActualBatch(voucherItem.getVoucherQuantity());
            purchaseQualityCheckItem.setCheckType(materialHeadDTO.getCheckType());
            purchaseQualityCheckItem.setMaterialName(materialHeadDTO.getMaterialName());
            purchaseQualityCheckItem.setCateCode(materialHeadDTO.getCateCode());
            purchaseQualityCheckItem.setCateName(materialHeadDTO.getCateName());
            purchaseQualityCheckItem.setMaterialGroup(materialHeadDTO.getMaterialGroup());
            purchaseQualityCheckItem.setMaterialGroupName(materialHeadDTO.getMaterialGroupName());
            purchaseQualityCheckItems.add(purchaseQualityCheckItem);
        }
        PurchaseQualityCheckHead qualityCheckHead = this.publishCheck(purchaseQualityCheckHead, purchaseQualityCheckItems);
        PurchaseQualityCheckHeadVO purchaseQualityCheckHeadVO = new PurchaseQualityCheckHeadVO();
        BeanUtils.copyProperties((Object)((Object)qualityCheckHead), (Object)((Object)purchaseQualityCheckHeadVO));
        purchaseQualityCheckHeadVO.setPurchaseQualityCheckItemList(purchaseQualityCheckItems);
        return purchaseQualityCheckHeadVO;
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getQualityCheckHead", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseQualityCheckHeadList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseQualityCheckHead purchaseQualityCheckHead : purchaseQualityCheckHeadList) {
            String elsAccount = TenantContext.getTenant();
            this.interfaceUtil.callInterface(elsAccount, "pushQualityCheckHead", (Object)purchaseQualityCheckHead);
        }
    }

    @Override
    public void copy(String id) {
        if (StrUtil.isNotBlank((CharSequence)id)) {
            LoginUserDTO sysUser = SysUtil.getLoginUser();
            PurchaseQualityCheckHead checkHead = (PurchaseQualityCheckHead)((Object)this.getById((Serializable)((Object)id)));
            List<PurchaseQualityCheckItem> purchaseQualityCheckItemList = this.purchaseQualityCheckItemMapper.selectByMainId(id);
            if (checkHead != null) {
                checkHead.setId(null);
                checkHead.setCheckStatus(CheckStatusEnum.NEW.getValue());
                checkHead.setRelationId(IdWorker.getIdStr());
                checkHead.setCheckNumber(this.invokeBaseRpcService.getNextCode("srmCheckNumber", (Object)checkHead));
                checkHead.setCreateBy(sysUser.getSubAccount());
                checkHead.setCreateById(sysUser.getId());
                checkHead.setCreateTime(new Date());
                checkHead.setUpdateTime(new Date());
                checkHead.setUpdateBy(sysUser.getSubAccount());
                checkHead.setUpdateById(sysUser.getId());
            }
            String publishAudit = checkHead.getPublishAudit();
            this.setDefualtValue(checkHead);
            if (StrUtil.isBlank((CharSequence)checkHead.getSrmReceiptNumber())) {
                checkHead.setSourceType(CheckSourceTypeEnum.MANUAL.getValue());
            } else {
                checkHead.setSourceType(CheckSourceTypeEnum.DELIVERY_VOUCHER.getValue());
            }
            if (StrUtil.isNotBlank((CharSequence)publishAudit)) {
                checkHead.setPublishAudit(publishAudit);
            }
            if ("1".equals(checkHead.getPublishAudit())) {
                checkHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            } else {
                checkHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
            this.purchaseQualityCheckHeadMapper.insert((Object)checkHead);
            for (PurchaseQualityCheckItem entity : purchaseQualityCheckItemList) {
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)checkHead);
                entity.setUpdateTime(new Date());
                entity.setCreateTime(new Date());
                entity.setCreateBy(sysUser.getRealname());
                entity.setUpdateBy(sysUser.getRealname());
                entity.setHeadId(checkHead.getId());
                entity.setCheckNumber(checkHead.getCheckNumber());
                entity.setCheckDamageQuantity(null);
                entity.setNumberDefectiveProducts(null);
                entity.setCheckStandards(null);
                entity.setTestResult(null);
                entity.setDecisionConclusion(null);
                entity.setBadReasons(null);
                entity.setBadClassification(null);
            }
            this.insertData(checkHead, purchaseQualityCheckItemList);
        }
    }

    @Override
    public JSONObject getDataById(String id) {
        PurchaseQualityCheckHead purchaseQualityCheckHead = (PurchaseQualityCheckHead)((Object)this.getById((Serializable)((Object)id)));
        Result result = Result.ok((Object)((Object)purchaseQualityCheckHead));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)purchaseQualityCheckHead, new DictTranslateAspectParam());
        String elsAccount = purchaseQualityCheckHead.getElsAccount();
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = this.invokeAccountRpcService.getByElsAccount(elsAccount);
        if (ObjectUtil.isNotEmpty((Object)elsEnterpriseInfoDTO)) {
            jsonObject.put("purchaseName", (Object)elsEnterpriseInfoDTO.getName());
        } else {
            LoginUserDTO loginUser = SysUtil.getLoginUser();
            if (ObjectUtil.isNotEmpty((Object)loginUser)) {
                jsonObject.put("purchaseName", (Object)loginUser.getCompanyName());
            }
        }
        return jsonObject;
    }
}

