/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.sample.entity.PurchaseSampleCheckProject;
import com.els.modules.sample.enumerate.PurchaseSampleCheckProjectEnum;
import com.els.modules.sample.mapper.PurchaseSampleCheckProjectMapper;
import com.els.modules.sample.service.PurchaseSampleCheckProjectService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PurchaseSampleCheckProjectServiceImpl
extends BaseServiceImpl<PurchaseSampleCheckProjectMapper, PurchaseSampleCheckProject>
implements PurchaseSampleCheckProjectService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    private static final Integer ZERO = 0;
    private static final BigDecimal MAX_SAMPLE_RATE = new BigDecimal(100);

    @Override
    public void savePurchaseSampleCheckProject(PurchaseSampleCheckProject purchaseSampleCheckProject) {
        this.check(purchaseSampleCheckProject);
        purchaseSampleCheckProject.setProjectStatus(PurchaseSampleCheckProjectEnum.ENABLED.getValue());
        purchaseSampleCheckProject.setProjectNumber(this.invokeBaseRpcService.getNextCode("srmSampleCheckProjectNumber", (Object)purchaseSampleCheckProject));
        ((PurchaseSampleCheckProjectMapper)this.baseMapper).insert((Object)purchaseSampleCheckProject);
    }

    @Override
    public void updatePurchaseSampleCheckProject(PurchaseSampleCheckProject purchaseSampleCheckProject) {
        this.check(purchaseSampleCheckProject);
        ((PurchaseSampleCheckProjectMapper)this.baseMapper).updateById((Object)purchaseSampleCheckProject);
    }

    @Override
    public void delPurchaseSampleCheckProject(String id) {
        ((PurchaseSampleCheckProjectMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseSampleCheckProject(List<String> idList) {
        ((PurchaseSampleCheckProjectMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void copy(String id) {
        PurchaseSampleCheckProject checkProject;
        if (StrUtil.isNotBlank((CharSequence)id) && (checkProject = (PurchaseSampleCheckProject)((Object)this.getById((Serializable)((Object)id)))) != null) {
            LoginUserDTO loginUser = SysUtil.getLoginUser();
            checkProject.setId(null);
            checkProject.setUpdateTime(new Date());
            checkProject.setCreateTime(new Date());
            checkProject.setCreateBy(loginUser.getSubAccount());
            checkProject.setUpdateBy(loginUser.getSubAccount());
            checkProject.setCreateById(loginUser.getId());
            checkProject.setUpdateById(loginUser.getId());
            checkProject.setProjectStatus(PurchaseSampleCheckProjectEnum.DISABLED.getValue());
            checkProject.setProjectNumber(this.invokeBaseRpcService.getNextCode("srmSampleCheckProjectNumber", (Object)checkProject));
            ((PurchaseSampleCheckProjectMapper)this.baseMapper).insert((Object)checkProject);
        }
    }

    private void check(PurchaseSampleCheckProject purchaseSampleCheckProject) {
        if (Objects.nonNull(purchaseSampleCheckProject.getSamplingRate()) && (purchaseSampleCheckProject.getSamplingRate().compareTo(BigDecimal.ZERO) < 0 || purchaseSampleCheckProject.getSamplingRate().compareTo(MAX_SAMPLE_RATE) > 0)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VVlvMRMIROK0100_49e157b0", (String)"\u62bd\u6837\u6bd4\u4f8b\u53d6\u503c\u533a\u95f4\u53ea\u80fd\u57280-100"));
        }
        if (Objects.nonNull(purchaseSampleCheckProject.getDeduceMax()) && Objects.nonNull(purchaseSampleCheckProject.getDeduceMin()) && purchaseSampleCheckProject.getDeduceMax().compareTo(purchaseSampleCheckProject.getDeduceMin()) < 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_FOXWlTfUEUFOIW_479450a2", (String)"\u5224\u65ad\u4e0a\u9650\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5224\u65ad\u4e0b\u9650\uff01"));
        }
        if (Objects.isNull(purchaseSampleCheckProject.getSamplingNum())) {
            return;
        }
        boolean intFlag = true;
        try {
            Integer.parseInt(purchaseSampleCheckProject.getSamplingNum().toString());
        }
        catch (NumberFormatException e) {
            intFlag = false;
        }
        if (intFlag && purchaseSampleCheckProject.getSamplingNum().compareTo(BigDecimal.ZERO) < 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CIVNWLiiW_911ae90b", (String)"\u56fa\u5b9a\u6837\u54c1\u6570\u4e3a\u6b63\u6574\u6570\uff01"));
        }
    }
}

