/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.sample.entity.SaleSampleCheckHead;
import com.els.modules.sample.entity.SaleSampleCheckItem;
import com.els.modules.sample.mapper.SaleSampleCheckHeadMapper;
import com.els.modules.sample.service.SaleSampleCheckHeadService;
import com.els.modules.sample.service.SaleSampleCheckItemService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SaleSampleCheckHeadServiceImpl
extends BaseServiceImpl<SaleSampleCheckHeadMapper, SaleSampleCheckHead>
implements SaleSampleCheckHeadService {
    @Resource
    private SaleSampleCheckItemService saleSampleCheckItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleSampleCheckHead saleSampleCheckHead, List<SaleSampleCheckItem> saleSampleCheckItemList) {
        ((SaleSampleCheckHeadMapper)this.baseMapper).insert((Object)saleSampleCheckHead);
        super.setHeadDefaultValue((BaseEntity)saleSampleCheckHead);
        this.insertData(saleSampleCheckHead, saleSampleCheckItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleSampleCheckHead saleSampleCheckHead, List<SaleSampleCheckItem> saleSampleCheckItemList) {
        int count = ((SaleSampleCheckHeadMapper)this.baseMapper).updateById((Object)saleSampleCheckHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.saleSampleCheckItemService.deleteByMainId(saleSampleCheckHead.getId());
        this.insertData(saleSampleCheckHead, saleSampleCheckItemList);
    }

    private void insertData(SaleSampleCheckHead saleSampleCheckHead, List<SaleSampleCheckItem> saleSampleCheckItemList) {
        if (!CollectionUtils.isEmpty(saleSampleCheckItemList)) {
            for (SaleSampleCheckItem entity : saleSampleCheckItemList) {
                entity.setHeadId(saleSampleCheckHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleSampleCheckHead);
            }
            this.saleSampleCheckItemService.saveBatch(saleSampleCheckItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.saleSampleCheckItemService.deleteByMainId(id);
        ((SaleSampleCheckHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleSampleCheckItemService.deleteByMainId(serializable.toString());
            ((SaleSampleCheckHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }
}

