/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.mould.entity.PurchaseMouldScrapped;
import com.els.modules.mould.service.PurchaseMouldScrappedService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="mouldScrappedAdapter")
public class MouldScrappedAuditServiceImpl
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseMouldScrappedService purchaseMouldScrappedService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseMouldScrapped head = (PurchaseMouldScrapped)((Object)this.purchaseMouldScrappedService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseMouldScrapped scrapped = (PurchaseMouldScrapped)((Object)this.purchaseMouldScrappedService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        scrapped.setFlowId(flowCallbackDTO.getProcessInstanceId());
        scrapped.setAuditStatus(auditStatus);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            this.purchaseMouldScrappedService.confirm(scrapped);
            return;
        }
        if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            scrapped.setPurchaseRemark(flowCallbackDTO.getOpinion());
            this.purchaseMouldScrappedService.refuse(scrapped);
            return;
        }
        this.purchaseMouldScrappedService.updateById((Object)scrapped);
    }
}

