/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.mould.entity.PurchaseMouldData;
import com.els.modules.mould.entity.PurchaseMouldTransferHead;
import com.els.modules.mould.entity.PurchaseMouldTransferItem;
import com.els.modules.mould.enumerate.TransferStatusEnum;
import com.els.modules.mould.mapper.PurchaseMouldTransferHeadMapper;
import com.els.modules.mould.service.PurchaseMouldDataService;
import com.els.modules.mould.service.PurchaseMouldTransferHeadService;
import com.els.modules.mould.service.PurchaseMouldTransferItemService;
import com.els.modules.mould.service.SaleMouldTransferHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseMouldTransferHeadServiceImpl
extends BaseServiceImpl<PurchaseMouldTransferHeadMapper, PurchaseMouldTransferHead>
implements PurchaseMouldTransferHeadService {
    @Autowired
    private PurchaseMouldTransferItemService purchaseMouldTransferItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleMouldTransferHeadService saleMouldTransferHeadService;
    @Autowired
    private PurchaseMouldDataService purchaseMouldDataService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseMouldTransferHead transferHead, List<PurchaseMouldTransferItem> itemList) {
        String elsAccount = TenantContext.getTenant();
        String transferNumber = this.invokeBaseRpcService.getNextCode("mouldTransfer", (Object)transferHead);
        transferHead.setTransferNumber(transferNumber);
        transferHead.setElsAccount(elsAccount);
        transferHead.setBusAccount(elsAccount);
        transferHead.setTransferStatus(TransferStatusEnum.NEW.getValue());
        ((PurchaseMouldTransferHeadMapper)this.baseMapper).insert((Object)transferHead);
        this.insertData(transferHead, itemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseMouldTransferHead transferHead, List<PurchaseMouldTransferItem> itemList) {
        String elsAccount = TenantContext.getTenant();
        transferHead.setElsAccount(elsAccount);
        transferHead.setBusAccount(elsAccount);
        transferHead.setTransferStatus(TransferStatusEnum.NEW.getValue());
        ((PurchaseMouldTransferHeadMapper)this.baseMapper).updateById((Object)transferHead);
        this.purchaseMouldTransferItemService.deleteByMainId(transferHead.getId());
        this.insertData(transferHead, itemList);
    }

    private void insertData(PurchaseMouldTransferHead transferHead, List<PurchaseMouldTransferItem> itemList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            int itemNumber = 1;
            for (PurchaseMouldTransferItem item : itemList) {
                item.setId(null);
                item.setHeadId(transferHead.getId());
                item.setTransferNumber(transferHead.getTransferNumber());
                item.setItemNumber(String.valueOf(itemNumber++));
                item.setItemStatus(TransferStatusEnum.NEW.getValue());
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)transferHead);
            }
            this.purchaseMouldTransferItemService.saveBatch(itemList);
        }
    }

    @Override
    public void publish(PurchaseMouldTransferHead transferHead, List<PurchaseMouldTransferItem> itemList) {
        this.checkPublish(transferHead, itemList);
        transferHead.setTransferStatus(TransferStatusEnum.WAIT_CONFIRM.getValue());
        transferHead.setSendId(IdWorker.getIdStr());
        transferHead.setReceiveId(IdWorker.getIdStr());
        transferHead.setPublishTime(new Date());
        transferHead.setPublishUser(super.getLoginSubAndName());
        ((PurchaseMouldTransferHeadMapper)this.baseMapper).updateById((Object)transferHead);
        this.purchaseMouldTransferItemService.deleteByMainId(transferHead.getId());
        int itemNumber = 1;
        for (PurchaseMouldTransferItem item : itemList) {
            item.setId(null);
            item.setHeadId(transferHead.getId());
            item.setSendItemId(IdWorker.getIdStr());
            item.setReceiveItemId(IdWorker.getIdStr());
            item.setTransferNumber(transferHead.getTransferNumber());
            item.setItemNumber(String.valueOf(itemNumber++));
            item.setItemStatus(TransferStatusEnum.WAIT_SEND_CONFIRM.getValue());
            SysUtil.setSysParam((BaseEntity)item, (BaseEntity)transferHead);
        }
        this.purchaseMouldTransferItemService.saveBatch(itemList);
        this.saleMouldTransferHeadService.add(transferHead, itemList);
    }

    private void checkPublish(PurchaseMouldTransferHead transferHead, List<PurchaseMouldTransferItem> itemList) {
        String sendAccount = transferHead.getSendElsAccount();
        Assert.hasText((String)sendAccount, (String)I18nUtil.translate((String)"i18n_alert_hGRdXeyxOLV_aaef2945", (String)"\u53d1\u51fa\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)transferHead.getReceiveElsAccount(), (String)I18nUtil.translate((String)"i18n_alert_ylRdXeyxOLV_1368505d", (String)"\u63a5\u6536\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notEmpty(itemList, (String)I18nUtil.translate((String)"i18n_alert_cdIxOLV_e4453e71", (String)"\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a"));
        for (PurchaseMouldTransferItem item : itemList) {
            Assert.hasText((String)item.getMouldDataId(), (String)I18nUtil.translate((String)"i18n_alert_IFdWFWWxOLV_9f2b7dae", (String)"\u6a21\u5177\u4e3b\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.notNull((Object)item.getNeedSendTime(), (String)I18nUtil.translate((String)"i18n_alert_PVhGKIxOLV_34c06338", (String)"\u8981\u6c42\u53d1\u51fa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List mouldDataIdList = itemList.stream().map(PurchaseMouldTransferItem::getMouldDataId).distinct().collect(Collectors.toList());
        List mouldDataList = this.purchaseMouldDataService.listByIds(mouldDataIdList);
        for (PurchaseMouldData mouldData : mouldDataList) {
            Assert.isTrue((boolean)sendAccount.equals(mouldData.getToElsAccount()), (String)I18nUtil.translate((String)"i18n_alert_IFujRdXUhGRdXxeWxqTr_e250f3af", (String)"\u6a21\u5177\u6301\u6709\u4f9b\u5e94\u5546\u4e0e\u53d1\u51fa\u4f9b\u5e94\u5546\u4e0d\u540c\uff0c\u4e0d\u53ef\u8c03\u62e8"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseMouldTransferItemService.deleteByMainId(id);
        ((PurchaseMouldTransferHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }
}

