/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmUtil;
import com.els.modules.quality.entity.PurchaseRetificationReviewTeam;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportItem;
import com.els.modules.quality.mapper.PurchaseRetificationReviewTeamMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportItemMapper;
import com.els.modules.quality.service.PurchaseSupplierRectificationReportHeadService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="supplierRetificationAuditRpcAdapter")
public class SupplierRetificationAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseSupplierRectificationReportHeadMapper purchaseSupplierRectificationReportHeadMapper;
    @Autowired
    private PurchaseSupplierRectificationReportHeadService purchaseSupplierRectificationReportHeadService;
    @Resource
    private PurchaseSupplierRectificationReportItemMapper purchaseSupplierRectificationReportItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseRetificationReviewTeamMapper purchaseRetificationReviewTeamMapper;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        String bussinessId = flowCallbackDTO.getBusinessId();
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = (PurchaseSupplierRectificationReportHead)((Object)this.purchaseSupplierRectificationReportHeadService.getById((Serializable)((Object)bussinessId)));
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(purchaseSupplierRectificationReportHead.getPreAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFIOIOGUQLsWxOVBDJUz_9e87c37c", (String)"\u5f53\u524d\u5355\u636e\u5df2\u7ecf\u5df2\u7ecf\u5904\u4e8e\u6d41\u7a0b\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\u5ba1\u6279"));
        }
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        this.sendSupplierRetificationToSale(flowCallbackDTO.getBusinessId());
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    private void sendSupplierRetificationToSale(String businessId) {
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = (PurchaseSupplierRectificationReportHead)((Object)this.purchaseSupplierRectificationReportHeadMapper.selectById((Serializable)((Object)businessId)));
        List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItemList = this.purchaseSupplierRectificationReportItemMapper.selectByMainId(businessId);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(businessId);
        List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList = this.purchaseRetificationReviewTeamMapper.selectByMainId(businessId);
        ((PurchaseSupplierRectificationReportHeadService)SpringContextUtils.getBean(PurchaseSupplierRectificationReportHeadService.class)).publish(purchaseSupplierRectificationReportHead, purchaseSupplierRectificationReportItemList, purchaseRetificationReviewTeamList, purchaseAttachmentList);
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseSupplierRectificationReportHead head = (PurchaseSupplierRectificationReportHead)((Object)this.purchaseSupplierRectificationReportHeadMapper.selectById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseSupplierRectificationReportHead supplierRectificationReportHead = new PurchaseSupplierRectificationReportHead();
        supplierRectificationReportHead.setId(flowCallbackDTO.getBusinessId());
        supplierRectificationReportHead.setPreAuditStatus(auditStatus);
        supplierRectificationReportHead.setPreFlowCode(flowCallbackDTO.getProcessInstanceId());
        if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus) && flowCallbackDTO.getProcessInstanceId() != null) {
            supplierRectificationReportHead.setPreFlowCode("");
        }
        this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)supplierRectificationReportHead);
    }
}

