/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.eightReport.rpc.service.InvokeMainDataRpcService;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.quality.entity.SaleSupplierRectificationReportHead;
import com.els.modules.quality.enumerate.SupplierRectificationStatusEnum;
import com.els.modules.quality.mapper.PurchaseRetificationReviewTeamMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.PurchaseSupplierRectificationReportItemMapper;
import com.els.modules.quality.mapper.SaleSupplierRectificationReportHeadMapper;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="supplierRetificationResultAuditRpcAdapter")
public class SupplierRetificationResultAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseSupplierRectificationReportHeadMapper purchaseSupplierRectificationReportHeadMapper;
    @Resource
    private PurchaseSupplierRectificationReportItemMapper purchaseSupplierRectificationReportItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseRetificationReviewTeamMapper purchaseRetificationReviewTeamMapper;
    @Resource
    private SaleSupplierRectificationReportHeadMapper saleSupplierRectificationReportHeadMapper;
    @Resource
    private InvokeMainDataRpcService invokeMainDataRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO, SupplierRectificationStatusEnum.EVALUATIONED.getValue());
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO, SupplierRectificationStatusEnum.EVALUATIONED.getValue());
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO, SupplierRectificationStatusEnum.EVALUATIONED.getValue());
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO, SupplierRectificationStatusEnum.EVALUATIONED.getValue());
    }

    public Map<String, Object> getById(String id) {
        SaleSupplierRectificationReportHead head = (SaleSupplierRectificationReportHead)((Object)this.saleSupplierRectificationReportHeadMapper.selectById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO, String rectificationStatus) {
        PurchaseSupplierRectificationReportHead supplierRectificationReportHead = new PurchaseSupplierRectificationReportHead();
        supplierRectificationReportHead.setId(flowCallbackDTO.getBusinessId());
        supplierRectificationReportHead.setResultAuditStatus(auditStatus);
        supplierRectificationReportHead.setResultFlowCode(flowCallbackDTO.getProcessInstanceId());
        supplierRectificationReportHead.setRectificationStatus(rectificationStatus);
        Object paramsJsonObject = null;
        if (!SupplierRectificationStatusEnum.EVALUATIONED.getValue().equals(rectificationStatus)) {
            if (paramsJsonObject != null && SupplierRectificationStatusEnum.RECTIFICATIONED.getValue().equals(rectificationStatus)) {
                supplierRectificationReportHead.setRectificationConclusion(paramsJsonObject.getString("rectificationConclusion"));
            } else {
                supplierRectificationReportHead.setRectificationConclusion(null);
            }
        } else {
            supplierRectificationReportHead.setRectificationConclusion(paramsJsonObject.getString("rectificationConclusion"));
        }
        this.purchaseSupplierRectificationReportHeadMapper.updateById((Object)supplierRectificationReportHead);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().set(SaleSupplierRectificationReportHead::getRectificationStatus, (Object)rectificationStatus);
        updateWrapper.lambda().set(SaleSupplierRectificationReportHead::getRectificationConclusion, (Object)supplierRectificationReportHead.getRectificationConclusion());
        updateWrapper.lambda().eq(SaleSupplierRectificationReportHead::getRelationId, (Object)flowCallbackDTO.getBusinessId());
        this.saleSupplierRectificationReportHeadMapper.update(null, (Wrapper)updateWrapper);
    }
}

