/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.siteInspection.entity.ElsInspectionPlanHead;
import com.els.modules.siteInspection.job.utils.ElsInspectionPlanJobUtil;
import com.els.modules.siteInspection.service.ElsInspectionPlanHeadService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;

@RpcService(value="elsInspectionPlanRpcAdapter")
public class ElsInspectionPlanAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private ElsInspectionPlanHeadService elsInspectionPlanHeadService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        ElsInspectionPlanHead head = (ElsInspectionPlanHead)((Object)this.elsInspectionPlanHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        head.setStatus("1");
        head.setResultAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        this.elsInspectionPlanHeadService.updateById((Object)head);
        ElsInspectionPlanHead planHead = (ElsInspectionPlanHead)((Object)this.elsInspectionPlanHeadService.getById((Serializable)((Object)head.getId())));
        if ("1".equals(planHead.getCreateMethod())) {
            ElsInspectionPlanJobUtil.createJob(planHead, planHead.getAutoExecuteDate());
        }
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        ElsInspectionPlanHead head = (ElsInspectionPlanHead)((Object)this.elsInspectionPlanHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        ElsInspectionPlanHead head = new ElsInspectionPlanHead();
        head.setResultAuditStatus(auditStatus);
        head.setId(flowCallbackDTO.getBusinessId());
        head.setResultFlowId(flowCallbackDTO.getProcessInstanceId());
        this.elsInspectionPlanHeadService.updateById((Object)head);
    }
}

