/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.siteInspection.entity.ElsInspectionStandardHead;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardHeadMapper;
import com.els.modules.siteInspection.service.ElsInspectionStandardHeadService;
import com.els.modules.siteInspection.vo.ElsInspectionStandardHeadSubmitVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="elsInspectionStandardRpcAdapter")
public class ElsInspectionStandardAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private ElsInspectionStandardHeadMapper headMapper;
    @Autowired
    private ElsInspectionStandardHeadService headService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    private void updateAudiStatus(String businessId, String auditStatus, String processRootId) {
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)this.headMapper.selectById((Serializable)((Object)businessId)));
        head.setResultAuditStatus(auditStatus);
        head.setResultFlowId(processRootId);
        if (Objects.equals(AuditStatusEnum.AUDIT_FINISH.getValue(), auditStatus)) {
            head.setStatus("1");
        }
        this.headMapper.updateById((Object)head);
    }

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)this.headMapper.selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        head.setResultAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        head.setResultFlowId(flowCallbackDTO.getProcessInstanceId());
        if (Objects.equals(AuditStatusEnum.AUDIT_FINISH.getValue(), AuditStatusEnum.AUDIT_DOING.getValue())) {
            head.setStatus("1");
        }
        this.headMapper.updateById((Object)head);
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO.getProcessInstanceId());
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO.getProcessInstanceId());
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO.getProcessInstanceId());
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO.getProcessInstanceId());
    }

    public Map<String, Object> getById(String id) {
        ElsInspectionStandardHeadSubmitVO head = this.headService.getById(id);
        return SrmUtil.toJSONObject((Object)((Object)head));
    }
}

