/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.adapter;

import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmUtil;
import com.els.modules.siteInspection.constants.SiteInspectionConstant;
import com.els.modules.siteInspection.entity.PurchaseInspectionHead;
import com.els.modules.siteInspection.entity.SaleInspectionHead;
import com.els.modules.siteInspection.enums.I18nSiteInspectEnum;
import com.els.modules.siteInspection.mapper.PurchaseInspectionHeadMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionHeadMapper;
import com.els.modules.siteInspection.service.PurchaseInspectionHeadService;
import com.els.modules.siteInspection.service.impl.ElsInspectionPlanHeadServiceImpl;
import com.els.modules.siteInspection.vo.InspectionScoreResVo;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="siteInspectionRpcAdapter")
public class SiteInspectionAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseInspectionHeadMapper purHeadMapper;
    @Resource
    private SaleInspectionHeadMapper saleHeadMapper;
    @Autowired
    private PurchaseInspectionHeadService purService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    private void updateAudiStatus(String businessId, String auditStatus, String processRootId, String bpmnType) {
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)this.purHeadMapper.selectById((Serializable)((Object)businessId)));
        if (StrUtil.isNotEmpty((CharSequence)bpmnType)) {
            head.setWorkFlowType(bpmnType);
        }
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((!"1".equals(head.getPubishAudit()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.NOT_AUDI_FAIL);
        AssertI18nUtil.isTrue((!"4".equals(head.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.NOT_SCORE_STATUS_FAIL);
        head.setResultAuditStatus(auditStatus);
        head.setResultFlowId(processRootId);
        if (Objects.equals(AuditStatusEnum.AUDIT_FINISH.getValue(), auditStatus)) {
            String status = "2".equals(head.getInspectionConclusion()) ? "5" : "6";
            status = SiteInspectionConstant.getInspectStatusByConclusion(head.getInspectionConclusion());
            head.setDocumentsStatus(status);
        } else if (Objects.equals(AuditStatusEnum.AUDIT_REJECT.getValue(), auditStatus)) {
            head.setDocumentsStatus("3");
        }
        this.purHeadMapper.updateById((Object)head);
        if ("6".equals(head.getDocumentsStatus())) {
            ElsInspectionPlanHeadServiceImpl planHeadService = (ElsInspectionPlanHeadServiceImpl)SpringContextUtils.getBean(ElsInspectionPlanHeadServiceImpl.class);
            planHeadService.caseClosedWriteBackPlanItem(head);
        }
        if (StrUtil.isBlank((CharSequence)head.getRelationId())) {
            return;
        }
        SaleInspectionHead saleInspectionHead = (SaleInspectionHead)((Object)this.saleHeadMapper.selectById((Serializable)((Object)head.getRelationId())));
        if (saleInspectionHead == null) {
            return;
        }
        saleInspectionHead.setResultAuditStatus(auditStatus);
        saleInspectionHead.setResultFlowId(processRootId);
        saleInspectionHead.setDocumentsStatus(head.getDocumentsStatus());
        this.saleHeadMapper.updateById((Object)saleInspectionHead);
    }

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO.getProcessInstanceId(), null);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO.getProcessInstanceId(), null);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO.getProcessInstanceId(), null);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAudiStatus(flowCallbackDTO.getBusinessId(), AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO.getProcessInstanceId(), null);
    }

    public Map<String, Object> getById(String id) {
        InspectionScoreResVo head = this.purService.getById(id);
        return SrmUtil.toJSONObject((Object)((Object)head));
    }
}

