/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.WorkFlowUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.siteInspection.entity.ElsInspectionPlanHead;
import com.els.modules.siteInspection.entity.ElsInspectionPlanItem;
import com.els.modules.siteInspection.entity.PurchaseInspectionHead;
import com.els.modules.siteInspection.entity.PurchaseInspectionPlan;
import com.els.modules.siteInspection.job.utils.ElsInspectionPlanJobUtil;
import com.els.modules.siteInspection.mapper.ElsInspectionPlanHeadMapper;
import com.els.modules.siteInspection.service.ElsInspectionPlanHeadService;
import com.els.modules.siteInspection.service.ElsInspectionPlanItemService;
import com.els.modules.siteInspection.service.impl.ElsInspectionStandardHeadServiceImpl;
import com.els.modules.siteInspection.service.impl.PurchaseInspectionHeadServiceImpl;
import com.els.modules.siteInspection.service.impl.PurchaseInspectionPlanServiceImpl;
import com.els.modules.siteInspection.vo.ElsInspectionPlanHeadVO;
import com.els.modules.siteInspection.vo.ElsInspectionStandardHeadSubmitVO;
import com.els.modules.siteInspection.vo.PurchaseInspectionHeadSaveVO;
import com.els.modules.siteInspection.vo.inspectionSheet.PurchaseInspectionItemVo;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.srm.workflow.modules.dto.SubmitAuditDTO;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ElsInspectionPlanHeadServiceImpl
extends BaseServiceImpl<ElsInspectionPlanHeadMapper, ElsInspectionPlanHead>
implements ElsInspectionPlanHeadService {
    @Autowired
    private ElsInspectionPlanItemService elsInspectionPlanItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private TemplateRpcService templateRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ElsInspectionPlanHead elsInspectionPlanHead, List<ElsInspectionPlanItem> elsInspectionPlanItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (StrUtil.isBlank((CharSequence)elsInspectionPlanHead.getPlanNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("elsInspectionPlanNumber", (Object)elsInspectionPlanHead);
            elsInspectionPlanHead.setPlanNumber(nextCode);
        }
        elsInspectionPlanHead.setStatus("0");
        this.setAuditStatus(elsInspectionPlanHead);
        ((ElsInspectionPlanHeadMapper)this.baseMapper).insert((Object)elsInspectionPlanHead);
        super.setHeadDefaultValue((ParentEntity)elsInspectionPlanHead);
        this.insertData(elsInspectionPlanHead, elsInspectionPlanItemList, purchaseAttachmentList);
    }

    private void setAuditStatus(ElsInspectionPlanHead elsInspectionPlanHead) {
        if ("1".equals(elsInspectionPlanHead.getPublishAudit())) {
            elsInspectionPlanHead.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            elsInspectionPlanHead.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ElsInspectionPlanHead elsInspectionPlanHead, List<ElsInspectionPlanItem> elsInspectionPlanItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.setAuditStatus(elsInspectionPlanHead);
        int count = ((ElsInspectionPlanHeadMapper)this.baseMapper).updateById((Object)elsInspectionPlanHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.elsInspectionPlanItemService.deleteByMainId(elsInspectionPlanHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(elsInspectionPlanHead.getId());
        this.insertData(elsInspectionPlanHead, elsInspectionPlanItemList, purchaseAttachmentList);
    }

    private void insertData(ElsInspectionPlanHead elsInspectionPlanHead, List<ElsInspectionPlanItem> elsInspectionPlanItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(elsInspectionPlanItemList)) {
            for (ElsInspectionPlanItem entity : elsInspectionPlanItemList) {
                entity.setHeadId(elsInspectionPlanHead.getId());
                entity.setGenerateInspectionStatus("0");
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsInspectionPlanHead);
                entity.setId(IdWorker.getIdStr());
            }
            this.elsInspectionPlanItemService.saveBatch(elsInspectionPlanItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO attachment : purchaseAttachmentList) {
                attachment.setId(null);
                attachment.setHeadId(elsInspectionPlanHead.getId());
                attachment.setBusinessType("inspectionPlan");
                attachment.setSendStatus("0");
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)elsInspectionPlanHead);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.elsInspectionPlanItemService.deleteByMainId(id);
        ((ElsInspectionPlanHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsInspectionPlanItemService.deleteByMainId(serializable.toString());
            ((ElsInspectionPlanHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public void submit(ElsInspectionPlanHeadVO headVO) {
        this.submitVerify(headVO);
        this.updateMain(headVO, headVO.getInspectionPlanItemList(), headVO.getPurchaseAttachmentList());
        if ("1".equals(headVO.getPublishAudit())) {
            ElsInspectionPlanHead head = (ElsInspectionPlanHead)((Object)((ElsInspectionPlanHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
            String subject = "\u8003\u5bdf\u8ba1\u5212\u5ba1\u6279,\u5355\u53f7\uff1a" + head.getPlanNumber() + " " + head.getPlanName();
            SubmitAuditDTO dto = SubmitAuditDTO.builder().businessId(head.getId()).businessType("inspectionPlan").processTitle(subject).businessObj((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)head)))).build();
            WorkFlowUtil.submit((SubmitAuditDTO)dto);
        } else {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().set(ElsInspectionPlanHead::getResultAuditStatus, (Object)AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            updateWrapper.lambda().set(ElsInspectionPlanHead::getStatus, (Object)"1");
            updateWrapper.lambda().eq(ParentEntity::getId, (Object)headVO.getId());
            this.update((Wrapper)updateWrapper);
            ElsInspectionPlanHead planHead = (ElsInspectionPlanHead)((Object)this.getById((Serializable)((Object)headVO.getId())));
            if ("1".equals(planHead.getCreateMethod())) {
                ElsInspectionPlanJobUtil.createJob(planHead, planHead.getAutoExecuteDate());
            }
        }
    }

    private void submitVerify(ElsInspectionPlanHeadVO headVO) {
        Date nowDate = new Date();
        if (StrUtil.isBlank((CharSequence)headVO.getPlanName())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_BmtERLxOLVW_ab8b26e1", (String)"\u8003\u5bdf\u8ba1\u5212\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (StrUtil.isBlank((CharSequence)headVO.getCreateMethod())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_cICKxOLVW_7c9b611c", (String)"\u521b\u5efa\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if ("1".equals(headVO.getCreateMethod())) {
            if (Objects.isNull(headVO.getAutoExecuteDate())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_cICKLJOcIKWJORcBAxOLVW_30c26e3c", (String)"\u521b\u5efa\u65b9\u5f0f\u4e3a\u81ea\u52a8\u521b\u5efa\u65f6\uff0c\u81ea\u52a8\u6267\u884c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            if (DateUtil.compare((Date)nowDate, (Date)headVO.getAutoExecuteDate(), (String)"yyyy-MM-dd") >= 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_JORcBAlTfUAPBAW_f176cb13", (String)"\u81ea\u52a8\u6267\u884c\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65e5\u671f\uff01"));
            }
        }
        for (ElsInspectionPlanItem planItem : headVO.getInspectionPlanItemList()) {
            if (StrUtil.isBlank((CharSequence)planItem.getToElsAccount())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nWWWWcjRdXeyxOLVW_16b01d9b", (String)"\u7b2c${0}\u884c\u7684\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String[])new String[]{planItem.getItemNumber()}));
            }
            if (StrUtil.isBlank((CharSequence)planItem.getSaleContact())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nWWWWcjRdXKHLxOLVW_1d5fda23", (String)"\u7b2c${0}\u884c\u7684\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String[])new String[]{planItem.getItemNumber()}));
            }
            if (!StrUtil.isBlank((CharSequence)planItem.getSaleContactTelphone())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nWWWWcjKHCExOLVW_28f1025a", (String)"\u7b2c${0}\u884c\u7684\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String[])new String[]{planItem.getItemNumber()}));
        }
    }

    @Override
    public void updateStatus(ElsInspectionPlanHeadVO head) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().set(ElsInspectionPlanHead::getStatus, (Object)head.getStatus());
        updateWrapper.lambda().eq(ParentEntity::getId, (Object)head.getId());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void copy(ElsInspectionPlanHeadVO elsInspectionPlanHeadVO) {
        ElsInspectionPlanHead head = new ElsInspectionPlanHead();
        BeanUtils.copyProperties((Object)((Object)elsInspectionPlanHeadVO), (Object)((Object)head));
        head.setId(null);
        head.setStatus(null);
        head.setResultFlowId(null);
        head.setWorkFlowType(null);
        head.setResultAuditStatus(null);
        head.setPlanNumber(null);
        head.setCreateBy(SysUtil.getLoginUser().getSubAccount());
        head.setCreateById(SysUtil.getLoginUser().getId());
        head.setCreateTime(new Date());
        head.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
        head.setUpdateById(SysUtil.getLoginUser().getId());
        head.setUpdateTime(new Date());
        List<ElsInspectionPlanItem> inspectionPlanItemList = elsInspectionPlanHeadVO.getInspectionPlanItemList();
        inspectionPlanItemList.forEach(item -> item.setId(null));
        inspectionPlanItemList.forEach(item -> item.setHeadId(null));
        inspectionPlanItemList.forEach(item -> item.setActualCompletionDate(null));
        inspectionPlanItemList.forEach(item -> item.setInspectionConclusion(null));
        inspectionPlanItemList.forEach(item -> item.setInspectionNumber(null));
        inspectionPlanItemList.forEach(item -> item.setInspectScore(null));
        inspectionPlanItemList.forEach(item -> item.setScoreGrade(null));
        inspectionPlanItemList.forEach(item -> item.setGenerateInspectionStatus("0"));
        List<PurchaseAttachmentDTO> purchaseAttachmentList = elsInspectionPlanHeadVO.getPurchaseAttachmentList();
        purchaseAttachmentList.forEach(attachmentDTO -> attachmentDTO.setId(null));
        purchaseAttachmentList.forEach(attachmentDTO -> attachmentDTO.setHeadId(null));
        this.saveMain(head, inspectionPlanItemList, purchaseAttachmentList);
    }

    @Override
    public Result<?> generateInspection(ElsInspectionPlanHead head) {
        ArrayList<String> successInspectionNumberList = new ArrayList<String>();
        List<ElsInspectionPlanItem> itemList = this.elsInspectionPlanItemService.selectByMainId(head.getId());
        PurchaseInspectionHeadServiceImpl inspectionHeadService = (PurchaseInspectionHeadServiceImpl)SpringContextUtils.getBean(PurchaseInspectionHeadServiceImpl.class);
        ElsInspectionStandardHeadServiceImpl standardHeadService = (ElsInspectionStandardHeadServiceImpl)SpringContextUtils.getBean(ElsInspectionStandardHeadServiceImpl.class);
        for (ElsInspectionPlanItem planItem : itemList) {
            if (!"0".equals(planItem.getGenerateInspectionStatus())) continue;
            PurchaseInspectionHeadSaveVO purchaseInspectionHeadSaveVO = new PurchaseInspectionHeadSaveVO();
            this.setInspectionTemplate(planItem, purchaseInspectionHeadSaveVO);
            purchaseInspectionHeadSaveVO.setToElsAccount(planItem.getToElsAccount());
            purchaseInspectionHeadSaveVO.setSupplierErpCode(planItem.getSupplierCode());
            purchaseInspectionHeadSaveVO.setSupplierName(planItem.getSupplierName());
            purchaseInspectionHeadSaveVO.setInspectionReason("2");
            this.setInspectionStandard(standardHeadService, planItem, purchaseInspectionHeadSaveVO);
            purchaseInspectionHeadSaveVO.setPubishAudit("0");
            purchaseInspectionHeadSaveVO.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            PurchaseInspectionHeadSaveVO resultInspectionVO = inspectionHeadService.generate(purchaseInspectionHeadSaveVO);
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().set(ElsInspectionPlanItem::getInspectionNumber, (Object)resultInspectionVO.getDocumentsSerialNumber());
            updateWrapper.lambda().set(ElsInspectionPlanItem::getGenerateInspectionStatus, (Object)"1");
            updateWrapper.lambda().eq(ParentEntity::getId, (Object)planItem.getId());
            this.elsInspectionPlanItemService.update((Wrapper)updateWrapper);
            successInspectionNumberList.add(resultInspectionVO.getDocumentsSerialNumber());
        }
        this.updateHeadStatus(head.getId());
        StringBuilder stringBuilder = this.successGenerate(successInspectionNumberList);
        String successMsg = I18nUtil.translate((String)"i18n_alert_bLLRWWHBmtWWWWW_775b14fb", (String)"\u751f\u6210\u6210\u529f\uff0c\u73b0\u573a\u8003\u5bdf\u5355\uff1a${0}", (String[])new String[]{stringBuilder.toString()});
        return Result.ok((String)successMsg);
    }

    private void setInspectionStandard(ElsInspectionStandardHeadServiceImpl standardHeadService, ElsInspectionPlanItem planItem, PurchaseInspectionHeadSaveVO purchaseInspectionHeadSaveVO) {
        if (StrUtil.isBlank((CharSequence)planItem.getInspectionStandardId())) {
            return;
        }
        ElsInspectionStandardHeadSubmitVO standardHeadVO = standardHeadService.getById(planItem.getInspectionStandardId());
        purchaseInspectionHeadSaveVO.setInspectionStandardName(standardHeadVO.getInspectionStandardName());
        purchaseInspectionHeadSaveVO.setInspectionStandardClassify(standardHeadVO.getClassify());
        purchaseInspectionHeadSaveVO.setInspectionStandardVersion(standardHeadVO.getVersionNumber());
        purchaseInspectionHeadSaveVO.setStandardFullMarks(standardHeadVO.getStandardFullMarks());
        purchaseInspectionHeadSaveVO.setQualifiedPoints(standardHeadVO.getQualifiedPoints());
        purchaseInspectionHeadSaveVO.setTotalScore(standardHeadVO.getTotalScore());
        List<PurchaseInspectionItemVo> inspectionItemVoList = standardHeadVO.getItemList().stream().map(inspectionStandardItem -> {
            PurchaseInspectionItemVo inspectionItemVo = new PurchaseInspectionItemVo();
            inspectionItemVo.setInspectionStandardItemId(inspectionStandardItem.getId());
            return inspectionItemVo;
        }).collect(Collectors.toList());
        purchaseInspectionHeadSaveVO.setInspectionItemList(inspectionItemVoList);
    }

    @Override
    public List<CountVO> counts(ElsInspectionPlanHead head) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"status", "count(0) as participateQuantity"});
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"status");
        List list = this.list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(ElsInspectionPlanHead::getStatus, ElsInspectionPlanHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, (long)all.intValue()));
        List statusDictList = this.invokeBaseRpcService.queryDictItemsByCode("inspectionPlanStatus", TenantContext.getTenant());
        for (DictDTO status : statusDictList) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), (long)total.intValue()));
        }
        return result;
    }

    @Override
    public void caseClosedWriteBackPlanItem(PurchaseInspectionHead inspectionHead) {
        QueryWrapper planItemQueryWrapper = new QueryWrapper();
        planItemQueryWrapper.lambda().eq(ElsInspectionPlanItem::getInspectionNumber, (Object)inspectionHead.getDocumentsSerialNumber());
        planItemQueryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)inspectionHead.getElsAccount());
        ElsInspectionPlanItem planItem = (ElsInspectionPlanItem)((Object)this.elsInspectionPlanItemService.getOne((Wrapper)planItemQueryWrapper));
        if (Objects.isNull((Object)planItem)) {
            return;
        }
        if (Objects.nonNull(planItem.getActualCompletionDate())) {
            return;
        }
        Date actualCompletionDate = new Date();
        PurchaseInspectionPlanServiceImpl purchaseInspectionPlanService = (PurchaseInspectionPlanServiceImpl)SpringContextUtils.getBean(PurchaseInspectionPlanServiceImpl.class);
        List<PurchaseInspectionPlan> purchaseInspectionPlans = purchaseInspectionPlanService.selectByMainId(inspectionHead.getId());
        List finishPlanList = purchaseInspectionPlans.stream().filter(plan -> "4".equals(plan.getPlanStage()) && Objects.nonNull(plan.getActualFinishTime())).collect(Collectors.toList());
        if (finishPlanList.size() > 0) {
            actualCompletionDate = ((PurchaseInspectionPlan)((Object)finishPlanList.get(0))).getActualFinishTime();
        }
        UpdateWrapper planItemUpdateWrapper = new UpdateWrapper();
        planItemUpdateWrapper.lambda().set(ElsInspectionPlanItem::getInspectScore, (Object)inspectionHead.getInspectScore());
        planItemUpdateWrapper.lambda().set(ElsInspectionPlanItem::getInspectionConclusion, (Object)inspectionHead.getInspectionConclusion());
        planItemUpdateWrapper.lambda().set(ElsInspectionPlanItem::getScoreGrade, (Object)inspectionHead.getScoreGrade());
        planItemUpdateWrapper.lambda().set(ElsInspectionPlanItem::getActualCompletionDate, (Object)actualCompletionDate);
        planItemUpdateWrapper.lambda().eq(ParentEntity::getId, (Object)planItem.getId());
        this.elsInspectionPlanItemService.update((Wrapper)planItemUpdateWrapper);
    }

    @Override
    public void deletedOrCancelWriteBackPlanItem(PurchaseInspectionHead inspectionHead) {
        QueryWrapper planItemQueryWrapper = new QueryWrapper();
        planItemQueryWrapper.lambda().eq(ElsInspectionPlanItem::getInspectionNumber, (Object)inspectionHead.getDocumentsSerialNumber());
        ElsInspectionPlanItem planItem = (ElsInspectionPlanItem)((Object)this.elsInspectionPlanItemService.getOne((Wrapper)planItemQueryWrapper));
        if (Objects.isNull((Object)planItem)) {
            return;
        }
        UpdateWrapper planItemUpdateWrapper = new UpdateWrapper();
        planItemUpdateWrapper.lambda().set(ElsInspectionPlanItem::getInspectScore, null);
        planItemUpdateWrapper.lambda().set(ElsInspectionPlanItem::getInspectionConclusion, null);
        planItemUpdateWrapper.lambda().set(ElsInspectionPlanItem::getScoreGrade, null);
        planItemUpdateWrapper.lambda().set(ElsInspectionPlanItem::getActualCompletionDate, null);
        planItemUpdateWrapper.lambda().set(ElsInspectionPlanItem::getInspectionNumber, null);
        planItemUpdateWrapper.lambda().set(ElsInspectionPlanItem::getGenerateInspectionStatus, (Object)"0");
        planItemUpdateWrapper.lambda().eq(ParentEntity::getId, (Object)planItem.getId());
        this.elsInspectionPlanItemService.update((Wrapper)planItemUpdateWrapper);
        this.updateHeadStatus(planItem.getHeadId());
    }

    private void setInspectionTemplate(ElsInspectionPlanItem planItem, PurchaseInspectionHeadSaveVO purchaseInspectionHeadSaveVO) {
        if (StrUtil.isNotBlank((CharSequence)planItem.getInspectionTemplateNumber())) {
            purchaseInspectionHeadSaveVO.setTemplateAccount(planItem.getInspectionTemplateElsAccount());
            purchaseInspectionHeadSaveVO.setTemplateName(planItem.getInspectionTemplateName());
            purchaseInspectionHeadSaveVO.setTemplateNumber(planItem.getInspectionTemplateNumber());
            purchaseInspectionHeadSaveVO.setTemplateVersion(Integer.valueOf(planItem.getInspectionTemplateVersion()));
        } else {
            List list = this.templateRpcService.getDefaultTemplateByType("siteInspection");
            if (list.isEmpty()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_businessTemplate", (String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            }
            TemplateHeadDTO templateHead = (TemplateHeadDTO)list.get(0);
            purchaseInspectionHeadSaveVO.setTemplateAccount(templateHead.getElsAccount());
            purchaseInspectionHeadSaveVO.setTemplateName(templateHead.getTemplateName());
            purchaseInspectionHeadSaveVO.setTemplateNumber(templateHead.getTemplateNumber());
            purchaseInspectionHeadSaveVO.setTemplateVersion(templateHead.getTemplateVersion());
        }
    }

    private StringBuilder successGenerate(List<String> inspectionNumberList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < inspectionNumberList.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(inspectionNumberList.get(i));
        }
        return stringBuilder;
    }

    private void updateHeadStatus(String id) {
        List<ElsInspectionPlanItem> itemList = this.elsInspectionPlanItemService.selectByMainId(id);
        long count = itemList.stream().filter(item -> "0".equals(item.getGenerateInspectionStatus())).count();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (count == (long)itemList.size()) {
            updateWrapper.lambda().set(ElsInspectionPlanHead::getStatus, (Object)"1");
        } else if (count == BigDecimal.ZERO.longValue()) {
            updateWrapper.lambda().set(ElsInspectionPlanHead::getStatus, (Object)"3");
        } else {
            updateWrapper.lambda().set(ElsInspectionPlanHead::getStatus, (Object)"2");
        }
        updateWrapper.lambda().eq(ParentEntity::getId, (Object)id);
        this.update((Wrapper)updateWrapper);
    }
}

