/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.spcn.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.ecn.rpc.service.EcnInvokeAccountRpcService;
import com.els.modules.ecn.rpc.service.EcnInvokeSupplierRpcService;
import com.els.modules.spcn.entity.PurchaseSpcn;
import com.els.modules.spcn.entity.SaleSpcn;
import com.els.modules.spcn.enumerate.PurchaseConfirmStatusEnum;
import com.els.modules.spcn.enumerate.SpcnStatusEnum;
import com.els.modules.spcn.service.PurchaseSpcnService;
import com.els.modules.spcn.service.SaleSpcnService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="spcnRpcAdapter")
public class SpcnAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseSpcnService purchaseSpcnService;
    @Autowired
    private EcnInvokeAccountRpcService ecnInvokeAccountRpcService;
    @Autowired
    private SaleSpcnService saleSpcnService;
    @Resource
    private EcnInvokeSupplierRpcService ecnInvokeSupplierRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseSpcn head = (PurchaseSpcn)((Object)this.purchaseSpcnService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallBackDTO) {
        SaleSpcn saleSpcn;
        PurchaseSpcn purchaseEcn = (PurchaseSpcn)((Object)this.purchaseSpcnService.getById((Serializable)((Object)flowCallBackDTO.getBusinessId())));
        purchaseEcn.setAuditStatus(auditStatus);
        purchaseEcn.setFlowId(flowCallBackDTO.getProcessInstanceId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            purchaseEcn.setSpcnStatus(SpcnStatusEnum.NORMAL.getValue());
            purchaseEcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.CONFIRMED.getValue());
            saleSpcn = (SaleSpcn)((Object)this.saleSpcnService.getById((Serializable)((Object)purchaseEcn.getRelationId())));
            saleSpcn.setSpcnStatus(SpcnStatusEnum.NORMAL.getValue());
            saleSpcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.CONFIRMED.getValue());
            this.saleSpcnService.updateById((Object)saleSpcn);
        }
        if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            purchaseEcn.setSpcnStatus(SpcnStatusEnum.CANCELLATION.getValue());
            purchaseEcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.REFUSED.getValue());
            saleSpcn = (SaleSpcn)((Object)this.saleSpcnService.getById((Serializable)((Object)purchaseEcn.getRelationId())));
            saleSpcn.setSpcnStatus(SpcnStatusEnum.CANCELLATION.getValue());
            saleSpcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.REFUSED.getValue());
            this.saleSpcnService.updateById((Object)saleSpcn);
        }
        this.purchaseSpcnService.updateById((Object)purchaseEcn);
        saleSpcn = (SaleSpcn)((Object)this.saleSpcnService.getById((Serializable)((Object)purchaseEcn.getRelationId())));
        saleSpcn.setAuditStatus(auditStatus);
        this.saleSpcnService.updateById((Object)saleSpcn);
    }
}

