/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ecn.adapter;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.SrmUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.ecn.entity.EcnBuyerList;
import com.els.modules.ecn.entity.EcnOrderDetail;
import com.els.modules.ecn.entity.EcnSupplierList;
import com.els.modules.ecn.entity.PurchaseEcn;
import com.els.modules.ecn.entity.SaleEcn;
import com.els.modules.ecn.entity.SaleEcnOrderDetail;
import com.els.modules.ecn.enumerate.EcnStatusEnum;
import com.els.modules.ecn.rpc.service.EcnInvokeAccountRpcService;
import com.els.modules.ecn.rpc.service.EcnInvokeSupplierRpcService;
import com.els.modules.ecn.service.EcnBuyerListService;
import com.els.modules.ecn.service.EcnOrderDetailService;
import com.els.modules.ecn.service.EcnSupplierListService;
import com.els.modules.ecn.service.PurchaseEcnService;
import com.els.modules.ecn.service.SaleEcnOrderDetailService;
import com.els.modules.ecn.service.SaleEcnService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;

@RpcService(value="ecnRpcAdapter")
public class EcnAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseEcnService purchaseEcnService;
    @Resource
    private EcnSupplierListService ecnSupplierListService;
    @Resource
    private SaleEcnService saleEcnService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleEcnOrderDetailService saleEcnOrderDetailService;
    @Resource
    private EcnBuyerListService ecnBuyerListService;
    @Resource
    private EcnOrderDetailService ecnOrderDetailService;
    @Resource
    private EcnInvokeAccountRpcService ecnInvokeAccountRpcService;
    @Resource
    private EcnInvokeSupplierRpcService ecnInvokeSupplierRpcService;
    @Resource
    private CoreInvokeSupplierRpcService coreInvokeSupplierRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseEcn head = (PurchaseEcn)((Object)this.purchaseEcnService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseEcn purchaseEcn = (PurchaseEcn)((Object)this.purchaseEcnService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        purchaseEcn.setAuditStatus(auditStatus);
        purchaseEcn.setFlowId(flowCallbackDTO.getProcessInstanceId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            purchaseEcn.setEcnStatus(EcnStatusEnum.NORMAL.getValue());
            if ("1".equals(purchaseEcn.getAutoSend())) {
                List<EcnSupplierList> supplierLists = this.ecnSupplierListService.selectByMainId(purchaseEcn.getId());
                List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseEcn.getId());
                List<EcnBuyerList> buyerLists = this.ecnBuyerListService.selectByMainId(purchaseEcn.getId());
                List<EcnOrderDetail> orderDetails = this.ecnOrderDetailService.selectByMainId(purchaseEcn.getId());
                this.sendSupplier(purchaseEcn, supplierLists, attachments, orderDetails);
                purchaseEcn.setSendStatus("1");
                this.sendBuyer(purchaseEcn, buyerLists);
                purchaseEcn.setInformBuyer("1");
            }
        }
        this.purchaseEcnService.updateById((Object)purchaseEcn);
    }

    private void sendBuyer(PurchaseEcn purchaseEcn, List<EcnBuyerList> buyerLists) {
        if (buyerLists != null) {
            HashMap receiverMap = new HashMap();
            ArrayList<ElsSubAccountDTO> accounts = new ArrayList<ElsSubAccountDTO>();
            for (EcnBuyerList ecnBuyerList : buyerLists) {
                ElsSubAccountDTO account = this.ecnInvokeAccountRpcService.getAccount(ecnBuyerList.getElsAccount(), ecnBuyerList.getSubAccount());
                accounts.add(account);
            }
            receiverMap.put(purchaseEcn.getElsAccount(), accounts);
            MsgParamsVO paramsVO = new MsgParamsVO();
            paramsVO.setParams((Object)purchaseEcn);
            paramsVO.setReceiverMap(receiverMap);
        }
    }

    private void sendSupplier(PurchaseEcn purchaseEcn, List<EcnSupplierList> supplierLists, List<PurchaseAttachmentDTO> attachments, List<EcnOrderDetail> orderDetails) {
        if (supplierLists != null && supplierLists.size() > 0) {
            SaleEcn ecn = new SaleEcn();
            BeanUtils.copyProperties((Object)((Object)purchaseEcn), (Object)((Object)ecn));
            ArrayList<String> recevieAccount = new ArrayList<String>();
            HashMap<String, List> receiverMap = new HashMap<String, List>();
            for (EcnSupplierList ecnSupplierList : supplierLists) {
                ecn.setId(null);
                ecn.setRelationId(purchaseEcn.getId());
                ecn.setElsAccount(ecnSupplierList.getToElsAccount());
                ecn.setToElsAccount(purchaseEcn.getElsAccount());
                ecn.setSupplierName(ecnSupplierList.getSupplierName());
                ecn.setViewStatus("0");
                ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
                AttachmentSendDTO sendDTO = new AttachmentSendDTO();
                if (attachments != null) {
                    sendDTO.setHeadId(purchaseEcn.getId());
                    sendDTO.setElsAccount(purchaseEcn.getElsAccount());
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(purchaseEcn.getId(), ecn.getElsAccount());
                    sendDTO.setToSend(map);
                }
                ArrayList<SaleEcnOrderDetail> saleEcnOrderDetails = null;
                if (orderDetails != null) {
                    saleEcnOrderDetails = new ArrayList<SaleEcnOrderDetail>();
                    for (EcnOrderDetail detail : orderDetails) {
                        if (!ecnSupplierList.getToElsAccount().equals(detail.getToElsAccount())) continue;
                        SaleEcnOrderDetail saleEcnOrderDetail = new SaleEcnOrderDetail();
                        BeanUtils.copyProperties((Object)((Object)detail), (Object)((Object)saleEcnOrderDetail));
                        saleEcnOrderDetail.setElsAccount(ecnSupplierList.getToElsAccount());
                        saleEcnOrderDetail.setToElsAccount(purchaseEcn.getElsAccount());
                        saleEcnOrderDetail.setId(null);
                        saleEcnOrderDetail.setBusAccount(purchaseEcn.getElsAccount());
                        saleEcnOrderDetail.setPurchaseName(purchaseEcn.getPurchaseName());
                        saleEcnOrderDetails.add(saleEcnOrderDetail);
                    }
                }
                Map toSend = sendDTO.getToSend() == null ? new ConcurrentHashMap() : sendDTO.getToSend();
                for (String saleHeadId : toSend.keySet()) {
                    String saleElsAccount = (String)toSend.get(saleHeadId);
                    for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
                        SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
                        BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
                        saleAttachment.setId(IdWorker.getIdStr());
                        saleAttachment.setElsAccount(saleElsAccount);
                        saleAttachment.setRelationId(purchaseAttachment.getId());
                        saleAttachments.add(saleAttachment);
                    }
                }
                this.saleEcnService.saveSaleEcn(ecn, saleAttachments, saleEcnOrderDetails);
                recevieAccount.add(ecnSupplierList.getToElsAccount());
            }
            Map map = this.coreInvokeSupplierRpcService.getSupplierContacts(TenantContext.getTenant(), recevieAccount, "ecn", "publish");
            for (String string : map.keySet()) {
                if (map.get(string) == null) continue;
                List accountDTOs = (List)map.get(string);
                receiverMap.put(string, accountDTOs);
            }
            MsgParamsVO msgParamsVO = new MsgParamsVO();
            msgParamsVO.setParams((Object)purchaseEcn);
            msgParamsVO.setReceiverMap(receiverMap);
        }
    }
}

