/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ecn.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.ecn.entity.SaleEcn;
import com.els.modules.ecn.entity.SaleEcnOrderDetail;
import com.els.modules.ecn.rpc.service.EcnInvokeBaseRpcService;
import com.els.modules.ecn.service.SaleEcnOrderDetailService;
import com.els.modules.ecn.service.SaleEcnService;
import com.els.modules.ecn.vo.SaleEcnVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9500\u552e\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u5355")
@RestController
@RequestMapping(value={"/ecn/saleEcn"})
public class SaleEcnController
extends BaseController<SaleEcn, SaleEcnService> {
    @Autowired
    private SaleEcnService saleEcnService;
    @Autowired
    private EcnInvokeBaseRpcService ecnInvokeBaseRpcService;
    @Autowired
    private SaleEcnOrderDetailService saleEcnOrderDetailService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"ecn#saleEcnHead:list"})
    public Result<?> queryPageList(SaleEcn saleEcn, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleEcn), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleEcnService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u5355-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"ecn#saleEcnHead:add"})
    public Result<?> add(@RequestBody SaleEcn saleEcn) {
        this.saleEcnService.saveSaleEcn(saleEcn, null, null);
        return Result.ok((Object)((Object)saleEcn));
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u5355-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"ecn#saleEcnHead:edit"})
    public Result<?> edit(@RequestBody SaleEcn saleEcn) {
        this.saleEcnService.updateSaleEcn(saleEcn);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u5355-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"ecn#saleEcnHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleEcnService.delSaleEcn(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u5355-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"ecn#saleEcnHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.saleEcnService.delBatchSaleEcn(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"ecn#saleEcnHead:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleEcn saleEcn = (SaleEcn)((Object)this.saleEcnService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleEcnVO ecnVO = new SaleEcnVO();
        BeanUtils.copyProperties((Object)((Object)saleEcn), (Object)((Object)ecnVO));
        List<SaleAttachmentDTO> attachments = this.ecnInvokeBaseRpcService.saleSelectByMainId(id);
        ecnVO.setAttachments(attachments);
        List<SaleEcnOrderDetail> orderDetails = this.saleEcnOrderDetailService.selectByMainId(id);
        ecnVO.setOrderDetails(orderDetails);
        return Result.ok((Object)((Object)ecnVO));
    }

    @AutoLog(value="\u9500\u552e\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u5355-\u67e5\u770b")
    @Operation(summary="\u67e5\u770b", description="\u67e5\u770b")
    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"ecn#saleEcnHead:view"})
    public Result<?> view(@RequestParam(name="id") String id) {
        this.saleEcnService.view(id);
        return this.commonSuccessResult(4);
    }
}

