/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.adapter;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SrmUtil;
import com.els.common.util.SysUtil;
import com.els.modules.quality.entity.PurchaseQualityCheckHead;
import com.els.modules.quality.entity.PurchaseQualityCheckItem;
import com.els.modules.quality.mapper.PurchaseQualityCheckItemMapper;
import com.els.modules.quality.service.PurchaseQualityCheckHeadService;
import com.els.modules.quality.service.PurchaseQualityCheckItemService;
import com.els.modules.quality.vo.PurchaseQualityCheckHeadVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseQualityCheckRpcServiceImpl")
public class PurchaseQualityCheckAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseQualityCheckHeadService purchaseQualityCheckHeadService;
    @Autowired
    private PurchaseQualityCheckItemService purchaseQualityCheckItemService;
    @Autowired
    private PurchaseQualityCheckItemMapper purchaseQualityCheckItemMapper;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseQualityCheckHeadVO headVO = (PurchaseQualityCheckHeadVO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), PurchaseQualityCheckHeadVO.class));
        PurchaseQualityCheckHead head = new PurchaseQualityCheckHead();
        BeanUtil.copyProperties((Object)((Object)headVO), (Object)((Object)head), (String[])new String[0]);
        head.setCheckStatus("1");
        this.purchaseQualityCheckHeadService.updateMain(head, headVO.getPurchaseQualityCheckItemList());
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseQualityCheckHead head = (PurchaseQualityCheckHead)((Object)this.purchaseQualityCheckHeadService.getById((Serializable)((Object)id)));
        PurchaseQualityCheckHeadVO purchaseQualityCheckHeadVO = new PurchaseQualityCheckHeadVO();
        BeanUtil.copyProperties((Object)((Object)head), (Object)((Object)purchaseQualityCheckHeadVO), (String[])new String[0]);
        purchaseQualityCheckHeadVO.setPurchaseQualityCheckItemList(this.purchaseQualityCheckItemMapper.selectByMainId(id));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        ReentrantLock lock = new ReentrantLock();
        try {
            lock.lock();
            PurchaseQualityCheckHead updateHead = new PurchaseQualityCheckHead();
            updateHead.setId(flowCallbackDTO.getBusinessId());
            updateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
            updateHead.setAuditStatus(auditStatus);
            this.purchaseQualityCheckHeadService.updateById((Object)updateHead);
            if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
                PurchaseQualityCheckHead head = (PurchaseQualityCheckHead)((Object)this.purchaseQualityCheckHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
                PurchaseQualityCheckHeadVO purchaseQualityCheckHeadVO = new PurchaseQualityCheckHeadVO();
                BeanUtil.copyProperties((Object)((Object)head), (Object)((Object)purchaseQualityCheckHeadVO), (String[])new String[0]);
                purchaseQualityCheckHeadVO.setPurchaseQualityCheckItemList(this.purchaseQualityCheckItemMapper.selectByMainId(flowCallbackDTO.getBusinessId()));
                this.updateItemTestResult(purchaseQualityCheckHeadVO);
                List<PurchaseQualityCheckItem> checkItemList = this.purchaseQualityCheckItemService.selectByMainId(flowCallbackDTO.getBusinessId());
                this.purchaseQualityCheckHeadService.publish(head, checkItemList);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void updateItemTestResult(PurchaseQualityCheckHeadVO headVO) {
        List<PurchaseQualityCheckItem> itemList = headVO.getPurchaseQualityCheckItemList();
        this.purchaseQualityCheckItemMapper.deleteByMainId(headVO.getId());
        for (PurchaseQualityCheckItem item : itemList) {
            String decisionConclusion;
            SysUtil.setSysParam((BaseEntity)item, (BaseEntity)headVO);
            item.setHeadId(headVO.getId());
            if (StrUtil.isBlank((CharSequence)item.getId())) {
                item.setId(null);
            }
            if ("Accept".equals(decisionConclusion = item.getDecisionConclusion())) {
                item.setTestResult("0");
                continue;
            }
            item.setTestResult("1");
        }
        if (itemList != null && !itemList.isEmpty()) {
            this.purchaseQualityCheckItemService.saveBatch(itemList);
        }
    }
}

