/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workorder.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.service.DictTranslateService;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.BusMessageUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.workorder.entity.WorkOrderHead;
import com.els.modules.workorder.entity.WorkOrderRecord;
import com.els.modules.workorder.enumerate.ContentTypeEnum;
import com.els.modules.workorder.enumerate.RecordSendStatusEnum;
import com.els.modules.workorder.enumerate.WorkOrderStatusEnum;
import com.els.modules.workorder.service.WorkOrderApiService;
import com.els.modules.workorder.service.WorkOrderHeadService;
import com.els.modules.workorder.service.WorkOrderRecordService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="optWorkOrder")
public class WorkOrderOptServiceImpl
implements WorkOrderApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkOrderOptServiceImpl.class);
    @Autowired
    private WorkOrderRecordService workOrderRecordService;
    @Autowired
    private WorkOrderHeadService workOrderHeadService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public String invoke(com.alibaba.fastjson2.JSONObject param) {
        String id = param.getString("id");
        String currentStatus = param.getString("currentStatus");
        WorkOrderHead updateHead = new WorkOrderHead();
        updateHead.setId(id);
        updateHead.setOrderStatus(currentStatus);
        updateHead.setOrderHandler(param.getString("recipient"));
        updateHead.setProcessSpeed(param.getBigDecimal("processSpeed"));
        updateHead.setServiceAttitude(param.getBigDecimal("serviceAttitude"));
        updateHead.setServiceQuality(param.getBigDecimal("serviceQuality"));
        updateHead.setOrderSolution(param.getString("orderSolution"));
        if (currentStatus.equals(WorkOrderStatusEnum.FINISHED.getValue()) && param.getBigDecimal("processSpeed") == null) {
            updateHead.setCompleteTime(new Date());
        }
        this.workOrderHeadService.updateById((Object)updateHead);
        WorkOrderRecord orderRecord = (WorkOrderRecord)((Object)JSON.parseObject((String)param.getJSONObject("record").toString(), WorkOrderRecord.class));
        orderRecord.setContentType(ContentTypeEnum.OTHER.getValue());
        orderRecord.setSendStatus(RecordSendStatusEnum.SEND_SUCCESS.getValue());
        this.workOrderRecordService.save((Object)orderRecord);
        com.alibaba.fastjson2.JSONObject msgBody = SysUtil.objectToJSON2((Object)((Object)orderRecord));
        msgBody.put((Object)"id", (Object)orderRecord.getHeadId());
        this.redisUtil.publish("order-record-topic", (Object)msgBody.toJSONString(new JSONWriter.Feature[0]));
        WorkOrderHead orderHead = (WorkOrderHead)((Object)this.workOrderHeadService.getById((Serializable)((Object)id)));
        if (orderHead == null) {
            return "SUCCESS";
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setElsAccount("100000");
        loginUser.setSubAccount("admin");
        loginUser.setRealname("system");
        loginUser.setCompanyName("\u4f01\u4f01\u901a");
        loginUser.setCompanyShortName("\u4f01\u4f01\u901a");
        loginUser.setEnterpriseName("\u6df1\u5733\u5e02\u4f01\u4f01\u901a\u79d1\u6280\u6709\u9650\u516c\u53f8");
        JSONObject object = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)orderHead, new DictTranslateAspectParam());
        HashMap<String, List<String>> receiveElsAccountMap = new HashMap<String, List<String>>();
        receiveElsAccountMap.put(orderHead.getSubmitAccount(), Lists.newArrayList((Object[])new String[]{orderHead.getCreateBy()}));
        this.sendMsgToSubAccount(orderHead.getSubmitAccount(), "workOrder", "workOrder_Change", loginUser, receiveElsAccountMap, object, "id=" + orderHead.getId());
        return "SUCCESS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(String busAccount, String businessType, String operateType, String businessId, String businessBean, List<String> toElsAccountList, LoginUser loginUser) {
        TenantContext.setTenant((String)loginUser.getElsAccount());
        try {
            if (StrUtil.isBlank((CharSequence)busAccount) || toElsAccountList == null || toElsAccountList.isEmpty() || StrUtil.isBlank((CharSequence)businessId) || StrUtil.isBlank((CharSequence)businessBean) || StrUtil.isBlank((CharSequence)businessType) || StrUtil.isBlank((CharSequence)operateType)) {
                return;
            }
            com.alibaba.fastjson2.JSONObject msgObj = new com.alibaba.fastjson2.JSONObject();
            msgObj.put((Object)"msgId", (Object)IdWorker.getIdStr());
            msgObj.put((Object)"busAccount", (Object)busAccount);
            msgObj.put((Object)"elsAccount", (Object)TenantContext.getTenant());
            msgObj.put((Object)"businessType", (Object)businessType);
            msgObj.put((Object)"operateType", (Object)operateType);
            msgObj.put((Object)"businessId", (Object)businessId);
            msgObj.put((Object)"businessBean", (Object)businessBean);
            msgObj.put((Object)"sendObj", (Object)loginUser);
            msgObj.put((Object)"toElsAccountList", (Object)JSONArray.parseArray((String)JSON.toJSONString(toElsAccountList), (JSONReader.Feature[])new JSONReader.Feature[0]));
            BusMessageUtil.sendBusMsg((String)msgObj.toJSONString(new JSONWriter.Feature[0]), (String)businessId);
        }
        finally {
            TenantContext.clear();
        }
    }

    private Map<String, Object> invoke(String methodName, Class[] argsClass, Object[] args) {
        String className = "com.els.rpc.service.CoreInvokeSupplierRpcService";
        try {
            Object obj = SpringContextUtils.getBean(Class.forName(className));
            Method methodReflect = obj.getClass().getMethod(methodName, argsClass);
            return (Map)methodReflect.invoke(obj, args);
        }
        catch (Exception e) {
            log.error("WorkOrderOptServiceImpl invoke :{},{}", (Object)methodName, (Object)e.getMessage());
            return new HashMap<String, Object>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsgToSubAccount(String purchaseElsAccount, String businessType, String operateType, LoginUser loginUser, Map<String, List<String>> receiveElsAccountMap, Object object, String urlParam) {
        try {
            ArrayList<String> keys = new ArrayList<String>(receiveElsAccountMap.keySet());
            Map<String, Object> receiverMap = this.invoke("getSupplierContacts", new Class[]{String.class, List.class, String.class, String.class}, new Object[]{purchaseElsAccount, keys, businessType, operateType});
            Map<String, Object> receiveSubAccountMap = this.invoke("getSupplierContactsAccount", new Class[]{Map.class}, new Object[]{receiveElsAccountMap});
            log.info("WorkOrderOptServiceImpl receiverMap:{}", receiverMap);
            log.info("receiveSubAccountMap receiverMap:{}", receiveSubAccountMap);
            com.alibaba.fastjson2.JSONObject msgObj = new com.alibaba.fastjson2.JSONObject();
            msgObj.put((Object)"msgKey", (Object)IdWorker.getIdStr());
            msgObj.put((Object)"busAccount", (Object)purchaseElsAccount);
            msgObj.put((Object)"businessType", (Object)businessType);
            msgObj.put((Object)"operateType", (Object)operateType);
            msgObj.put((Object)"businessObj", object);
            msgObj.put((Object)"sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String toElsAccount : receiverMap.keySet()) {
                Object subAccountList = receiveSubAccountMap.get(toElsAccount);
                JSONArray toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiverMap.get(toElsAccount)), (JSONReader.Feature[])new JSONReader.Feature[0]);
                if (null != subAccountList) {
                    toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)subAccountList), (JSONReader.Feature[])new JSONReader.Feature[0]);
                }
                com.alibaba.fastjson2.JSONObject receiveObj = new com.alibaba.fastjson2.JSONObject();
                receiveObj.put((Object)"toElsAccount", (Object)toElsAccount);
                receiveObj.put((Object)"urlParam", (Object)urlParam);
                receiveObj.put((Object)"toSubAccountList", (Object)toSubAccountArray);
                array.add((Object)receiveObj);
            }
            msgObj.put((Object)"receiveList", (Object)array);
            TenantContext.setTenant((String)loginUser.getElsAccount());
            BusMessageUtil.sendBusMsg((String)msgObj.toJSONString(new JSONWriter.Feature[0]), (String)IdWorker.getIdStr());
        }
        catch (Exception e) {
            log.error("WorkOrderOptServiceImpl sendMessage :{}", (Object)e.getMessage());
        }
        finally {
            TenantContext.clear();
        }
    }
}

