/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.mould.entity.PurchaseMouldData;
import com.els.modules.mould.entity.PurchaseMouldScrapped;
import com.els.modules.mould.entity.SaleMouldData;
import com.els.modules.mould.entity.SaleMouldScrapped;
import com.els.modules.mould.enumerate.ScrappedStatusEnum;
import com.els.modules.mould.enumerate.TargetStatusEnum;
import com.els.modules.mould.mapper.PurchaseMouldScrappedMapper;
import com.els.modules.mould.mapper.SaleMouldScrappedMapper;
import com.els.modules.mould.service.PurchaseMouldDataService;
import com.els.modules.mould.service.SaleMouldDataService;
import com.els.modules.mould.service.SaleMouldScrappedService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleMouldScrappedServiceImpl
extends BaseServiceImpl<SaleMouldScrappedMapper, SaleMouldScrapped>
implements SaleMouldScrappedService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleMouldDataService saleMouldDataService;
    @Autowired
    private PurchaseMouldDataService purchaseMouldDataService;
    @Resource
    private PurchaseMouldScrappedMapper purchaseMouldScrappedMapper;

    @Override
    @SrmTransaction
    public SaleMouldScrapped add(SaleMouldData saleMouldData) {
        SaleMouldScrapped scrapped = new SaleMouldScrapped();
        if (!"1".equals(saleMouldData.getMouldStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_APzExOHckutk_7ba643f8", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c"));
        }
        SaleMouldData mouldData = (SaleMouldData)((Object)this.saleMouldDataService.getById((Serializable)((Object)saleMouldData.getId())));
        mouldData.setTargetStatus(TargetStatusEnum.SCRAPPED.getValue());
        mouldData.setDataVersion(saleMouldData.getDataVersion());
        boolean update = this.saleMouldDataService.updateById((Object)mouldData);
        if (!update) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        BeanUtils.copyProperties((Object)((Object)saleMouldData), (Object)((Object)scrapped));
        scrapped.setMouldDataId(saleMouldData.getId());
        scrapped.setId(null);
        scrapped.setRelationId(null);
        scrapped.setElsAccount(TenantContext.getTenant());
        scrapped.setApplyUser(this.getLoginSubAndName());
        scrapped.setScrappedStatus(ScrappedStatusEnum.NEW.getValue());
        String scrappedNumber = this.invokeBaseRpcService.getNextCode("mouldScrapped", (Object)scrapped, scrapped.getBusAccount());
        scrapped.setScrappedNumber(scrappedNumber);
        ((SaleMouldScrappedMapper)this.baseMapper).insert((Object)scrapped);
        return scrapped;
    }

    @Override
    public void edit(SaleMouldScrapped scrapped) {
        scrapped.setScrappedStatus(ScrappedStatusEnum.NEW.getValue());
        ((SaleMouldScrappedMapper)this.baseMapper).updateById((Object)scrapped);
    }

    @Override
    @SrmTransaction
    public void send(SaleMouldScrapped scrapped) {
        Date now = new Date();
        scrapped.setRelationId(IdWorker.getIdStr());
        scrapped.setSendTime(now);
        scrapped.setApplyScrappedTime(now);
        scrapped.setScrappedStatus(ScrappedStatusEnum.SEND.getValue());
        ((SaleMouldScrappedMapper)this.baseMapper).updateById((Object)scrapped);
        PurchaseMouldScrapped purchaseScrapped = new PurchaseMouldScrapped();
        BeanUtils.copyProperties((Object)((Object)scrapped), (Object)((Object)purchaseScrapped));
        purchaseScrapped.setId(scrapped.getRelationId());
        purchaseScrapped.setRelationId(scrapped.getId());
        purchaseScrapped.setElsAccount(scrapped.getToElsAccount());
        purchaseScrapped.setToElsAccount(scrapped.getElsAccount());
        this.purchaseMouldScrappedMapper.insert((Object)purchaseScrapped);
        this.purchaseMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseMouldData::getRelationId, (Object)scrapped.getMouldDataId())).set(PurchaseMouldData::getTargetStatus, (Object)TargetStatusEnum.SCRAPPED.getValue()));
    }

    @Override
    @SrmTransaction
    public void delete(String id) {
        SaleMouldScrapped dbScrapped = (SaleMouldScrapped)((Object)((SaleMouldScrappedMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ScrappedStatusEnum.NEW.getValue().equals(dbScrapped.getScrappedStatus()), (String)I18nUtil.translate((String)"i18n_title_onlyDocumentsNewStatusDeleted", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u5220\u9664"));
        ((SaleMouldScrappedMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.saleMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ParentEntity::getId, (Object)dbScrapped.getMouldDataId())).set(SaleMouldData::getTargetStatus, null));
    }
}

