/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportItem;
import com.els.modules.quality.entity.SaleSupplierRectificationReportHead;
import com.els.modules.quality.entity.SaleSupplierRectificationReportItem;
import com.els.modules.quality.enumerate.SupplierRectificationItemStatusEnum;
import com.els.modules.quality.enumerate.SupplierRectificationStatusEnum;
import com.els.modules.quality.mapper.SaleSupplierRectificationReportHeadMapper;
import com.els.modules.quality.mapper.SaleSupplierRectificationReportItemMapper;
import com.els.modules.quality.service.PurchaseSupplierRectificationReportHeadService;
import com.els.modules.quality.service.PurchaseSupplierRectificationReportItemService;
import com.els.modules.quality.service.SaleSupplierRectificationReportHeadService;
import com.els.modules.quality.service.SaleSupplierRectificationReportItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleSupplierRectificationReportHeadServiceImpl
extends ServiceImpl<SaleSupplierRectificationReportHeadMapper, SaleSupplierRectificationReportHead>
implements SaleSupplierRectificationReportHeadService {
    @Resource
    private SaleSupplierRectificationReportHeadMapper saleSupplierRectificationReportHeadMapper;
    @Resource
    private SaleSupplierRectificationReportItemMapper saleSupplierRectificationReportItemMapper;
    @Autowired
    private SaleSupplierRectificationReportItemService saleSupplierRectificationReportItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleSupplierRectificationReportHead saleSupplierRectificationReportHead, List<SaleSupplierRectificationReportItem> saleSupplierRectificationReportItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        this.saleSupplierRectificationReportHeadMapper.insert((Object)saleSupplierRectificationReportHead);
        this.insertData(saleSupplierRectificationReportHead, saleSupplierRectificationReportItemList, saleAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleSupplierRectificationReportHead saleSupplierRectificationReportHead, List<SaleSupplierRectificationReportItem> saleSupplierRectificationReportItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        this.saleSupplierRectificationReportHeadMapper.updateById((Object)saleSupplierRectificationReportHead);
        this.insertData(saleSupplierRectificationReportHead, saleSupplierRectificationReportItemList, saleAttachmentList);
    }

    private void insertData(SaleSupplierRectificationReportHead saleSupplierRectificationReportHead, List<SaleSupplierRectificationReportItem> saleSupplierRectificationReportItemList, List<SaleAttachmentDTO> saleAttachmentList) {
        for (SaleSupplierRectificationReportItem entity : saleSupplierRectificationReportItemList) {
            entity.setHeadId(saleSupplierRectificationReportHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleSupplierRectificationReportHead);
        }
        if (!saleSupplierRectificationReportItemList.isEmpty()) {
            this.saleSupplierRectificationReportItemService.saveOrUpdateBatch(saleSupplierRectificationReportItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleSupplierRectificationReportItemMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
        this.saleSupplierRectificationReportHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleSupplierRectificationReportItemMapper.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(serializable.toString());
            this.saleSupplierRectificationReportHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void comfirmRectificationRow(SaleSupplierRectificationReportHead saleSupplierRectificationReportHead, List<SaleSupplierRectificationReportItem> saleSupplierRectificationReportItemList) {
        ArrayList<SaleSupplierRectificationReportItem> saleSupplierRectificationReportItems = new ArrayList<SaleSupplierRectificationReportItem>();
        ArrayList<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItemList = new ArrayList<PurchaseSupplierRectificationReportItem>();
        for (SaleSupplierRectificationReportItem saleSupplierRectificationReportItem : saleSupplierRectificationReportItemList) {
            SaleSupplierRectificationReportItem supplierRectificationReportItem = new SaleSupplierRectificationReportItem();
            PurchaseSupplierRectificationReportItem purchaseSupplierRectificationReportItem = new PurchaseSupplierRectificationReportItem();
            supplierRectificationReportItem.setId(saleSupplierRectificationReportItem.getId());
            purchaseSupplierRectificationReportItem.setId(saleSupplierRectificationReportItem.getRelationId());
            supplierRectificationReportItem.setItemStatus(SupplierRectificationItemStatusEnum.CONFIRM.getValue());
            purchaseSupplierRectificationReportItem.setItemStatus(SupplierRectificationItemStatusEnum.CONFIRM.getValue());
            saleSupplierRectificationReportItems.add(supplierRectificationReportItem);
            purchaseSupplierRectificationReportItemList.add(purchaseSupplierRectificationReportItem);
        }
        if (CollectionUtil.isNotEmpty(purchaseSupplierRectificationReportItemList)) {
            ((PurchaseSupplierRectificationReportItemService)SpringContextUtils.getBean(PurchaseSupplierRectificationReportItemService.class)).updateBatchById(purchaseSupplierRectificationReportItemList);
        }
        if (CollectionUtil.isNotEmpty(saleSupplierRectificationReportItems)) {
            ((SaleSupplierRectificationReportItemService)SpringContextUtils.getBean(SaleSupplierRectificationReportItemService.class)).updateBatchById(saleSupplierRectificationReportItems);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmRectification(SaleSupplierRectificationReportHead saleSupplierRectificationReportHead, List<SaleSupplierRectificationReportItem> saleSupplierRectificationReportItemList) {
        SaleSupplierRectificationReportHead supplierRectificationReportHead = new SaleSupplierRectificationReportHead();
        supplierRectificationReportHead.setId(saleSupplierRectificationReportHead.getId());
        supplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.EVALUATIONING.getValue());
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = new PurchaseSupplierRectificationReportHead();
        purchaseSupplierRectificationReportHead.setId(saleSupplierRectificationReportHead.getRelationId());
        purchaseSupplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.EVALUATIONING.getValue());
        this.updateById((Object)supplierRectificationReportHead);
        ((PurchaseSupplierRectificationReportHeadService)SpringContextUtils.getBean(PurchaseSupplierRectificationReportHeadService.class)).updateById((Object)purchaseSupplierRectificationReportHead);
        if (CollectionUtil.isNotEmpty(saleSupplierRectificationReportItemList)) {
            ArrayList<SaleSupplierRectificationReportItem> saleSupplierRectificationReportItems = new ArrayList<SaleSupplierRectificationReportItem>();
            ArrayList<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItems = new ArrayList<PurchaseSupplierRectificationReportItem>();
            for (SaleSupplierRectificationReportItem item : saleSupplierRectificationReportItemList) {
                SaleSupplierRectificationReportItem saleSupplierRectificationReportItem = new SaleSupplierRectificationReportItem();
                PurchaseSupplierRectificationReportItem purchaseSupplierRectificationReportItem = new PurchaseSupplierRectificationReportItem();
                saleSupplierRectificationReportItem.setId(item.getId());
                saleSupplierRectificationReportItem.setRealCause(item.getRealCause());
                saleSupplierRectificationReportItem.setPlanType(item.getPlanType());
                saleSupplierRectificationReportItem.setPlanDesc(item.getPlanDesc());
                saleSupplierRectificationReportItem.setSalePrincipal(item.getSalePrincipal());
                saleSupplierRectificationReportItem.setFinishTime(item.getFinishTime());
                BeanUtils.copyProperties((Object)((Object)saleSupplierRectificationReportItem), (Object)((Object)purchaseSupplierRectificationReportItem));
                purchaseSupplierRectificationReportItem.setId(item.getRelationId());
                saleSupplierRectificationReportItems.add(saleSupplierRectificationReportItem);
                purchaseSupplierRectificationReportItems.add(purchaseSupplierRectificationReportItem);
            }
            ((PurchaseSupplierRectificationReportItemService)SpringContextUtils.getBean(PurchaseSupplierRectificationReportItemService.class)).updateBatchById(purchaseSupplierRectificationReportItems);
            ((SaleSupplierRectificationReportItemService)SpringContextUtils.getBean(SaleSupplierRectificationReportItemService.class)).updateBatchById(saleSupplierRectificationReportItems);
        }
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(saleSupplierRectificationReportHead.getElsAccount());
        sendVO.setHeadId(saleSupplierRectificationReportHead.getId());
        HashMap<String, String> toSend = new HashMap<String, String>();
        toSend.put(saleSupplierRectificationReportHead.getRelationId(), saleSupplierRectificationReportHead.getToElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void refuseRectification(SaleSupplierRectificationReportHead saleSupplierRectificationReportHead, List<SaleAttachmentDTO> saleAttachmentDTOList) {
        SaleSupplierRectificationReportHead supplierRectificationReportHead = new SaleSupplierRectificationReportHead();
        supplierRectificationReportHead.setId(saleSupplierRectificationReportHead.getId());
        supplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.RETURNED.getValue());
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = new PurchaseSupplierRectificationReportHead();
        purchaseSupplierRectificationReportHead.setId(saleSupplierRectificationReportHead.getRelationId());
        purchaseSupplierRectificationReportHead.setRectificationStatus(SupplierRectificationStatusEnum.RETURNED.getValue());
        this.updateById((Object)supplierRectificationReportHead);
        if (CollectionUtil.isNotEmpty(saleAttachmentDTOList)) {
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setElsAccount(TenantContext.getTenant());
            sendVO.setHeadId(supplierRectificationReportHead.getId());
            HashMap<String, String> toSend = new HashMap<String, String>();
            toSend.put(purchaseSupplierRectificationReportHead.getId(), purchaseSupplierRectificationReportHead.getElsAccount());
            sendVO.setToSend(toSend);
            this.invokeBaseRpcService.sendSaleFile(sendVO);
        }
        ((PurchaseSupplierRectificationReportHeadService)SpringContextUtils.getBean(PurchaseSupplierRectificationReportHeadService.class)).updateById((Object)purchaseSupplierRectificationReportHead);
    }
}

